/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.BattleArenaController;
import mc.alk.arena.executors.CustomCommandExecutor;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.arenas.ArenaType;
import mc.alk.arena.serializers.ArenaSerializer;
import mc.alk.arena.serializers.ConfigSerializer;
import mc.alk.arena.serializers.MessageSerializer;
import mc.alk.arena.util.Log;
import org.bukkit.plugin.Plugin;

public class RegisteredCompetition {
    final Plugin plugin;
    final String competitionName;
    ConfigSerializer configSerializer;
    ArenaSerializer arenaSerializer;
    CustomCommandExecutor customExecutor;

    public RegisteredCompetition(Plugin plugin, String competitionName) {
        this.plugin = plugin;
        this.competitionName = competitionName;
    }

    public ConfigSerializer getConfigSerializer() {
        return this.configSerializer;
    }

    public void setConfigSerializer(ConfigSerializer serializer) {
        this.configSerializer = serializer;
    }

    public String getCompetitionName() {
        return this.competitionName;
    }

    public ArenaSerializer getArenaSerializer() {
        return this.arenaSerializer;
    }

    public void setArenaSerializer(ArenaSerializer arenaSerializer) {
        this.arenaSerializer = arenaSerializer;
    }

    public void reload() {
        this.reloadConfigType();
        this.reloadExecutors();
        this.reloadArenas();
        this.reloadMessages();
    }

    private void reloadMessages() {
        MessageSerializer.reloadConfig(this.competitionName);
    }

    public MessageSerializer getMessageSerializer() {
        return MessageSerializer.getMessageSerializer(this.competitionName);
    }

    private void reloadExecutors() {
    }

    private void reloadArenas() {
        BattleArenaController ac = BattleArena.getBAController();
        for (ArenaType type : ArenaType.getTypes(this.plugin)) {
            ac.removeAllArenas(type);
        }
        for (ArenaType type : ArenaType.getTypes(this.plugin)) {
            ArenaSerializer.loadAllArenas(this.plugin, type);
        }
    }

    private void reloadConfigType() {
        this.configSerializer.reloadFile();
        try {
            this.configSerializer.loadMatchParams();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        if (this.plugin != BattleArena.getSelf()) {
            this.plugin.reloadConfig();
        }
    }

    public void saveParams(MatchParams params) {
        this.configSerializer.save(params);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public CustomCommandExecutor getCustomExecutor() {
        return this.customExecutor;
    }

    public void setCustomExeuctor(CustomCommandExecutor customExecutor) {
        this.customExecutor = customExecutor;
    }
}

