/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mc.alk.arena.objects.ArenaClass;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.StateOption;
import mc.alk.arena.objects.exceptions.InvalidOptionException;
import mc.alk.arena.objects.options.StateOptions;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.InventoryUtil;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateGraph {
    final Map<CompetitionState, StateOptions> ops = new HashMap<CompetitionState, StateOptions>();
    Set<StateOption> allops;

    public StateGraph() {
    }

    public StateGraph(StateGraph o) {
        for (CompetitionState ms : o.ops.keySet()) {
            this.ops.put(ms, new StateOptions(o.ops.get(ms)));
        }
    }

    public Map<CompetitionState, StateOptions> getAllOptions() {
        return this.ops;
    }

    public void addStateOptions(CompetitionState ms, StateOptions tops) {
        this.ops.put(ms, tops);
        this.allops = null;
    }

    public void addStateOption(CompetitionState state, StateOption option) throws InvalidOptionException {
        StateOptions tops = this.ops.get(state);
        if (tops == null) {
            tops = new StateOptions();
            this.ops.put(state, tops);
        }
        tops.addOption(option);
        this.allops = null;
    }

    public void addStateOption(CompetitionState state, StateOption option, Object value) throws InvalidOptionException {
        StateOptions tops = this.ops.get(state);
        if (tops == null) {
            tops = new StateOptions();
            this.ops.put(state, tops);
        }
        tops.addOption(option, value);
        this.allops = null;
    }

    public boolean removeStateOption(CompetitionState state, StateOption option) {
        StateOptions tops = this.ops.get(state);
        return tops != null && tops.removeOption(option) != null;
    }

    public void removeStateOptions(CompetitionState ms) {
        this.ops.remove(ms);
        this.allops = null;
    }

    private void calculateAllOptions() {
        if (this.allops != null) {
            this.allops.clear();
        } else {
            this.allops = new HashSet<StateOption>();
        }
        for (StateOptions top : this.ops.values()) {
            this.allops.addAll(top.getOptions().keySet());
        }
    }

    public boolean hasAnyOption(StateOption option) {
        if (this.allops == null) {
            this.calculateAllOptions();
        }
        return this.allops.contains(option);
    }

    public boolean hasAnyOption(StateOption ... options) {
        if (this.allops == null) {
            this.calculateAllOptions();
        }
        for (StateOption op : options) {
            if (!this.allops.contains(op)) continue;
            return true;
        }
        return false;
    }

    public CompetitionState getCompetitionState(StateOption option) {
        for (CompetitionState state : this.ops.keySet()) {
            StateOptions tops = this.ops.get(state);
            if (!tops.hasOption(option)) continue;
            return state;
        }
        return null;
    }

    public boolean hasAllOptions(StateOption ... options) {
        HashSet<StateOption> ops = new HashSet<StateOption>(Arrays.asList(options));
        if (this.allops == null) {
            this.calculateAllOptions();
        }
        return this.allops.containsAll(ops);
    }

    public boolean hasInArenaOrOptionAt(CompetitionState state, StateOption option) {
        StateOptions tops = this.ops.get(state);
        return tops == null ? this.hasOptionAt(MatchState.INARENA, option) : tops.hasOption(option);
    }

    public boolean hasOptionAt(CompetitionState state, StateOption option) {
        StateOptions tops = this.ops.get(state);
        return tops != null && tops.hasOption(option);
    }

    public boolean hasOptionIn(MatchState beginState, MatchState endState, StateOption option) {
        List<MatchState> states = MatchState.getStates(beginState, endState);
        for (MatchState state : states) {
            StateOptions tops = this.ops.get(state);
            if (tops == null || !tops.hasOption(option)) continue;
            return true;
        }
        return false;
    }

    public boolean needsClearInventory() {
        return this.ops.containsKey(MatchState.PREREQS) && this.ops.get(MatchState.PREREQS).clearInventory();
    }

    public String getRequiredString(String header) {
        return this.ops.containsKey(MatchState.PREREQS) ? this.ops.get(MatchState.PREREQS).getNotReadyMsg(header) : null;
    }

    public String getRequiredString(ArenaPlayer p, World w, String header) {
        return this.ops.containsKey(MatchState.PREREQS) ? this.ops.get(MatchState.PREREQS).getNotReadyMsg(p, w, header) : null;
    }

    public String getGiveString(CompetitionState ms) {
        return this.ops.containsKey(ms) ? this.ops.get(ms).getPrizeMsg(null) : null;
    }

    public StateOptions getOptions(CompetitionState ms) {
        return this.ops.get(ms);
    }

    public Double getEntranceFee() {
        return this.ops.containsKey(MatchState.PREREQS) ? this.ops.get(MatchState.PREREQS).getMoney() : null;
    }

    public boolean hasEntranceFee() {
        return this.ops.containsKey(MatchState.PREREQS) && this.ops.get(MatchState.PREREQS).hasMoney();
    }

    public boolean playerReady(ArenaPlayer p, World w) {
        return !this.ops.containsKey(MatchState.PREREQS) || this.ops.get(MatchState.PREREQS).playerReady(p, w);
    }

    public List<ItemStack> getNeedItems(CompetitionState state) {
        return this.ops.containsKey(state) ? this.ops.get(state).getNeedItems() : null;
    }

    public List<ItemStack> getTakeItems(CompetitionState state) {
        return this.ops.containsKey(state) ? this.ops.get(state).getTakeItems() : null;
    }

    public List<ItemStack> getGiveItems(CompetitionState state) {
        return this.ops.containsKey(state) ? this.ops.get(state).getGiveItems() : null;
    }

    public boolean teamReady(ArenaTeam t, World w) {
        StateOptions to = this.ops.get(MatchState.PREREQS);
        if (to == null) {
            return true;
        }
        for (ArenaPlayer p : t.getPlayers()) {
            if (to.playerReady(p, w)) continue;
            return false;
        }
        return true;
    }

    public List<MatchState> getMatchStateRange(TransitionOption startOption, TransitionOption endOption) {
        boolean foundOption = false;
        ArrayList<MatchState> list = new ArrayList<MatchState>();
        for (MatchState ms : MatchState.values()) {
            StateOptions to = this.ops.get(ms);
            if (to == null) continue;
            if (to.hasOption(startOption)) {
                foundOption = true;
            }
            if (to.hasOption(endOption)) {
                return list;
            }
            if (!foundOption) continue;
            list.add(ms);
        }
        return list;
    }

    public String getOptionString(StateGraph subset) {
        if (subset == null) {
            subset = new StateGraph();
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<CompetitionState> states = new ArrayList<CompetitionState>(this.ops.keySet());
        ArrayList<CompetitionState> states2 = new ArrayList<CompetitionState>(subset.ops.keySet());
        Collections.sort(states, new CStateComparator());
        Collections.sort(states2, new CStateComparator());
        for (CompetitionState ms : states) {
            List<ItemStack> items;
            Map<Integer, ArenaClass> classes;
            StateOptions to = this.ops.get(ms);
            StateOptions to2 = subset.ops.get(ms);
            sb.append(ms).append(" -- ");
            sb.append(to.getOptionString(to2)).append("\n");
            Map<Integer, ArenaClass> map = classes = to2 != null && to2.getClasses() != null ? to2.getClasses() : to.getClasses();
            if (classes != null) {
                sb.append("             classes - ");
                for (ArenaClass ac : classes.values()) {
                    sb.append(" ").append(ac.getDisplayName());
                }
                sb.append("\n");
            }
            List<ItemStack> list = items = to2 != null && to2.getGiveItems() != null ? to2.getGiveItems() : to.getGiveItems();
            if (items != null) {
                sb.append("             items - ");
                for (ItemStack item : items) {
                    sb.append(" ").append(InventoryUtil.getItemString(item));
                }
                sb.append("\n");
            }
            if ((items = to2 != null && to2.getNeedItems() != null ? to2.getNeedItems() : to.getNeedItems()) == null) continue;
            sb.append("             needitems - ");
            for (ItemStack item : items) {
                sb.append(" ").append(InventoryUtil.getItemString(item));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getOptionString() {
        return this.getOptionString(null);
    }

    public Double getDoubleOption(CompetitionState state, StateOption option) {
        StateOptions tops = this.getOptions(state);
        return tops == null ? null : tops.getDouble(option);
    }

    public static StateGraph mergeChildWithParent(StateGraph cmt, StateGraph pmt) {
        if (cmt == null && pmt == null) {
            return null;
        }
        if (cmt == null) {
            cmt = new StateGraph();
        }
        if (pmt == null) {
            return cmt;
        }
        for (Map.Entry<CompetitionState, StateOptions> entry : pmt.ops.entrySet()) {
            if (cmt.ops.containsKey(entry.getKey())) {
                cmt.ops.get(entry.getKey()).addOptions(entry.getValue());
                continue;
            }
            cmt.ops.put(entry.getKey(), new StateOptions(entry.getValue()));
        }
        cmt.calculateAllOptions();
        return cmt;
    }

    public void deleteOptions(CompetitionState state) {
        this.ops.remove(state);
        this.calculateAllOptions();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CStateComparator
    implements Comparator<CompetitionState> {
        CStateComparator() {
        }

        @Override
        public int compare(CompetitionState o1, CompetitionState o2) {
            return o1.globalOrdinal() - o2.globalOrdinal();
        }
    }
}

