/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.arenas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mc.alk.arena.BattleArena;
import mc.alk.arena.competition.TransitionController;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.controllers.ArenaAlterController;
import mc.alk.arena.controllers.RoomController;
import mc.alk.arena.controllers.SpawnController;
import mc.alk.arena.controllers.containers.AreaContainer;
import mc.alk.arena.controllers.containers.LobbyContainer;
import mc.alk.arena.controllers.containers.RoomContainer;
import mc.alk.arena.listeners.PlayerHolder;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.CompetitionTransition;
import mc.alk.arena.objects.ContainerState;
import mc.alk.arena.objects.LocationType;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchResult;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.StateGraph;
import mc.alk.arena.objects.arenas.ArenaType;
import mc.alk.arena.objects.options.JoinOptions;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.objects.regions.PylamoRegion;
import mc.alk.arena.objects.regions.WorldGuardRegion;
import mc.alk.arena.objects.spawns.SpawnLocation;
import mc.alk.arena.objects.spawns.TimedSpawn;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.serializers.Persist;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arena
extends AreaContainer {
    protected Location joinloc;
    protected Map<Long, TimedSpawn> timedSpawns;
    protected SpawnController spawnController;
    protected Match match;
    protected RoomContainer spectate;
    protected RoomContainer waitroom;
    protected RoomContainer visitorRoom;
    @Persist
    protected WorldGuardRegion wgRegion;
    @Persist
    protected PylamoRegion pylamoRegion;

    public Arena() {
        super("arena", LocationType.ARENA);
    }

    void privateInit() {
        try {
            this.init();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateCreate() {
        try {
            this.create();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateDelete() {
        try {
            this.delete();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateOnOpen() {
        try {
            this.onOpen();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateOnBegin() {
        try {
            this.onBegin();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateOnPrestart() {
        try {
            this.onPrestart();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateOnStart() {
        this.startSpawns();
        try {
            this.onStart();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateOnVictory(MatchResult result) {
        this.stopSpawns();
        try {
            this.onVictory(result);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateOnComplete() {
        this.stopSpawns();
        try {
            this.onComplete();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateOnCancel() {
        this.stopSpawns();
        try {
            this.onCancel();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateOnFinish() {
        try {
            this.onFinish();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateOnEnter(ArenaPlayer player, ArenaTeam team) {
        try {
            this.onEnter(player, team);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateOnEnterWaitRoom(ArenaPlayer player, ArenaTeam team) {
        try {
            this.onEnterWaitRoom(player, team);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateOnEnterSpectate(ArenaPlayer player, ArenaTeam team) {
        try {
            this.onEnterSpectate(player, team);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateOnJoin(ArenaPlayer player, ArenaTeam team) {
        try {
            this.onJoin(player, team);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    void privateOnLeave(ArenaPlayer player, ArenaTeam team) {
        try {
            this.onLeave(player, team);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    protected void init() {
    }

    protected void create() {
    }

    protected void delete() {
    }

    protected void onOpen() {
    }

    protected void onJoin(ArenaPlayer player, ArenaTeam team) {
    }

    protected void onLeave(ArenaPlayer player, ArenaTeam team) {
    }

    protected void onBegin() {
    }

    protected void onPrestart() {
    }

    protected void onStart() {
    }

    protected void onVictory(MatchResult result) {
    }

    protected void onComplete() {
    }

    protected void onCancel() {
    }

    protected void onFinish() {
    }

    protected void onEnter(ArenaPlayer player, ArenaTeam team) {
    }

    protected void onEnterWaitRoom(ArenaPlayer player, ArenaTeam team) {
    }

    protected void onEnterSpectate(ArenaPlayer player, ArenaTeam team) {
    }

    protected void onExit(ArenaPlayer player, ArenaTeam team) {
    }

    public SpawnLocation getWaitRoomSpawnLoc(int index) {
        return this.waitroom.getSpawn(index, false);
    }

    public SpawnLocation getRandomWaitRoomSpawnLoc() {
        return this.waitroom.getSpawn(-1, true);
    }

    public SpawnLocation getVisitorLoc(int teamIndex, boolean random) {
        return this.visitorRoom != null ? this.visitorRoom.getSpawn(teamIndex, random) : null;
    }

    public Location getJoinLocation() {
        return this.joinloc;
    }

    @Override
    public void setName(String arenaName) {
        this.name = arenaName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<List<SpawnLocation>> getWaitRoomSpawnLocs() {
        return this.waitroom != null ? this.waitroom.getSpawns() : null;
    }

    public ArenaType getArenaType() {
        return this.params.getType();
    }

    public boolean valid() {
        return this.name != null && !this.spawns.isEmpty() && this.spawns.get(0) != null && this.params.valid();
    }

    public List<String> getInvalidReasons() {
        ArrayList<String> reasons = new ArrayList<String>();
        if (this.name == null) {
            reasons.add("Arena name is null");
        }
        if (this.spawns.size() < 1) {
            reasons.add("needs to have at least 1 spawn location");
        }
        if (this.spawns.get(0) == null) {
            reasons.add("1st spawn is set to a null location");
        }
        reasons.addAll(this.params.getInvalidReasons());
        return reasons;
    }

    public void setWorldGuardRegion(String regionWorld, String regionName) {
        this.wgRegion = new WorldGuardRegion(regionWorld, regionName);
    }

    public void setWorldGuardRegion(WorldGuardRegion region) {
        this.wgRegion = region;
    }

    public boolean hasRegion() {
        return this.wgRegion != null && this.wgRegion.valid();
    }

    public WorldGuardRegion getWorldGuardRegion() {
        return this.wgRegion;
    }

    public Map<Long, TimedSpawn> getTimedSpawns() {
        return this.timedSpawns;
    }

    public void addTimedSpawn(Long num, TimedSpawn s) {
        if (this.timedSpawns == null) {
            this.timedSpawns = new HashMap<Long, TimedSpawn>();
        }
        this.timedSpawns.put(num, s);
    }

    public TimedSpawn deleteTimedSpawn(Long num) {
        return this.timedSpawns == null ? null : this.timedSpawns.remove(num);
    }

    public void setMatch(Match arenaMatch) {
        this.match = arenaMatch;
    }

    public Match getMatch() {
        return this.match;
    }

    protected void setWinner(ArenaTeam team) {
        this.match.setVictor(team);
    }

    protected void setWinner(ArenaPlayer player) {
        this.match.setVictor(player);
    }

    @Override
    @Deprecated
    public MatchState getMatchState() {
        return this.match.getMatchState();
    }

    @Override
    public CompetitionState getState() {
        return this.match.getState();
    }

    public List<ArenaTeam> getTeams() {
        return this.match == null ? null : this.match.getTeams();
    }

    public List<ArenaTeam> getAliveTeams() {
        return this.match == null ? null : this.match.getAliveTeams();
    }

    public Set<ArenaPlayer> getAlivePlayers() {
        return this.match == null ? null : this.match.getAlivePlayers();
    }

    public Set<Player> getAliveBukkitPlayers() {
        return this.match == null ? null : BattleArena.toPlayerSet(this.match.getAlivePlayers());
    }

    @Override
    public ArenaTeam getTeam(ArenaPlayer p) {
        return this.match == null ? null : this.match.getTeam(p);
    }

    public ArenaTeam getTeam(Player p) {
        return this.match == null ? null : this.match.getTeam(BattleArena.toArenaPlayer(p));
    }

    public ArenaTeam getTeam(int teamIndex) {
        return this.match == null ? null : this.match.getTeam(teamIndex);
    }

    public void startSpawns() {
        SpawnController sc = this.getSpawnController();
        if (sc != null) {
            sc.start();
        }
    }

    public void stopSpawns() {
        if (this.spawnController != null) {
            this.spawnController.stop();
        }
    }

    public boolean matches(JoinOptions jp) {
        Arena a = jp.getArena();
        if (a != null && !a.matches(this)) {
            return false;
        }
        MatchParams matchParams = jp.getMatchParams();
        if (!this.matches(matchParams)) {
            return false;
        }
        if (matchParams.hasOptionAt((CompetitionState)MatchState.PREREQS, TransitionOption.WITHINDISTANCE) && !jp.nearby(this, matchParams.getDoubleOption(MatchState.PREREQS, TransitionOption.WITHINDISTANCE))) {
            return false;
        }
        return !matchParams.hasOptionAt((CompetitionState)MatchState.PREREQS, TransitionOption.SAMEWORLD) || jp.sameWorld(this);
    }

    public boolean matches(Arena arena) {
        if (arena == null) {
            return false;
        }
        if (this == arena) {
            return true;
        }
        if (arena.name == null || this.name == null) {
            return false;
        }
        return this.name.equals(arena.name);
    }

    public boolean matches(MatchParams params) {
        if (!this.getParams().matches(params)) {
            return false;
        }
        if ((this.waitroom == null || !this.waitroom.hasSpawns()) && params.needsWaitroom()) {
            return false;
        }
        return this.spectate != null && this.spectate.hasSpawns() || !params.needsSpectate();
    }

    public List<String> getInvalidMatchReasons(Arena arena) {
        ArrayList<String> reasons = new ArrayList<String>();
        if (arena == null) {
            reasons.add("Arena is null");
        } else {
            if (this == arena) {
                return reasons;
            }
            if (arena.name == null || this.name == null) {
                reasons.add("Arena name is null or this.name is null");
            } else if (!this.name.equals(arena.name)) {
                reasons.add("This arena '" + this.getName() + "' isn't '" + arena.getName() + "'");
            }
        }
        return reasons;
    }

    public boolean withinDistance(Location location, double distance) {
        for (List list : this.spawns) {
            for (SpawnLocation l : list) {
                if (location.getWorld().getUID() != l.getLocation().getWorld().getUID() || !(location.distance(l.getLocation()) < distance)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getInvalidMatchReasons(MatchParams matchParams, JoinOptions jp) {
        ArrayList<String> reasons = new ArrayList<String>();
        reasons.addAll(this.getParams().getInvalidMatchReasons(matchParams));
        StateGraph tops = matchParams.getStateGraph();
        if (tops != null) {
            if (matchParams.needsWaitroom() && (this.waitroom == null || !this.waitroom.hasSpawns())) {
                reasons.add("Needs a waitroom but none has been provided");
            }
            if (matchParams.needsSpectate() && (this.spectate == null || !this.spectate.hasSpawns())) {
                reasons.add("Needs a spectator room but none has been provided");
            }
            if (matchParams.needsLobby() && !RoomController.hasLobby(matchParams.getType())) {
                reasons.add("Needs a lobby but none has been provided");
            }
        }
        if (jp == null) {
            return reasons;
        }
        if (jp.getArena() != null) {
            reasons.addAll(this.getInvalidMatchReasons(jp.getArena()));
        }
        if (matchParams.hasOptionAt((CompetitionState)MatchState.PREREQS, TransitionOption.WITHINDISTANCE) && !jp.nearby(this, matchParams.getDoubleOption(MatchState.PREREQS, TransitionOption.WITHINDISTANCE))) {
            reasons.add("You aren't within " + matchParams.getDoubleOption(MatchState.PREREQS, TransitionOption.WITHINDISTANCE) + " blocks");
        }
        if (matchParams.hasOptionAt((CompetitionState)MatchState.PREREQS, TransitionOption.SAMEWORLD) && !jp.sameWorld(this)) {
            reasons.add("You aren't in the same world");
        }
        return reasons;
    }

    public String toString() {
        return this.toSummaryString();
    }

    public String toDetailedString() {
        StringBuilder sb = new StringBuilder("&6" + this.name + " &e");
        sb.append("&eTeamSizes=&6" + this.params.getTeamSize() + " &eTypes=&6" + this.params.getType());
        sb.append("&e, #Teams:&6" + this.params.getNTeams());
        sb.append("&e, #spawns:&6" + this.spawns.size() + "\n");
        sb.append("&eteamSpawnLocs=&b" + this.getSpawnLocationString() + "\n");
        if (this.waitroom != null) {
            sb.append("&ewrSpawnLocs=&b" + this.waitroom.getSpawnLocationString() + "\n");
        }
        if (this.spectate != null) {
            sb.append("&espectateSpawnLocs=&b" + this.spectate.getSpawnLocationString() + "\n");
        }
        if (this.timedSpawns != null) {
            sb.append("&e#item/mob spawns:&6" + this.timedSpawns.size() + "\n");
        }
        return sb.toString();
    }

    private ChatColor getColor(Object o) {
        return o == null ? ChatColor.GOLD : ChatColor.WHITE;
    }

    public String toSummaryString() {
        StringBuilder sb = new StringBuilder("&4" + this.name);
        if (this.params != null) {
            sb.append(" &2TeamSizes:" + this.getColor(this.params.getThisTeamSize()) + this.params.getTeamSize() + "&2, nTeams:" + this.getColor(this.params.getThisNTeams()) + this.params.getNTeams());
        }
        sb.append("&2 #spawns:&f" + this.spawns.size() + "&2 1stSpawn:&f");
        if (!this.spawns.isEmpty()) {
            SpawnLocation l = (SpawnLocation)((List)this.spawns.get(0)).get(0);
            sb.append("[" + Util.getLocString(l) + "] ");
        }
        if (this.timedSpawns != null && !this.timedSpawns.isEmpty()) {
            sb.append("&2#item/mob Spawns:&f" + this.timedSpawns.size());
        }
        return sb.toString();
    }

    public SpawnController getSpawnController() {
        if (this.timedSpawns != null && !this.timedSpawns.isEmpty() && this.spawnController == null) {
            this.spawnController = new SpawnController(this.timedSpawns);
        }
        return this.spawnController;
    }

    public void setPylamoRegion(PylamoRegion region) {
        this.pylamoRegion = region;
    }

    public PylamoRegion getPylamoRegion() {
        return this.pylamoRegion;
    }

    public void setWaitRoom(RoomContainer waitroom) {
        this.waitroom = waitroom;
    }

    public void setSpectatorRoom(RoomContainer spectate) {
        this.spectate = spectate;
    }

    public RoomContainer getWaitroom() {
        return this.waitroom;
    }

    public RoomContainer getVisitorRoom() {
        return this.visitorRoom;
    }

    public void setVisitorRoom(RoomContainer rc) {
        this.visitorRoom = rc;
    }

    public RoomContainer getSpectatorRoom() {
        return this.spectate;
    }

    public RoomContainer getLobby() {
        return RoomController.getLobby(this.getArenaType());
    }

    @Override
    public LocationType getLocationType() {
        return LocationType.ARENA;
    }

    public List<List<SpawnLocation>> getVisitorLocs() {
        return this.visitorRoom != null ? this.visitorRoom.getSpawns() : null;
    }

    public boolean isJoinable(MatchParams mp) {
        LobbyContainer lobby;
        if (!this.isOpen()) {
            return false;
        }
        if (mp.needsWaitroom() && (this.waitroom == null || !this.waitroom.isOpen() || this.waitroom.getSpawns().isEmpty())) {
            return false;
        }
        if (mp.needsSpectate() && (this.spectate == null || !this.spectate.isOpen() || this.spectate.getSpawns().isEmpty())) {
            return false;
        }
        return !mp.needsLobby() || (lobby = RoomController.getLobby(this.getArenaType())) != null && lobby.isOpen() && !lobby.getSpawns().isEmpty();
    }

    public String getNotJoinableReasons(MatchParams mp) {
        if (!this.isOpen()) {
            return "&cArena is not open!";
        }
        if (mp.needsWaitroom() && this.waitroom == null) {
            return "&cYou need to create a waitroom!";
        }
        if (mp.needsWaitroom() && !this.waitroom.isOpen()) {
            return this.waitroom.getContainerMessage() != null ? this.waitroom.getContainerMessage() : "&cWaitroom is not open!";
        }
        if (mp.needsWaitroom() && this.waitroom.getSpawns().isEmpty()) {
            return "&cYou need to set a spawn point for the waitroom!";
        }
        if (mp.needsSpectate() && this.spectate == null) {
            return "&cYou need to create a spectator area!";
        }
        if (mp.needsSpectate() && this.spectate.getSpawns().isEmpty()) {
            return "&cYou need to set a spawn point for the spectate area!";
        }
        if (mp.needsLobby() && this.getLobby() == null) {
            return "&cYou need to create a lobby!";
        }
        if (mp.needsLobby()) {
            RoomContainer lobby = this.getLobby();
            if (!lobby.isOpen()) {
                return "&cLobby is not open!";
            }
            if (mp.needsLobby() && lobby.getSpawns().isEmpty()) {
                return "&cYou need to set a spawn point for the lobby!";
            }
        }
        return "";
    }

    public void setAllContainerState(ContainerState state) {
        RoomContainer lobby;
        this.setContainerState(state);
        if (this.waitroom != null) {
            this.waitroom.setContainerState(state);
        }
        if ((lobby = this.getLobby()) != null) {
            lobby.setContainerState(state);
        }
    }

    public void setContainerState(ArenaAlterController.ChangeType cs, ContainerState state) throws IllegalStateException {
        switch (cs) {
            case LOBBY: {
                RoomContainer lobby = this.getLobby();
                if (lobby == null) {
                    throw new IllegalStateException("Arena " + this.getName() + " does not have a Lobby");
                }
                lobby.setContainerState(state);
                break;
            }
            case VLOC: {
                if (this.visitorRoom == null) {
                    throw new IllegalStateException("Arena " + this.getName() + " does not have a visitorRoom");
                }
                this.visitorRoom.setContainerState(state);
                break;
            }
            case WAITROOM: {
                if (this.waitroom == null) {
                    throw new IllegalStateException("Arena " + this.getName() + " does not have a waitroom");
                }
                this.waitroom.setContainerState(state);
                break;
            }
            default: {
                throw new IllegalStateException((Object)((Object)cs) + " can not be set to " + state);
            }
        }
    }

    public int getQueueCount() {
        return BattleArena.getBAController().getArenaMatchQueue().getQueueCount(this);
    }

    protected void performTransition(CompetitionTransition transition, ArenaPlayer player) {
        TransitionController.transition((PlayerHolder)((Object)(this.match != null ? this.match : this)), (CompetitionState)transition, player, player.getTeam(), false);
    }

    protected void performTransition(CompetitionTransition transition, ArenaTeam team) {
        TransitionController.transition((PlayerHolder)((Object)(this.match != null ? this.match : this)), (CompetitionState)transition, team, false);
    }
}

