/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.arenas;

import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchResult;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.teams.ArenaTeam;

public class ArenaControllerInterface {
    final Arena arena;

    public ArenaControllerInterface(Arena arena) {
        this.arena = arena;
    }

    public void onOpen() {
        this.arena.privateOnOpen();
    }

    public void onBegin() {
        this.arena.privateOnBegin();
    }

    public void onPrestart() {
        this.arena.privateOnPrestart();
    }

    public void onStart() {
        this.arena.privateOnStart();
    }

    public void onVictory(MatchResult result) {
        this.arena.privateOnVictory(result);
    }

    public void onComplete() {
        this.arena.privateOnComplete();
    }

    public void onFinish() {
        this.arena.privateOnFinish();
    }

    public void onCancel() {
        this.arena.privateOnCancel();
    }

    public void onEnter(ArenaPlayer p, ArenaTeam t) {
        this.arena.privateOnEnter(p, t);
    }

    public void onEnterWaitRoom(ArenaPlayer p, ArenaTeam t) {
        this.arena.privateOnEnterWaitRoom(p, t);
    }

    public void onEnterSpectate(ArenaPlayer p, ArenaTeam t) {
        this.arena.privateOnEnterSpectate(p, t);
    }

    public void onLeave(ArenaPlayer p, ArenaTeam t) {
        this.arena.privateOnLeave(p, t);
    }

    public void onJoin(ArenaPlayer p, ArenaTeam t) {
        this.arena.privateOnJoin(p, t);
    }

    public void create() {
        this.arena.privateCreate();
    }

    public void init() {
        this.arena.privateInit();
    }

    public void delete() {
        this.arena.privateDelete();
    }
}

