/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.arenas;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.util.CaseInsensitiveMap;
import mc.alk.arena.util.Log;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArenaType
implements Comparable<ArenaType> {
    public static final CaseInsensitiveMap<Class<? extends Arena>> classes = new CaseInsensitiveMap();
    public static final CaseInsensitiveMap<ArenaType> types = new CaseInsensitiveMap();
    static int count = 0;
    final String name;
    final Plugin ownerPlugin;
    final int id = count++;
    Set<ArenaType> compatibleTypes = null;

    private ArenaType(String name, Plugin plugin) {
        this.name = name;
        this.ownerPlugin = plugin;
        if (!types.containsKey(name)) {
            types.put(name, this);
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean matches(ArenaType arenaType) {
        return this == arenaType || this.compatibleTypes != null && this.compatibleTypes.contains(arenaType);
    }

    public Collection<String> getInvalidMatchReasons(ArenaType arenaType) {
        ArrayList<String> reasons = new ArrayList<String>();
        if (this != arenaType) {
            reasons.add("Arena type is " + this + ". You requested " + arenaType);
        }
        return reasons;
    }

    public String toPrettyString(int min, int max) {
        if (this.name.equals("ARENA") || this.name.equals("SKIRMISH")) {
            return min + "v" + max;
        }
        return this.toString();
    }

    public String getCompatibleTypes() {
        if (this.compatibleTypes == null || this.compatibleTypes.isEmpty()) {
            return this.name;
        }
        StringBuilder sb = new StringBuilder(this.name);
        for (ArenaType at : this.compatibleTypes) {
            sb.append(", ").append(at.name);
        }
        return sb.toString();
    }

    public int ordinal() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    private void addCompatibleType(ArenaType at) {
        if (this.compatibleTypes == null) {
            this.compatibleTypes = new HashSet<ArenaType>();
        }
        this.compatibleTypes.add(at);
    }

    @Override
    public int compareTo(ArenaType type) {
        Integer ord = this.ordinal();
        return ord.compareTo(type.ordinal());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo((ArenaType)obj) == 0;
    }

    public int hashCode() {
        return this.id;
    }

    public Plugin getPlugin() {
        return this.ownerPlugin;
    }

    public static ArenaType fromString(String arenatype) {
        if (arenatype == null) {
            return null;
        }
        return types.get(arenatype.toUpperCase());
    }

    public static String getValidList() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ArenaType at : types.values()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(at.name);
        }
        return sb.toString();
    }

    public static ArenaType register(String arenaType, Class<? extends Arena> arenaClass, Plugin plugin) {
        String uarenaType = arenaType.toUpperCase();
        if (!classes.containsKey(uarenaType) || classes.get(uarenaType) == null) {
            classes.put(uarenaType, arenaClass);
        }
        if (!types.containsKey(uarenaType)) {
            new ArenaType(arenaType, plugin);
        }
        return types.get(uarenaType);
    }

    public static Arena createArena(String arenaName, MatchParams arenaParams) {
        ArenaType arenaType = arenaParams.getType();
        return ArenaType.createArena(arenaType, arenaName, arenaParams, true);
    }

    public static Arena createArena(String arenaName, MatchParams arenaParams, boolean init) {
        ArenaType arenaType = arenaParams.getType();
        return ArenaType.createArena(arenaType, arenaName, arenaParams, init);
    }

    private static Arena createArena(ArenaType arenaType, String arenaName, MatchParams arenaParams, boolean init) {
        Class<? extends Arena> arenaClass = classes.get(arenaType.name);
        if (arenaClass == null) {
            Log.err("[BA Error] arenaClass " + arenaType.name + " is not found");
            return null;
        }
        Class[] args = new Class[]{};
        try {
            Constructor<? extends Arena> constructor = arenaClass.getConstructor(args);
            Arena arena = constructor.newInstance(args);
            arenaParams.setName(arenaName);
            arenaParams.setType(arenaType);
            arena.setName(arenaName);
            arenaParams.setParent(ParamController.getMatchParams(arenaParams));
            arena.setParams(arenaParams);
            if (init) {
                arena.privateInit();
            }
            return arena;
        }
        catch (NoSuchMethodException e) {
            Log.err("If you have custom constructors for your class you must also have a public default constructor");
            Log.err("Add the following line to your Arena Class '" + arenaClass.getSimpleName() + ".java'");
            Log.err("public " + arenaClass.getSimpleName() + "(){}");
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        return null;
    }

    public static void addCompatibleTypes(String type1, String type2) {
        ArenaType at1 = ArenaType.fromString(type1);
        ArenaType at2 = ArenaType.fromString(type2);
        if (at1 == null || at2 == null) {
            return;
        }
        at1.addCompatibleType(at2);
        at2.addCompatibleType(at1);
    }

    public static void addAliasForType(String type, String alias) {
        if ((type = type.toUpperCase()).equals(alias = alias.toUpperCase())) {
            return;
        }
        ArenaType at = ArenaType.fromString(type);
        if (at == null) {
            return;
        }
        types.put(alias, at);
        classes.put(alias, ArenaType.getArenaClass(at));
        MatchParams mp = ParamController.getMatchParams(type);
        if (mp == null) {
            return;
        }
        ParamController.addAlias(alias, mp);
    }

    public static Collection<ArenaType> getTypes() {
        return new HashSet<ArenaType>(types.values());
    }

    public static Collection<ArenaType> getTypes(Plugin plugin) {
        HashSet<ArenaType> result = new HashSet<ArenaType>();
        for (ArenaType type : types.values()) {
            if (!type.getPlugin().equals(plugin)) continue;
            result.add(type);
        }
        return result;
    }

    public static Class<? extends Arena> getArenaClass(ArenaType arenaType) {
        return ArenaType.getArenaClass(arenaType.getName());
    }

    public static Class<? extends Arena> getArenaClass(String arenaType) {
        return classes.get(arenaType);
    }

    public static boolean contains(String arenaType) {
        return types.containsKey(arenaType);
    }

    public static boolean isSame(String checkType, ArenaType arenaType) {
        ArenaType at = types.get(checkType);
        return at != null && at.equals(arenaType);
    }

    public static ArenaType getType(String value) {
        return types.get(value);
    }
}

