/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.arenas;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import mc.alk.arena.objects.YamlSerializable;
import mc.alk.arena.objects.exceptions.SerializationException;
import mc.alk.arena.serializers.Persist;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.SerializerUtil;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Persistable {
    public static void yamlToObjects(Object object, ConfigurationSection cs) {
        if (cs == null) {
            return;
        }
        Persistable.yamlToObjects(object, object.getClass(), cs, null);
    }

    public static void yamlToObjects(Object object, ConfigurationSection cs, Class<?> onlyCheckClass) {
        if (cs == null) {
            return;
        }
        Persistable.yamlToObjects(object, object.getClass(), cs, onlyCheckClass);
    }

    private static void yamlToObjects(Object object, Class<?> objectClass, ConfigurationSection cs, Class<?> onlyCheckClass) {
        for (Field field : objectClass.getDeclaredFields()) {
            Annotation[] annotations;
            Class<?> type = field.getType();
            String name = field.getName();
            for (Annotation a : annotations = field.getDeclaredAnnotations()) {
                if (!(a instanceof Persist) && cs.contains(name)) continue;
                field.setAccessible(true);
                try {
                    Type genType;
                    List list;
                    ParameterizedType pt;
                    Integer i;
                    String str;
                    Object obj = null;
                    if (type == Integer.TYPE) {
                        field.setInt(object, cs.getInt(name));
                    } else if (type == Float.TYPE) {
                        field.setFloat(object, (float)cs.getDouble(name));
                    } else if (type == Double.TYPE) {
                        field.setDouble(object, cs.getDouble(name));
                    } else if (type == Long.TYPE) {
                        field.setLong(object, cs.getLong(name));
                    } else if (type == Boolean.TYPE) {
                        field.setBoolean(object, cs.getBoolean(name));
                    } else if (type == Short.TYPE) {
                        field.setShort(object, (short)cs.getInt(name));
                    } else if (type == Byte.TYPE) {
                        field.setByte(object, (byte)cs.getInt(name));
                    } else if (type == Character.TYPE) {
                        str = cs.getString(name);
                        if (str != null && !str.isEmpty()) {
                            field.setChar(object, str.charAt(0));
                        }
                    } else if (type == Integer.class) {
                        obj = cs.getInt(name);
                    } else if (type == Float.class) {
                        Double d = cs.getDouble(name);
                        if (d != null) {
                            obj = new Float(d);
                        }
                    } else if (type == Double.class) {
                        obj = cs.getDouble(name);
                    } else if (type == Character.class) {
                        str = cs.getString(name);
                        if (str != null && !str.isEmpty()) {
                            obj = Character.valueOf(str.charAt(0));
                        }
                    } else if (type == Byte.class) {
                        i = cs.getInt(name);
                        obj = i.byteValue();
                    } else if (type == Short.class) {
                        i = cs.getInt(name);
                        obj = i.shortValue();
                    } else if (type == Long.class) {
                        obj = cs.getLong(name);
                    } else if (type == Boolean.class) {
                        obj = cs.getBoolean(name);
                    } else if (type == String.class) {
                        obj = cs.getString(name);
                    } else if (type == Location.class) {
                        String locstr = cs.getString(name);
                        obj = SerializerUtil.getLocation(locstr);
                    } else if (type == ItemStack.class) {
                        str = cs.getString(name);
                        if (str != null) {
                            obj = InventoryUtil.parseItem(str);
                        }
                    } else if (List.class.isAssignableFrom(type)) {
                        pt = (ParameterizedType)field.getGenericType();
                        list = cs.getList(name);
                        if (list == null) continue;
                        genType = pt.getActualTypeArguments()[0];
                        ArrayList<Object> newList = new ArrayList<Object>();
                        for (Object o : list) {
                            newList.add(Persistable.yamlToObj(o, genType));
                        }
                        obj = newList;
                    } else if (Set.class.isAssignableFrom(type)) {
                        pt = (ParameterizedType)field.getGenericType();
                        list = cs.getList(name);
                        if (list == null) continue;
                        genType = pt.getActualTypeArguments()[0];
                        HashSet<Object> newSet = new HashSet<Object>();
                        for (Object o : list) {
                            newSet.add(Persistable.yamlToObj(o, genType));
                        }
                        obj = newSet;
                    } else if (Map.class.isAssignableFrom(type)) {
                        pt = (ParameterizedType)field.getGenericType();
                        ConfigurationSection mapcs = cs.getConfigurationSection(name);
                        if (mapcs == null) continue;
                        Set keyset = mapcs.getKeys(false);
                        Type keyType = pt.getActualTypeArguments()[0];
                        Type mapType = pt.getActualTypeArguments()[1];
                        HashMap<Object, Object> newMap = new HashMap<Object, Object>();
                        for (String key : keyset) {
                            Object k = Persistable.yamlToObj(key, keyType);
                            Object v = Persistable.yamlToObj(mapcs.get(key), mapType);
                            if (k == null || v == null) continue;
                            newMap.put(k, v);
                        }
                        obj = newMap;
                    } else {
                        Object o;
                        obj = ConfigurationSerializable.class.isAssignableFrom(type) ? ConfigurationSerialization.deserializeObject((Map)((Map)cs.get(name))) : (YamlSerializable.class.isAssignableFrom(type) ? ((o = cs.get(name)) != null && Map.class.isAssignableFrom(o.getClass()) ? Persistable.createYamlSerializable(type, (Map)o, cs.getString(name)) : Persistable.createYamlSerializable(type, null, cs.getString(name))) : Persistable.yamlToObj(name, type));
                    }
                    if (obj == null) continue;
                    field.set(object, obj);
                }
                catch (NotPersistableException e) {
                    System.err.println(e.getMessage());
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            }
        }
        Class<?> superClass = objectClass.getSuperclass();
        if (superClass != null && (onlyCheckClass == null || onlyCheckClass.isAssignableFrom(superClass))) {
            Persistable.yamlToObjects(object, superClass, cs, onlyCheckClass);
        }
    }

    private static Object yamlToObj(Object name, Type type) throws Exception {
        if (type == Integer.class) {
            return new Integer(name.toString());
        }
        if (type == Float.class) {
            return new Float(name.toString());
        }
        if (type == Double.class) {
            return new Double(name.toString());
        }
        if (type == Character.class) {
            return Character.valueOf(name.toString().charAt(0));
        }
        if (type == Byte.class) {
            return new Byte(name.toString());
        }
        if (type == Short.class) {
            return new Short(name.toString());
        }
        if (type == Long.class) {
            return new Long(name.toString());
        }
        if (type == Boolean.class) {
            return Boolean.valueOf(name.toString());
        }
        if (type == String.class) {
            return name;
        }
        if (type == Location.class) {
            return SerializerUtil.getLocation(name.toString());
        }
        if (type == ItemStack.class) {
            return InventoryUtil.parseItem(name.toString());
        }
        if (type == Block.class) {
            return SerializerUtil.parseBlock(name.toString());
        }
        if (YamlSerializable.class.isAssignableFrom((Class)type)) {
            if (Map.class.isAssignableFrom(name.getClass())) {
                return Persistable.createYamlSerializable((Class)type, (Map)name, null);
            }
            return Persistable.createYamlSerializable((Class)type, null, (String)name);
        }
        throw new NotPersistableException("Type " + type + " is not persistable. Not loading values for " + name);
    }

    private static Object createYamlSerializable(Class<?> clazz, Map<String, Object> map, String value) {
        if (clazz == null) {
            return null;
        }
        Class[] args = new Class[]{};
        try {
            Constructor<?> constructor = clazz.getConstructor(args);
            YamlSerializable ys = (YamlSerializable)constructor.newInstance(args);
            ys = (YamlSerializable)ys.yamlToObject(map, value);
            return ys;
        }
        catch (NoSuchMethodException e) {
            Log.err("If you have custom constructors for your YamlSerializable class you must also have a public default constructor");
            Log.err("Add the following line to your YamlSerializable Class '" + clazz.getSimpleName() + ".java'");
            Log.err("public " + clazz.getSimpleName() + "(){}");
        }
        catch (SerializationException e) {
            Log.err("[BA Error] loading value=" + value + "   map=" + map + "  class=" + clazz.getSimpleName());
            Log.err(e.getMessage());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        return null;
    }

    public static Map<String, Object> objectsToYamlMap(Object object) {
        return Persistable.objectsToYamlMap(object, null);
    }

    public static Map<String, Object> objectsToYamlMap(Object object, Class<?> onlyCheckClass) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> objectClass = object.getClass();
        Persistable.objectsToYamlMap(object, objectClass, map, onlyCheckClass);
        return map;
    }

    private static void objectsToYamlMap(Object object, Class<?> objectClass, Map<String, Object> map, Class<?> onlyCheckClass) {
        for (Field field : objectClass.getDeclaredFields()) {
            Annotation[] annotations;
            Class<?> type = field.getType();
            String name = field.getName();
            for (Annotation a : annotations = field.getDeclaredAnnotations()) {
                if (!(a instanceof Persist)) continue;
                field.setAccessible(true);
                try {
                    Object value;
                    Object key;
                    Map mymap;
                    Cloneable oset;
                    Object obj = null;
                    if (type == Integer.class || type == Float.class || type == Double.class || type == Byte.class || type == Boolean.class || type == Character.class || type == Short.class || type == Long.class || type == String.class) {
                        obj = field.get(object);
                    } else if (type == Integer.TYPE) {
                        map.put(name, field.getInt(object));
                    } else if (type == Float.TYPE) {
                        map.put(name, Float.valueOf(field.getFloat(object)));
                    } else if (type == Double.TYPE) {
                        map.put(name, field.getDouble(object));
                    } else if (type == Byte.TYPE) {
                        map.put(name, field.getByte(object));
                    } else if (type == Boolean.TYPE) {
                        map.put(name, field.getBoolean(object));
                    } else if (type == Character.TYPE) {
                        map.put(name, Character.valueOf(field.getChar(object)));
                    } else if (type == Short.TYPE) {
                        map.put(name, field.getShort(object));
                    } else if (type == Long.TYPE) {
                        map.put(name, field.getLong(object));
                    } else if (type == Location.class || type == ItemStack.class) {
                        obj = Persistable.objToYaml(field.get(object));
                    } else if (type == Block.class) {
                        obj = Persistable.objToYaml(field.get(object));
                    } else if (List.class.isAssignableFrom(type)) {
                        List list = (List)field.get(object);
                        if (list == null) continue;
                        ArrayList<Object> olist = new ArrayList<Object>();
                        for (Object o : list) {
                            olist.add(Persistable.objToYaml(o));
                        }
                        obj = olist;
                    } else if (Set.class.isAssignableFrom(type)) {
                        Set set = (Set)field.get(object);
                        if (set == null) continue;
                        oset = new ArrayList();
                        for (Object o : set) {
                            oset.add(Persistable.objToYaml(o));
                        }
                        obj = oset;
                    } else if (ConcurrentHashMap.class.isAssignableFrom(type)) {
                        mymap = (ConcurrentHashMap)field.get(object);
                        if (mymap == null) continue;
                        oset = new HashMap();
                        for (Object o : mymap.keySet()) {
                            key = Persistable.objToYaml(o);
                            if (key == null || (value = mymap.get(o)) == null) continue;
                            oset.put(key.toString(), Persistable.objToYaml(value));
                        }
                        obj = oset;
                    } else if (Map.class.isAssignableFrom(type)) {
                        mymap = (Map)field.get(object);
                        if (mymap == null) continue;
                        oset = new HashMap();
                        for (Object o : mymap.keySet()) {
                            key = Persistable.objToYaml(o);
                            if (key == null || (value = mymap.get(o)) == null) continue;
                            oset.put(key.toString(), Persistable.objToYaml(value));
                        }
                        obj = oset;
                    } else if (YamlSerializable.class.isAssignableFrom(type)) {
                        YamlSerializable ys = (YamlSerializable)field.get(object);
                        if (ys != null) {
                            obj = ys.objectToYaml();
                        }
                    } else {
                        throw new NotPersistableException("Type " + type + " is not persistable. Not saving value for " + name);
                    }
                    if (obj == null) continue;
                    map.put(name, obj);
                }
                catch (NotPersistableException e) {
                    System.err.println(e.getMessage());
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            }
        }
        Class<?> superClass = objectClass.getSuperclass();
        if (superClass != null && (onlyCheckClass == null || onlyCheckClass.isAssignableFrom(superClass))) {
            Persistable.objectsToYamlMap(object, superClass, map, onlyCheckClass);
        }
    }

    private static Object objToYaml(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Location) {
            return SerializerUtil.getLocString((Location)obj);
        }
        if (obj instanceof ItemStack) {
            return InventoryUtil.getItemString((ItemStack)obj);
        }
        if (obj instanceof YamlSerializable) {
            try {
                return ((YamlSerializable)obj).objectToYaml();
            }
            catch (SerializationException e) {
                Log.err("[BA Error] saving object =" + obj);
                Log.err(e.getMessage());
            }
        } else if (obj instanceof Block) {
            return SerializerUtil.getBlockString((Block)obj);
        }
        return obj;
    }

    public static class NotPersistableException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NotPersistableException(String msg) {
            super(msg);
        }
    }
}

