/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.events;

import java.lang.reflect.Method;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.events.EventPriority;
import org.bukkit.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArenaEventMethod {
    final Method callMethod;
    final Class<? extends Event> bukkitEvent;
    final Method getPlayerMethod;
    final MatchState beginState;
    final MatchState endState;
    final EventPriority priority;
    final org.bukkit.event.EventPriority bukkitPriority;
    final boolean specificArenaPlayer;
    final boolean isBAEvent;

    public ArenaEventMethod(Method callMethod, Class<? extends Event> event, MatchState begin, MatchState end, MatchState cancel, EventPriority priority, org.bukkit.event.EventPriority bukkitPriority, boolean isBAEvent) {
        this(callMethod, event, null, begin, end, cancel, priority, bukkitPriority, isBAEvent);
    }

    public ArenaEventMethod(Method callMethod, Class<? extends Event> event, Method getPlayerMethod, MatchState begin, MatchState end, MatchState cancel, EventPriority priority, org.bukkit.event.EventPriority bukkitPriority, boolean isBAEvent) {
        this.callMethod = callMethod;
        this.bukkitEvent = event;
        this.getPlayerMethod = getPlayerMethod;
        this.beginState = begin;
        this.endState = end;
        this.priority = priority;
        this.bukkitPriority = bukkitPriority;
        this.specificArenaPlayer = getPlayerMethod != null && ArenaPlayer.class.isAssignableFrom(this.getPlayerMethod().getReturnType());
        this.isBAEvent = isBAEvent;
    }

    public boolean isSpecificPlayerMethod() {
        return this.getPlayerMethod != null;
    }

    public boolean isSpecificArenaPlayerMethod() {
        return this.specificArenaPlayer;
    }

    public EventPriority getPriority() {
        return this.priority;
    }

    public Method getMethod() {
        return this.callMethod;
    }

    public Method getPlayerMethod() {
        return this.getPlayerMethod;
    }

    public Class<? extends Event> getBAEvent() {
        return this.bukkitEvent;
    }

    public MatchState getBeginState() {
        return this.beginState;
    }

    public MatchState getEndState() {
        return this.endState;
    }

    public boolean isBAEvent() {
        return this.isBAEvent;
    }

    public String toString() {
        return "[MEM " + this.callMethod.getName() + ", " + (this.bukkitEvent != null ? this.bukkitEvent.getSimpleName() : "null") + " p=" + this.bukkitPriority + " " + this.beginState + ":" + this.endState + "   playerMethod=" + this.getPlayerMethod + "]";
    }

    public org.bukkit.event.EventPriority getBukkitPriority() {
        return this.bukkitPriority;
    }
}

