/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.joining;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.competition.match.ArenaMatch;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.controllers.PlayerStoreController;
import mc.alk.arena.controllers.Scheduler;
import mc.alk.arena.controllers.joining.AbstractJoinHandler;
import mc.alk.arena.controllers.joining.TeamJoinFactory;
import mc.alk.arena.controllers.messaging.MessageHandler;
import mc.alk.arena.events.BAEvent;
import mc.alk.arena.events.matches.MatchCreatedEvent;
import mc.alk.arena.events.matches.MatchFinishedEvent;
import mc.alk.arena.events.players.ArenaPlayerEnterQueueEvent;
import mc.alk.arena.events.players.ArenaPlayerLeaveEvent;
import mc.alk.arena.events.players.ArenaPlayerLeaveQueueEvent;
import mc.alk.arena.executors.BAExecutor;
import mc.alk.arena.listeners.custom.MethodController;
import mc.alk.arena.objects.ArenaParams;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.PlayerSave;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.arenas.ArenaType;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.exceptions.MatchCreationException;
import mc.alk.arena.objects.exceptions.NeverWouldJoinException;
import mc.alk.arena.objects.joining.ArenaQueue;
import mc.alk.arena.objects.joining.MatchTeamQObject;
import mc.alk.arena.objects.joining.TeamJoinObject;
import mc.alk.arena.objects.joining.WaitingObject;
import mc.alk.arena.objects.options.EventOpenOptions;
import mc.alk.arena.objects.options.JoinOptions;
import mc.alk.arena.objects.pairs.JoinResult;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.CommandUtil;
import mc.alk.arena.util.Countdown;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.MinMax;
import mc.alk.arena.util.PermissionsUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArenaMatchQueue
implements ArenaListener,
Listener {
    static final boolean DEBUG = false;
    static boolean disabledAllCommands;
    private static final HashSet<String> disabledCommands;
    private static final HashSet<String> enabledCommands;
    final List<WaitingObject> joinHandlers;
    final Map<WaitingObject, IdTime> forceTimers;
    protected final Map<UUID, WaitingObject> inQueue;
    protected final MethodController methodController;
    private final Map<ArenaType, ArenaQueue> arenaqueue;
    final Map<ArenaType, LinkedList<FoundMatch>> delayedReadyMatches;
    private final Map<ArenaType, Integer> runningMatchTypes;
    static final Map<ArenaType, Integer> inQueueForGame;
    static final Map<Arena, Integer> inQueueForArena;
    final Lock lock;
    final Condition empty;
    final AtomicBoolean suspend;

    public ArenaMatchQueue() {
        block2: {
            this.joinHandlers = new LinkedList<WaitingObject>();
            this.forceTimers = Collections.synchronizedMap(new HashMap());
            this.inQueue = new HashMap<UUID, WaitingObject>();
            this.methodController = new MethodController("QC");
            this.arenaqueue = new ConcurrentHashMap<ArenaType, ArenaQueue>();
            this.delayedReadyMatches = new HashMap<ArenaType, LinkedList<FoundMatch>>();
            this.runningMatchTypes = Collections.synchronizedMap(new HashMap());
            this.lock = new ReentrantLock();
            this.empty = this.lock.newCondition();
            this.suspend = new AtomicBoolean();
            try {
                Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BattleArena.getSelf());
            }
            catch (Exception e) {
                if (Defaults.TESTSERVER) break block2;
                Log.printStackTrace(e);
            }
        }
        this.methodController.addAllEvents(this);
    }

    public static int getPlayersInArenaQueue(Arena arena) {
        return inQueueForArena.containsKey(arena) ? inQueueForArena.get(arena) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Arena arena) {
        Map<ArenaType, ArenaQueue> map = this.arenaqueue;
        synchronized (map) {
            ArenaQueue aq = this.arenaqueue.get(arena.getArenaType());
            if (aq == null) {
                aq = new ArenaQueue();
                this.arenaqueue.put(arena.getArenaType(), aq);
            }
            aq.addLast(arena);
        }
        this.forceStart(arena.getParams(), true);
    }

    private void addReadyMatch(JoinResult jr, WaitingObject o, Arena arena) {
        this.addReadyMatch(this.createFoundMatch(jr, o, arena));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReadyMatch(FoundMatch match) {
        if (match.params.getNConcurrentCompetitions() != Integer.MAX_VALUE) {
            Map<ArenaType, LinkedList<FoundMatch>> map = this.delayedReadyMatches;
            synchronized (map) {
                LinkedList<FoundMatch> l = this.delayedReadyMatches.get(match.params.getType());
                if (l == null) {
                    l = new LinkedList();
                    this.delayedReadyMatches.put(match.params.getType(), l);
                }
                l.add(match);
                if (this.getNumberOpenMatches(match.params.getType()) < match.params.getNConcurrentCompetitions()) {
                    match = l.removeFirst();
                    match.startMatch();
                }
            }
        } else {
            match.startMatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDelayedMatches() {
        Map<ArenaType, LinkedList<FoundMatch>> map = this.delayedReadyMatches;
        synchronized (map) {
            block3: for (Map.Entry<ArenaType, LinkedList<FoundMatch>> entry : this.delayedReadyMatches.entrySet()) {
                ArenaType at = entry.getKey();
                LinkedList<FoundMatch> l = this.delayedReadyMatches.get(at);
                Iterator iter = l.iterator();
                while (iter.hasNext()) {
                    FoundMatch fm = (FoundMatch)iter.next();
                    if (this.getNumberOpenMatches(at) >= fm.params.getNConcurrentCompetitions()) continue block3;
                    iter.remove();
                    fm.startMatch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinResult join(MatchTeamQObject qo) {
        WaitingObject o;
        JoinResult jr = new JoinResult();
        jr.status = JoinResult.JoinStatus.CANT_FIT;
        jr.params = qo.getMatchParams();
        try {
            o = new WaitingObject(qo);
        }
        catch (NeverWouldJoinException e) {
            e.printStackTrace();
            return jr;
        }
        Arena a = this.reserveNextArena(qo.getMatchParams(), qo.getJoinOptions());
        if (a == null) {
            List<WaitingObject> list = this.joinHandlers;
            synchronized (list) {
                this.joinHandlers.add(o);
            }
            this.updateTimer(o, 0L);
        } else {
            this.addReadyMatch(jr, o, a);
        }
        return jr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinResult join(TeamJoinObject qo) {
        JoinResult jr = new JoinResult();
        jr.status = JoinResult.JoinStatus.CANT_FIT;
        jr.params = qo.getMatchParams();
        jr.maxPlayers = qo.getMatchParams().getMaxPlayers();
        FoundMatch mf = null;
        WaitingObject o = null;
        boolean entered = false;
        List<WaitingObject> list = this.joinHandlers;
        synchronized (list) {
            Iterator<WaitingObject> iter = this.joinHandlers.iterator();
            block9: while (iter.hasNext()) {
                Arena arena;
                o = iter.next();
                if (!o.matches(qo)) continue;
                AbstractJoinHandler.TeamJoinResult r = o.join(qo);
                switch (r.status) {
                    case ADDED: 
                    case ADDED_TO_EXISTING: 
                    case ADDED_STILL_NEEDS_PLAYERS: {
                        entered = true;
                        break;
                    }
                    case CANT_FIT: {
                        continue block9;
                    }
                }
                if (!o.isFull() && (!this.timeExpired(o) || !o.hasEnough()) || (arena = this.reserveNextArena(o.getParams(), qo.getJoinOptions())) == null) break;
                mf = this.createFoundMatch(jr, o, arena);
                iter.remove();
                break;
            }
            if (mf == null && !entered) {
                try {
                    o = new WaitingObject(qo);
                    o.join(qo);
                    if (o.createsOnJoin()) {
                        Arena arena = this.getStartImmediately(o);
                        if (arena == null) {
                            jr.status = JoinResult.JoinStatus.ERROR;
                            return jr;
                        }
                        mf = this.createFoundMatch(jr, o, arena);
                        mf.startMatch();
                        return jr;
                    }
                    entered = true;
                    this.joinHandlers.add(o);
                    jr.status = JoinResult.JoinStatus.ADDED_TO_QUEUE;
                }
                catch (NeverWouldJoinException e) {
                    e.printStackTrace();
                }
            }
        }
        if (entered && o != null) {
            jr.status = JoinResult.JoinStatus.ADDED_TO_QUEUE;
            Integer i = inQueueForGame.get(o.getParams().getType());
            i = i == null ? qo.size() : i + qo.size();
            inQueueForGame.put(o.getParams().getType(), i);
            jr.playersInQueue = i;
            jr.pos = i;
            if (o.getArena() != null) {
                i = inQueueForArena.get(o.getArena());
                inQueueForArena.put(o.getArena(), i != null ? i + qo.size() : qo.size());
            }
            this.updateTimer(o);
            for (ArenaTeam t : qo.getTeams()) {
                for (ArenaPlayer ap : t.getPlayers()) {
                    this.inQueue.put(ap.getID(), o);
                    this.callEvent(new ArenaPlayerEnterQueueEvent(ap, t, qo, jr));
                }
                this.methodController.updateEvents(MatchState.ONENTER, t.getPlayers());
            }
        }
        if (mf != null) {
            this.addReadyMatch(mf);
        }
        return jr;
    }

    public Match createMatch(Arena arena, EventOpenOptions eoo) throws MatchCreationException, NeverWouldJoinException {
        FoundMatch mf = new FoundMatch();
        mf.arena = arena;
        mf.params = eoo.getParams();
        Match arenaMatch = mf.startMatch();
        AbstractJoinHandler jh = TeamJoinFactory.createTeamJoinHandler(eoo.getParams(), arenaMatch);
        arenaMatch.hookTeamJoinHandler(jh);
        return arenaMatch;
    }

    private Arena getStartImmediately(WaitingObject o) {
        if (this.getNumberOpenMatches(o.getParams().getType()) >= o.getParams().getNConcurrentCompetitions()) {
            return null;
        }
        return this.reserveNextArena(o.getParams(), o.getJoinOptions());
    }

    public boolean leave(ArenaPlayer player) {
        WaitingObject tjh = this.removeFromQueue(player, true);
        return tjh != null;
    }

    private void removeFromQueue(AbstractJoinHandler joinHandler) {
        for (ArenaTeam t : joinHandler.getTeams()) {
            for (ArenaPlayer ap : t.getPlayers()) {
                this.removeFromQueue(ap, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WaitingObject removeFromQueue(ArenaPlayer player, boolean leaveJoinHandler) {
        WaitingObject wo = this.inQueue.remove(player.getID());
        if (wo != null) {
            if (leaveJoinHandler) {
                wo.jh.leave(player);
                if (wo.jh.getnPlayers() == 0) {
                    List<WaitingObject> list = this.joinHandlers;
                    synchronized (list) {
                        this.joinHandlers.remove(wo);
                    }
                }
            }
            inQueueForGame.put(wo.getParams().getType(), inQueueForGame.get(wo.getParams().getType()) - 1);
            if (wo.getArena() != null) {
                inQueueForArena.put(wo.getArena(), inQueueForArena.get(wo.getArena()) - 1);
            }
            this.methodController.updateEvents(MatchState.ONLEAVE, player);
            this.callEvent(new ArenaPlayerLeaveQueueEvent(player, wo.getParams(), wo.getArena()));
        }
        return wo;
    }

    private FoundMatch createFoundMatch(JoinResult jr, WaitingObject o, Arena arena) {
        FoundMatch mf = new FoundMatch();
        mf.arena = arena;
        mf.wo = o;
        mf.params = o.getParams();
        mf.joinHandler = o.jh;
        if (jr != null) {
            jr.status = JoinResult.JoinStatus.STARTED_NEW_GAME;
            jr.params = o.getParams();
        }
        return mf;
    }

    public boolean forceStart(boolean respectMinimumPlayers) {
        return this.forceStart(null, respectMinimumPlayers);
    }

    public boolean forceStart(MatchParams params, boolean needsMinPlayers) {
        return this.forceStart(null, params, needsMinPlayers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forceStart(WaitingObject wo, MatchParams params, boolean needsMinPlayers) {
        ArrayList<FoundMatch> finds = null;
        List<WaitingObject> list = this.joinHandlers;
        synchronized (list) {
            Iterator<WaitingObject> iter = this.joinHandlers.iterator();
            boolean resetParams = false;
            while (iter.hasNext()) {
                WaitingObject o = iter.next();
                if (wo != null && !o.equals(wo)) continue;
                if (!o.hasEnough()) {
                    if (needsMinPlayers) continue;
                    resetParams = true;
                }
                if (params != null && !o.getParams().matches(params)) continue;
                Arena arena = this.reserveNextArena(o.getParams(), o.getJoinOptions());
                if (arena == null) break;
                FoundMatch mf = this.createFoundMatch(null, o, arena);
                iter.remove();
                if (finds == null) {
                    finds = new ArrayList<FoundMatch>();
                }
                if (resetParams) {
                    mf.params = ParamController.copyParams(mf.params);
                    mf.params.setNTeams(new MinMax(0, Integer.MAX_VALUE));
                    mf.params.setTeamSize(new MinMax(0, Integer.MAX_VALUE));
                }
                finds.add(mf);
            }
        }
        if (finds != null) {
            for (FoundMatch mf : finds) {
                this.addReadyMatch(mf);
            }
        }
        this.checkDelayedMatches();
        return finds != null && !finds.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(WaitingObject wo) {
        List<WaitingObject> list = this.joinHandlers;
        synchronized (list) {
            this.joinHandlers.remove(wo);
            this.removeTimer(wo);
        }
    }

    public boolean isInQue(ArenaPlayer p) {
        return this.inQueue.containsKey(p.getID());
    }

    public boolean isInQue(UUID id) {
        return this.inQueue.containsKey(id);
    }

    public WaitingObject getQueueObject(ArenaPlayer p) {
        return this.inQueue.get(p.getID());
    }

    public void stop() {
        this.suspend.set(true);
    }

    public void resume() {
        this.suspend.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ArenaTeam> purgeQueue() {
        ArrayList<ArenaTeam> teams = new ArrayList<ArenaTeam>();
        HashMap<ArenaPlayer, WaitingObject> players = new HashMap<ArenaPlayer, WaitingObject>();
        Object object = this.delayedReadyMatches;
        synchronized (object) {
            for (List list : this.delayedReadyMatches.values()) {
                for (FoundMatch fm : list) {
                    teams.addAll(fm.wo.jh.getTeams());
                    for (ArenaPlayer ap : fm.wo.getPlayers()) {
                        fm.wo.jh.leave(ap);
                        players.put(ap, fm.wo);
                    }
                }
            }
            this.delayedReadyMatches.clear();
        }
        object = this.joinHandlers;
        synchronized (object) {
            for (WaitingObject waitingObject : this.joinHandlers) {
                teams.addAll(waitingObject.jh.getTeams());
                for (ArenaPlayer ap : waitingObject.getPlayers()) {
                    waitingObject.jh.leave(ap);
                    players.put(ap, waitingObject);
                }
            }
            this.joinHandlers.clear();
        }
        for (Map.Entry entry : players.entrySet()) {
            this.callEvent(new ArenaPlayerLeaveQueueEvent((ArenaPlayer)entry.getKey(), ((WaitingObject)entry.getValue()).getParams(), ((WaitingObject)entry.getValue()).getArena()));
        }
        this.inQueue.clear();
        inQueueForGame.clear();
        inQueueForArena.clear();
        return teams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Arena getNextArena(MatchParams mp) {
        Map<ArenaType, ArenaQueue> map = this.arenaqueue;
        synchronized (map) {
            ArenaQueue aq = this.arenaqueue.get(mp.getType());
            if (aq == null) {
                return null;
            }
            for (Arena a : aq) {
                if (a.getArenaType() != mp.getType() || !a.valid() || !a.matches(mp)) continue;
                return a;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Arena getNextArena(JoinOptions jo) {
        Map<ArenaType, ArenaQueue> map = this.arenaqueue;
        synchronized (map) {
            ArenaQueue aq = this.arenaqueue.get(jo.getMatchParams().getType());
            if (aq == null) {
                return null;
            }
            for (Arena a : aq) {
                if (!a.valid() || !a.matches(jo)) continue;
                return a;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Arena reserveNextArena(MatchParams mp, JoinOptions jo) {
        Map<ArenaType, ArenaQueue> map = this.arenaqueue;
        synchronized (map) {
            ArenaQueue aq = this.arenaqueue.get(mp.getType());
            if (aq == null) {
                return null;
            }
            Iterator iter = aq.iterator();
            while (iter.hasNext()) {
                Arena a = (Arena)iter.next();
                if (!a.valid() || !a.matches(jo)) continue;
                iter.remove();
                return a;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Arena removeArena(Arena arena) {
        Map<ArenaType, ArenaQueue> map = this.arenaqueue;
        synchronized (map) {
            ArenaQueue aq = this.arenaqueue.get(arena.getArenaType());
            if (aq == null) {
                return null;
            }
            Iterator iter = aq.iterator();
            while (iter.hasNext()) {
                Arena a = (Arena)iter.next();
                if (!a.getName().equalsIgnoreCase(arena.getName())) continue;
                iter.remove();
                return a;
            }
        }
        return null;
    }

    public Arena reserveArena(Arena arena) {
        return this.removeArena(arena);
    }

    public String toString() {
        return this.queuesToString() + this.toStringArenas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringArenas() {
        StringBuilder sb = new StringBuilder();
        sb.append("------AMQ Arenas------- \n");
        Map<ArenaType, ArenaQueue> map = this.arenaqueue;
        synchronized (map) {
            for (Map.Entry<ArenaType, ArenaQueue> entry : this.arenaqueue.entrySet()) {
                sb.append(" ------ ").append(entry.getKey()).append("------- \n");
                for (Arena arena : entry.getValue()) {
                    sb.append(arena).append("\n");
                }
            }
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queuesToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("------game queues-------\n");
        Object object = this.joinHandlers;
        synchronized (object) {
            for (WaitingObject waitingObject : this.joinHandlers) {
                IdTime t = this.forceTimers.get(waitingObject);
                sb.append("  ------ o ").append(waitingObject.hashCode()).append(" - ").append(waitingObject.params.getDisplayName()).append(" - ").append(waitingObject.getArena() != null ? waitingObject.getArena().getName() : "null");
                if (t != null) {
                    sb.append(" fs=").append((t.time - System.currentTimeMillis()) / 1000L);
                }
                sb.append("------\n");
                for (ArenaTeam at : waitingObject.jh.getTeams()) {
                    sb.append("  t ").append(at).append(" - ").append(at.getId()).append("\n");
                }
            }
        }
        sb.append("------ready matches queue-------\n");
        object = this.delayedReadyMatches;
        synchronized (object) {
            for (Map.Entry entry : this.delayedReadyMatches.entrySet()) {
                for (FoundMatch fm : (LinkedList)entry.getValue()) {
                    sb.append("  ------ o ").append(fm.wo.hashCode()).append(" - ").append(fm.wo.params.getDisplayName()).append(" - ").append(fm.wo.getArena() != null ? fm.wo.getArena().getName() : "null").append("------\n");
                    for (ArenaTeam at : fm.wo.jh.getTeams()) {
                        sb.append("  t ").append(at).append(" - ").append(at.getId()).append("\n");
                    }
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ArenaPlayer> getPlayersInQueue(MatchParams params) {
        ArrayList<ArenaPlayer> players = new ArrayList<ArenaPlayer>();
        Object object = this.joinHandlers;
        synchronized (object) {
            for (WaitingObject o : this.joinHandlers) {
                if (!params.matches(o.getParams())) continue;
                for (ArenaTeam at : o.jh.getTeams()) {
                    players.addAll(at.getPlayers());
                }
            }
        }
        object = this.delayedReadyMatches;
        synchronized (object) {
            List list = this.delayedReadyMatches.get(params.getType());
            if (list != null) {
                for (FoundMatch fm : list) {
                    players.addAll(fm.wo.getPlayers());
                }
            }
        }
        return players;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ArenaPlayer> getPlayersInAllQueues() {
        ArrayList<ArenaPlayer> players = new ArrayList<ArenaPlayer>();
        Object object = this.joinHandlers;
        synchronized (object) {
            for (WaitingObject waitingObject : this.joinHandlers) {
                for (ArenaTeam at : waitingObject.jh.getTeams()) {
                    players.addAll(at.getPlayers());
                }
            }
        }
        object = this.delayedReadyMatches;
        synchronized (object) {
            for (List list : this.delayedReadyMatches.values()) {
                for (FoundMatch fm : list) {
                    players.addAll(fm.wo.getPlayers());
                }
            }
        }
        return players;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> invalidReason(WaitingObject qo) {
        ArrayList<String> reasons = new ArrayList<String>();
        MatchParams params = qo.getParams();
        Map<ArenaType, ArenaQueue> map = this.arenaqueue;
        synchronized (map) {
            ArenaQueue aq = this.arenaqueue.get(params.getType());
            for (Arena arena : aq) {
                reasons.addAll(arena.getInvalidMatchReasons(params, qo.getJoinOptions()));
            }
        }
        return reasons;
    }

    public void removeAllArenas() {
        this.arenaqueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllArenas(ArenaType arenaType) {
        Map<ArenaType, ArenaQueue> map = this.arenaqueue;
        synchronized (map) {
            ArenaQueue aq = this.arenaqueue.get(arenaType);
            if (aq != null) {
                aq.clear();
            }
        }
    }

    public void clearTeamQueues() {
        for (IdTime idt : this.forceTimers.values()) {
            idt.c.stop();
        }
        this.forceTimers.clear();
    }

    protected void callEvent(BAEvent event) {
        this.methodController.callEvent(event);
    }

    public int getQueueCount(Arena arena) {
        return inQueueForArena.containsKey(arena) ? inQueueForArena.get(arena) : 0;
    }

    public int getQueueCount(ArenaParams params) {
        return inQueueForGame.containsKey(params.getType()) ? inQueueForGame.get(params.getType()) : 0;
    }

    @ArenaEventHandler
    public void onArenaPlayerLeaveEvent(ArenaPlayerLeaveEvent event) {
        WaitingObject wo = this.removeFromQueue(event.getPlayer(), true);
        if (wo != null) {
            ArenaPlayer ap = event.getPlayer();
            event.addMessage(MessageHandler.getSystemMessage("you_left_queue", wo.getParams().getName()));
            if (ap.getCompetition() != null && ap.getCompetition() instanceof Match) {
                return;
            }
            PlayerSave ps = ap.getMetaData().getJoinRequirements();
            if (ps != null) {
                new PlayerStoreController(ps).restoreAll(event.getPlayer());
            }
        }
    }

    @ArenaEventHandler
    public void onPlayerChangeWorld(PlayerTeleportEvent event) {
        ArenaPlayer ap;
        if (event.isCancelled()) {
            return;
        }
        if (event.getFrom().getWorld().getUID() != event.getTo().getWorld().getUID() && !event.getPlayer().hasPermission("arena.teleport.bypass") && this.removeFromQueue(ap = BattleArena.toArenaPlayer(event.getPlayer()), true) != null) {
            MessageUtil.sendMessage(ap, "&cYou have been removed from the queue for changing worlds");
        }
    }

    @ArenaEventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (!event.isCancelled() && CommandUtil.shouldCancel(event, disabledAllCommands, disabledCommands, enabledCommands)) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(ChatColor.RED + "You cannot use that command when you are in the queue");
            if (PermissionsUtil.isAdmin((CommandSender)event.getPlayer())) {
                MessageUtil.sendMessage((CommandSender)event.getPlayer(), "&cYou can set &6/bad allowAdminCommands true: &c to change");
            }
        }
    }

    public static void setDisabledCommands(List<String> commands) {
        if (commands == null) {
            return;
        }
        disabledCommands.clear();
        if (commands.contains("all")) {
            disabledAllCommands = true;
        } else {
            for (String s : commands) {
                disabledCommands.add("/" + s.toLowerCase());
            }
        }
    }

    public static void setEnabledCommands(List<String> commands) {
        if (commands == null) {
            return;
        }
        enabledCommands.clear();
        for (String s : commands) {
            enabledCommands.add("/" + s.toLowerCase());
        }
    }

    private boolean timeExpired(WaitingObject wo) {
        IdTime idt = this.forceTimers.get(wo);
        return idt != null && System.currentTimeMillis() - idt.time >= 0L;
    }

    private Long removeTimer(WaitingObject wo) {
        IdTime idt = this.forceTimers.remove(wo);
        if (idt != null && idt.c != null) {
            idt.c.stop();
            return idt.time - System.currentTimeMillis();
        }
        return null;
    }

    private IdTime updateTimer(WaitingObject to) {
        Long time = System.currentTimeMillis() + (long)(to.getParams().getForceStartTime() * 1000);
        return this.updateTimer(to, time);
    }

    private IdTime updateTimer(WaitingObject to, Long time) {
        IdTime idt = this.forceTimers.get(to);
        if (idt == null) {
            idt = new IdTime();
            idt.time = time;
            new AnnounceInterval(this, to, idt, time - System.currentTimeMillis());
        }
        return idt;
    }

    public int getNumberOpenMatches(ArenaType type) {
        Integer count = this.runningMatchTypes.get(type);
        if (count == null) {
            count = 0;
            this.runningMatchTypes.put(type, count);
        }
        return count;
    }

    public int incNumberOpenMatches(ArenaType type) {
        Integer count = this.runningMatchTypes.get(type);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.runningMatchTypes.put(type, count);
        return count;
    }

    private int decNumberOpenMatches(ArenaType type) {
        Integer count = this.runningMatchTypes.get(type);
        if (count == null) {
            count = 1;
        }
        count = count - 1;
        this.runningMatchTypes.put(type, count);
        return count;
    }

    @EventHandler
    public void matchFinished(MatchFinishedEvent event) {
        Match am = event.getMatch();
        this.decNumberOpenMatches(am.getArena().getArenaType());
        this.forceStart(true);
    }

    static {
        disabledCommands = new HashSet();
        enabledCommands = new HashSet();
        inQueueForGame = new HashMap<ArenaType, Integer>();
        inQueueForArena = new HashMap<Arena, Integer>();
    }

    class AnnounceInterval {
        AnnounceInterval(final ArenaMatchQueue amq, final WaitingObject wo, IdTime idt, long timeMillis) {
            Countdown c = new Countdown((Plugin)BattleArena.getSelf(), timeMillis / 1000L, 30L, new Countdown.CountdownCallback(){

                public boolean intervalTick(int secondsRemaining) {
                    if (secondsRemaining > 0 || secondsRemaining < 0) {
                        HashSet<ArenaPlayer> players = new HashSet<ArenaPlayer>();
                        players.addAll(wo.getPlayers());
                        String msg = BAExecutor.constructMessage(wo.getParams(), (long)secondsRemaining * 1000L, players.size(), null);
                        MessageUtil.sendMessage(players, msg);
                    } else if (!amq.forceStart(wo, null, true) && wo.getParams().isCancelIfNotEnoughPlayers().booleanValue()) {
                        amq.remove(wo);
                    }
                    return true;
                }
            });
            c.setCancelOnExpire(false);
            idt.c = c;
            ArenaMatchQueue.this.forceTimers.put(wo, idt);
        }
    }

    public class FoundMatch {
        public Arena arena;
        public WaitingObject wo;
        MatchParams params;
        public AbstractJoinHandler joinHandler;

        public Match startMatch() {
            boolean timedStart;
            ArenaMatchQueue.this.incNumberOpenMatches(this.params.getType());
            if (this.wo != null) {
                ArenaMatchQueue.this.removeTimer(this.wo);
            }
            final ArenaMatch m = new ArenaMatch(this.arena, this.params, this.wo != null ? this.wo.getArenaListeners() : null);
            final boolean hasJoinHandler = this.joinHandler != null && this.joinHandler.getTeams() != null;
            boolean bl = timedStart = this.wo != null && this.wo.createsOnJoin() && this.wo.getParams().getForceStartTime() > 0;
            if (hasJoinHandler) {
                m.hookTeamJoinHandler(this.joinHandler);
            }
            MatchCreatedEvent mce = new MatchCreatedEvent(m, this.wo);
            m.callEvent(mce);
            if (hasJoinHandler) {
                this.addCompetition(this.joinHandler, m);
            }
            m.open();
            if (timedStart) {
                m.setTimedStart(this.wo.getParams().getForceStartTime(), 30);
            }
            Scheduler.scheduleSynchronousTask(new Runnable(){

                public void run() {
                    if (hasJoinHandler) {
                        ArenaMatchQueue.this.removeFromQueue(FoundMatch.this.joinHandler);
                    }
                    if (!timedStart) {
                        m.run();
                    }
                }
            });
            return m;
        }

        private void addCompetition(AbstractJoinHandler joinHandler, Match m) {
            for (ArenaTeam t : joinHandler.getTeams()) {
                for (ArenaPlayer ap : t.getPlayers()) {
                    ap.addCompetition(m);
                }
            }
        }
    }

    public static class IdTime {
        public Countdown c;
        public Long time;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueueType {
        GAME,
        ARENA;

    }
}

