/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.joining;

import java.util.Collection;
import java.util.List;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.Matchup;
import mc.alk.arena.objects.joining.QueueObject;
import mc.alk.arena.objects.teams.ArenaTeam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchTeamQObject
extends QueueObject {
    final Matchup matchup;

    public MatchTeamQObject(Matchup matchup) {
        super(matchup.getJoinOptions());
        this.matchup = matchup;
        this.priority = matchup.getPriority();
        for (ArenaTeam t : matchup.getTeams()) {
            this.numPlayers += t.size();
        }
        this.listeners = matchup.getArenaListeners();
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public boolean hasMember(ArenaPlayer p) {
        return this.matchup.hasMember(p);
    }

    @Override
    public ArenaTeam getTeam(ArenaPlayer p) {
        return this.matchup.getTeam(p);
    }

    @Override
    public int size() {
        return this.matchup.size();
    }

    public String toString() {
        return this.priority + " " + this.matchup.toString();
    }

    @Override
    public Collection<ArenaTeam> getTeams() {
        return this.matchup.getTeams();
    }

    public Matchup getMatchup() {
        return this.matchup;
    }

    @Override
    public boolean hasTeam(ArenaTeam team) {
        List<ArenaTeam> teams = this.matchup.getTeams();
        return teams != null && teams.contains(team);
    }
}

