/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.joining;

import java.util.ArrayList;
import java.util.Collection;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.joining.QueueObject;
import mc.alk.arena.objects.options.JoinOptions;
import mc.alk.arena.objects.teams.ArenaTeam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamJoinObject
extends QueueObject {
    final ArenaTeam team;

    public TeamJoinObject(ArenaTeam team, MatchParams params, JoinOptions joinOptions) {
        super(joinOptions, params);
        this.team = team;
        this.priority = team.getPriority();
        this.numPlayers += team.size();
    }

    public ArenaTeam getTeam() {
        return this.team;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public boolean hasMember(ArenaPlayer p) {
        return this.team.hasMember(p);
    }

    @Override
    public ArenaTeam getTeam(ArenaPlayer p) {
        return this.team.hasMember(p) ? this.team : null;
    }

    @Override
    public int size() {
        return this.team.size();
    }

    public String toString() {
        return this.team.getPriority() + " " + this.team.toString() + ":" + this.team.getId();
    }

    @Override
    public Collection<ArenaTeam> getTeams() {
        ArrayList<ArenaTeam> teams = new ArrayList<ArenaTeam>(1);
        teams.add(this.team);
        return teams;
    }

    @Override
    public boolean hasTeam(ArenaTeam team) {
        if (this.team.getId() == team.getId()) {
            return true;
        }
        for (ArenaPlayer ap : this.team.getPlayers()) {
            if (!team.hasMember(ap)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStartPerms() {
        return false;
    }
}

