/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.joining;

import java.util.Collection;
import mc.alk.arena.controllers.joining.AbstractJoinHandler;
import mc.alk.arena.controllers.joining.TeamJoinFactory;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.exceptions.NeverWouldJoinException;
import mc.alk.arena.objects.joining.MatchTeamQObject;
import mc.alk.arena.objects.joining.QueueObject;
import mc.alk.arena.objects.joining.TeamJoinObject;
import mc.alk.arena.objects.options.JoinOptions;
import mc.alk.arena.objects.options.TransitionOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitingObject {
    protected boolean joinable = true;
    protected final AbstractJoinHandler jh;
    protected final MatchParams params;
    protected final QueueObject originalQueuedObject;
    protected final Arena arena;

    public WaitingObject(QueueObject qo) throws NeverWouldJoinException {
        this.params = qo.getMatchParams();
        this.originalQueuedObject = qo;
        this.arena = qo.getJoinOptions().getArena();
        if (qo instanceof MatchTeamQObject) {
            this.jh = TeamJoinFactory.createTeamJoinHandler(qo.getMatchParams(), qo.getTeams());
            this.joinable = false;
        } else {
            this.jh = TeamJoinFactory.createTeamJoinHandler(qo.getMatchParams());
            this.joinable = true;
        }
    }

    public boolean matches(QueueObject qo) {
        return this.joinable && (this.arena != null ? this.arena.matches(qo.getJoinOptions()) : this.params.matches(qo.getJoinOptions()));
    }

    public AbstractJoinHandler.TeamJoinResult join(TeamJoinObject qo) {
        return this.jh.joiningTeam(qo);
    }

    public boolean hasEnough() {
        return this.jh.hasEnough(this.params.getAllowedTeamSizeDifference());
    }

    public boolean isFull() {
        return this.jh.isFull();
    }

    public MatchParams getParams() {
        return this.params;
    }

    public Arena getArena() {
        return this.arena;
    }

    public Collection<ArenaPlayer> getPlayers() {
        return this.jh.getPlayers();
    }

    public JoinOptions getJoinOptions() {
        return this.originalQueuedObject.getJoinOptions();
    }

    public Collection<ArenaListener> getArenaListeners() {
        return this.originalQueuedObject.getListeners();
    }

    public QueueObject getOriginalQueuedObject() {
        return this.originalQueuedObject;
    }

    public String toString() {
        return "[WO " + (this.arena != null ? this.arena.getName() : "") + " " + this.params.getDisplayName() + "]";
    }

    public boolean createsOnJoin() {
        Arena a = this.originalQueuedObject.getArena();
        if (a != null) {
            return a.getParams().hasOptionAt((CompetitionState)MatchState.ONJOIN, TransitionOption.TELEPORTIN) || this.params.hasOptionAt((CompetitionState)MatchState.ONJOIN, TransitionOption.TELEPORTIN);
        }
        return this.params.hasOptionAt((CompetitionState)MatchState.ONJOIN, TransitionOption.TELEPORTIN);
    }
}

