/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.messaging;

import java.util.EnumMap;
import java.util.Map;
import mc.alk.arena.BattleArena;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.messaging.Channel;
import mc.alk.arena.objects.messaging.Channels;
import mc.alk.arena.objects.messaging.ChatPlugin;
import mc.alk.arena.objects.messaging.WorldChannel;
import mc.alk.arena.util.Log;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.Bukkit;
import org.bukkit.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnouncementOptions {
    static AnnouncementOptions defaultOptions;
    public static ChatPlugin chatPlugin;
    public static Chat chat;
    final Map<MatchState, Map<AnnouncementOption, Object>> matchOptions = new EnumMap<MatchState, Map<AnnouncementOption, Object>>(MatchState.class);
    final Map<MatchState, Map<AnnouncementOption, Object>> eventOptions = new EnumMap<MatchState, Map<AnnouncementOption, Object>>(MatchState.class);

    public static void setPlugin(ChatPlugin plugin) {
        chatPlugin = plugin;
    }

    public static void setVaultChat(Chat chat) {
        AnnouncementOptions.chat = chat;
    }

    public void setBroadcastOption(boolean match, MatchState ms, AnnouncementOption bo, String value) {
        Map<MatchState, Map<AnnouncementOption, Object>> options = match ? this.matchOptions : this.eventOptions;
        Map<AnnouncementOption, Object> ops = options.get(ms);
        if (ops == null) {
            ops = new EnumMap<AnnouncementOption, Object>(AnnouncementOption.class);
            options.put(ms, ops);
        }
        switch (bo) {
            case CHANNEL: {
                if (chatPlugin == null) {
                    Log.err(BattleArena.getPluginName() + "config.yml Announcement option channel=" + value + ", will be ignored as a Chat plugin is not enabled. Defaulting to Server Announcement");
                    ops.put(AnnouncementOption.SERVER, null);
                    return;
                }
                Channel channel = chatPlugin.getChannel(value);
                if (channel != null) break;
                Log.err(BattleArena.getPluginName() + "config.yml Announcement option channel=" + value + ", will be ignored as channel " + value + " can not be found. Defaulting to Server Announcement");
                ops.put(AnnouncementOption.SERVER, null);
                return;
            }
            case DONTANNOUNCE: {
                break;
            }
            case SERVER: {
                break;
            }
            case WORLD: {
                if (value == null) {
                    Log.err(BattleArena.getPluginName() + "config.yml Announcement option world needs a value. Defaulting to Server Announcement");
                    ops.put(AnnouncementOption.SERVER, null);
                    return;
                }
                World w = Bukkit.getWorld((String)value);
                if (w != null) break;
                Log.err(BattleArena.getPluginName() + "config.yml Announcement option world=" + value + ", will be ignored as world " + value + " can not be found. Defaulting to Server Announcement");
                ops.put(AnnouncementOption.SERVER, null);
                return;
            }
        }
        ops.put(bo, value);
    }

    public static void setDefaultOptions(AnnouncementOptions bo) {
        defaultOptions = bo;
    }

    public Channel getChannel(boolean match, MatchState state) {
        World w;
        Map<MatchState, Map<AnnouncementOption, Object>> options = match ? this.matchOptions : this.eventOptions;
        Map<AnnouncementOption, Object> ops = options.get(state);
        if (ops == null || ops.containsKey((Object)AnnouncementOption.DONTANNOUNCE)) {
            return Channels.NullChannel;
        }
        if (ops.containsKey((Object)AnnouncementOption.CHANNEL)) {
            String hcChannelName = (String)ops.get((Object)AnnouncementOption.CHANNEL);
            if (chatPlugin == null) {
                Log.warn(BattleArena.getPluginName() + " channel plugin is not enabled, ignoring config.yml announcement option channel=" + hcChannelName);
                return Channels.ServerChannel;
            }
            Channel channel = chatPlugin.getChannel(hcChannelName);
            if (channel == null) {
                Log.warn(BattleArena.getPluginName() + " channel not found!. ignoring config.yml announcement option channel=" + hcChannelName);
                return Channels.ServerChannel;
            }
            return channel;
        }
        if (ops.containsKey((Object)AnnouncementOption.WORLD) && (w = Bukkit.getWorld((String)((String)ops.get((Object)AnnouncementOption.WORLD)))) != null) {
            return new WorldChannel(w);
        }
        return Channels.ServerChannel;
    }

    public static Channel getDefaultChannel(boolean match, MatchState state) {
        return defaultOptions.getChannel(match, state);
    }

    public boolean hasOption(boolean match, MatchState state) {
        Map<MatchState, Map<AnnouncementOption, Object>> options = match ? this.matchOptions : this.eventOptions;
        return options.containsKey(state);
    }

    public Map<MatchState, Map<AnnouncementOption, Object>> getMatchOptions() {
        return this.matchOptions;
    }

    public Map<MatchState, Map<AnnouncementOption, Object>> getEventOptions() {
        return this.eventOptions;
    }

    static {
        chatPlugin = null;
        chat = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnnouncementOption {
        ANNOUNCE,
        DONTANNOUNCE,
        SERVER,
        CHANNEL,
        WORLD;


        public static AnnouncementOption fromName(String str) {
            str = str.toUpperCase();
            AnnouncementOption ao = null;
            try {
                ao = AnnouncementOption.valueOf(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ao != null) {
                return ao;
            }
            if (str.contains("HC") || str.contains("HEROCHAT")) {
                return CHANNEL;
            }
            return null;
        }
    }
}

