/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.modules;

import java.io.File;
import java.io.IOException;
import mc.alk.arena.BattleArena;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.util.FileUtil;
import mc.alk.arena.util.Log;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public abstract class ArenaModule
implements Listener,
ArenaListener {
    private boolean enabled;
    protected FileConfiguration config;

    public void onEnable() {
        this.enabled = true;
    }

    public void onDisable() {
        this.enabled = false;
    }

    public abstract String getName();

    public abstract String getVersion();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        if (this.enabled != enable) {
            if (enable) {
                this.onEnable();
                Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BattleArena.getSelf());
            } else {
                this.onDisable();
                HandlerList.unregisterAll((Listener)this);
            }
        }
        this.enabled = enable;
    }

    public String getDescription() {
        return this.getName();
    }

    public void reloadConfig() {
        try {
            this.config.load(this.getConfigFile());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    protected File getConfigFile() {
        return new File(BattleArena.getSelf().getModuleDirectory() + "/" + this.getName());
    }

    protected void saveDefaultConfig() {
        File f = this.getConfigFile();
        if (this.config == null || !f.exists()) {
            if (FileUtil.hasResource(this.getClass(), "/config.yml")) {
                f = FileUtil.load(this.getClass(), f.getPath(), "/config.yml");
            } else {
                try {
                    f.createNewFile();
                }
                catch (IOException e) {
                    Log.printStackTrace(e);
                }
            }
            return;
        }
        try {
            this.config.save(f);
        }
        catch (IOException e) {
            Log.printStackTrace(e);
        }
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.saveDefaultConfig();
        }
        return this.config;
    }

    public String toString() {
        return "[" + this.getName() + "_" + this.getVersion() + "]";
    }
}

