/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.options;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.MoneyController;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.exceptions.InvalidOptionException;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.ServerUtil;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuelOptions {
    final List<ArenaPlayer> challengedPlayers = new ArrayList<ArenaPlayer>();
    final Map<DuelOption, Object> options = new EnumMap<DuelOption, Object>(DuelOption.class);
    static DuelOptions defaultOptions = new DuelOptions();

    public static DuelOptions parseOptions(String[] args) throws InvalidOptionException {
        return DuelOptions.parseOptions(null, null, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DuelOptions parseOptions(MatchParams params, ArenaPlayer challenger, String[] args) throws InvalidOptionException {
        DuelOptions dop = new DuelOptions();
        dop.options.putAll(DuelOptions.defaultOptions.options);
        Map<DuelOption, Object> ops = dop.options;
        block9: for (int i = 0; i < args.length; ++i) {
            String val;
            String op = args[i];
            Player p = ServerUtil.findPlayer(op);
            if (p != null) {
                if (!p.isOnline()) {
                    throw new InvalidOptionException("&cPlayer &6" + p.getDisplayName() + "&c is not online!");
                }
                if (challenger != null && p.getName().equals(challenger.getName())) {
                    throw new InvalidOptionException("&cYou can't challenge yourself!");
                }
                if (p.hasPermission("arena.duel.exempt") && !Defaults.DUEL_CHALLENGE_ADMINS) {
                    throw new InvalidOptionException("&cThis player can not be challenged!");
                }
                dop.challengedPlayers.add(BattleArena.toArenaPlayer(p));
                continue;
            }
            Object obj = null;
            if (op.contains("=")) {
                String[] split = op.split("=");
                op = split[0];
                val = split[1];
            } else {
                val = i + 1 < args.length ? args[i + 1] : null;
            }
            DuelOption to = DuelOptions.parseOp(op, val);
            switch (to) {
                case RATED: {
                    if (Defaults.DUEL_ALLOW_RATED) break;
                    throw new InvalidOptionException("&cRated formingDuels are not allowed!");
                }
            }
            if (!to.needsValue) {
                ops.put(to, null);
                continue;
            }
            ++i;
            switch (to) {
                case MONEY: {
                    Double money;
                    try {
                        money = Double.valueOf(val);
                    }
                    catch (Exception e) {
                        throw new InvalidOptionException("&cmoney needs to be a number! Example: &6money=100");
                    }
                    if (!MoneyController.hasEconomy()) {
                        if (challenger != null) {
                            MessageUtil.sendMessage(challenger, "&cignoring duel option money as there is no economy!");
                        }
                        Log.warn("[BA Error] ignoring duel option money as there is no economy!");
                        continue block9;
                    }
                    obj = money;
                    break;
                }
                case ARENA: {
                    Arena a = BattleArena.getBAController().getArena(val);
                    if (a == null) {
                        throw new InvalidOptionException("&cCouldnt find the arena &6" + val);
                    }
                    if (params != null && !a.getArenaType().matches(params.getType())) {
                        throw new InvalidOptionException("&cThe arena is used for a different type!");
                    }
                    obj = a;
                }
            }
            ops.put(to, obj);
        }
        if (challenger != null && dop.challengedPlayers.isEmpty()) {
            throw new InvalidOptionException("&cYou need to challenge at least one player!");
        }
        return dop;
    }

    private static DuelOption parseOp(String op, String value) throws InvalidOptionException {
        DuelOption to;
        try {
            to = DuelOption.fromName(op);
            if (to.needsValue && value == null) {
                throw new InvalidOptionException("&cThe option " + to.name() + " needs a value!");
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidOptionException("&cThe player or option " + op + " does not exist, \n&cvalid options=&6" + DuelOption.getValidList());
        }
        return to;
    }

    public String optionsString(MatchParams mp) {
        StringBuilder sb = new StringBuilder();
        sb.append("rated=").append(mp.isRated()).append(" ");
        for (DuelOption op : this.options.keySet()) {
            sb.append(op.getName());
            if (op.needsValue) {
                sb.append("=").append(this.options.get((Object)op));
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public List<ArenaPlayer> getChallengedPlayers() {
        return this.challengedPlayers;
    }

    public String getChallengedTeamString() {
        return MessageUtil.joinPlayers(this.getChallengedPlayers(), ", ");
    }

    public String getOtherChallengedString(ArenaPlayer ap) {
        ArrayList<ArenaPlayer> players = new ArrayList<ArenaPlayer>(this.challengedPlayers);
        players.remove(ap);
        return MessageUtil.joinPlayers(players, ", ");
    }

    public boolean hasOption(DuelOption option) {
        return this.options.containsKey((Object)option);
    }

    public Object getOptionValue(DuelOption option) {
        return this.options.get((Object)option);
    }

    public static void setDefaults(DuelOptions dop) {
        defaultOptions = dop;
    }

    public boolean matches(ArenaPlayer player, MatchParams mp) {
        if (mp.getThisStateGraph().hasOptionAt(MatchState.PREREQS, TransitionOption.WITHINDISTANCE)) {
            Double distance = mp.getStateGraph().getOptions(MatchState.PREREQS).getWithinDistance();
            if (this.options.containsKey((Object)DuelOption.ARENA)) {
                Arena arena = (Arena)this.options.get((Object)DuelOption.ARENA);
                return arena.withinDistance(player.getLocation(), distance);
            }
            for (Arena arena : BattleArena.getBAController().getArenas(mp)) {
                if (!arena.withinDistance(player.getLocation(), distance)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DuelOption {
        ARENA("<arena>", false),
        RATED("<rated>", false),
        UNRATED("<unrated>", false),
        MONEY("<money>", true);

        public final boolean needsValue;
        final String name;

        private DuelOption(String name, boolean needsValue) {
            this.needsValue = needsValue;
            this.name = name;
        }

        public String getName() {
            if (this == MONEY) {
                return Defaults.MONEY_STR;
            }
            return this.name;
        }

        public static DuelOption fromName(String str) {
            str = str.toUpperCase();
            try {
                return DuelOption.valueOf(str);
            }
            catch (Exception exception) {
                if (str.equals("BET") || str.equals("WAGER") || str.equals(Defaults.MONEY_STR)) {
                    return MONEY;
                }
                throw new IllegalArgumentException();
            }
        }

        public static String getValidList() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (DuelOption r : DuelOption.values()) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                String val = "";
                switch (r) {
                    case MONEY: {
                        val = " <amount>";
                        break;
                    }
                }
                sb.append(r.getName()).append(val);
            }
            return sb.toString();
        }
    }
}

