/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.options;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.BattleArenaController;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.exceptions.InvalidOptionException;
import mc.alk.arena.util.MinMax;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventOpenOptions {
    Map<EventOpenOption, Object> options = new EnumMap<EventOpenOption, Object>(EventOpenOption.class);
    MatchParams params;
    int announceInterval = 0;
    int secTillStart = -1;

    public static EventOpenOptions parseOptions(String[] args, Set<Integer> ignoreArgs, MatchParams params) throws InvalidOptionException {
        EventOpenOptions eoo = new EventOpenOptions();
        MatchParams mp = null;
        for (String op : args) {
            if (!op.equalsIgnoreCase("COPYPARAMS")) continue;
            mp = ParamController.copyParams(params);
            mp.flatten();
            break;
        }
        eoo.params = mp != null ? ParamController.copyParams(mp) : new MatchParams(params.getType());
        Map<EventOpenOption, Object> ops = eoo.options;
        eoo.params.setParent(params);
        int i = 0;
        for (String op : args) {
            EventOpenOption to;
            if (ignoreArgs != null && ignoreArgs.contains(i++) || op == null || op.isEmpty()) continue;
            Object obj = null;
            String[] split = op.split("=");
            split[0] = split[0].trim().toUpperCase();
            Arena arena = BattleArena.getBAController().getArena(op);
            if (arena != null) {
                ops.put(EventOpenOption.ARENA, arena);
                continue;
            }
            try {
                to = EventOpenOption.valueOf(split[0]);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidOptionException("&cThe option " + split[0] + " does not exist, \n&cvalid options=&6" + EventOpenOption.getValidList());
            }
            if (split.length == 1) {
                if (to == EventOpenOption.ARENA) continue;
                ops.put(to, null);
                continue;
            }
            String val = split[1].trim();
            switch (to) {
                case TEAMSIZE: {
                    try {
                        obj = MinMax.valueOf(val);
                        eoo.getParams().setTeamSize((MinMax)obj);
                        break;
                    }
                    catch (Exception e) {
                        throw new InvalidOptionException("&cCouldnt parse teamSize &6" + val + " &e needs an int or range. &68, 2+, 2-10, etc");
                    }
                }
                case NTEAMS: {
                    try {
                        obj = MinMax.valueOf(val);
                        eoo.getParams().setNTeams((MinMax)obj);
                        break;
                    }
                    catch (Exception e) {
                        throw new InvalidOptionException("&cCouldnt parse nTeams &6" + val + " &e needs an int or range. &68, 2+, 2-10, etc");
                    }
                }
                case TIME: {
                    try {
                        obj = Integer.valueOf(val);
                    }
                    catch (Exception e) {
                        throw new InvalidOptionException("&cTime wasnt an integer: &6" + val);
                    }
                    eoo.secTillStart = (Integer)obj;
                    break;
                }
                case INTERVAL: {
                    try {
                        obj = Integer.valueOf(val);
                    }
                    catch (Exception e) {
                        throw new InvalidOptionException("&cTime interval wasnt an integer: &6" + val);
                    }
                    eoo.announceInterval = (Integer)obj;
                    break;
                }
                case ARENA: {
                    obj = BattleArena.getBAController().getArena(val);
                    if (obj != null) break;
                    throw new InvalidOptionException("&cCouldnt find the arena &6" + val);
                }
            }
            if (obj == null) continue;
            ops.put(to, obj);
        }
        eoo.updateParams(eoo.params);
        return eoo;
    }

    public Object getOption(EventOpenOption op) {
        return this.options.get((Object)op);
    }

    public boolean hasOption(EventOpenOption op) {
        return this.options.containsKey((Object)op);
    }

    public boolean isSilent() {
        return this.hasOption(EventOpenOption.SILENT);
    }

    public void updateParams(MatchParams mp) {
        if (this.hasOption(EventOpenOption.UNRATED)) {
            mp.setRated(false);
        }
        if (mp.getMaxTeams() == Integer.MAX_VALUE) {
            mp.setMaxTeamSize(mp.getMinTeamSize());
        }
        if (this.hasOption(EventOpenOption.NTEAMS)) {
            mp.setNTeams((MinMax)this.getOption(EventOpenOption.NTEAMS));
        }
        if (this.hasOption(EventOpenOption.TEAMSIZE)) {
            mp.setTeamSize((MinMax)this.getOption(EventOpenOption.TEAMSIZE));
        }
    }

    public MatchParams getParams() {
        return this.params;
    }

    public Arena getArena(MatchParams mp) throws InvalidOptionException {
        MatchParams ap;
        Arena arena;
        BattleArenaController ac = BattleArena.getBAController();
        boolean autoFindArena = false;
        if (this.hasOption(EventOpenOption.ARENA)) {
            arena = (Arena)this.getOption(EventOpenOption.ARENA);
        } else {
            arena = ac.getArenaByMatchParams(mp);
            if (arena == null) {
                Map<Arena, List<String>> reasons = ac.getNotMachingArenaReasons(mp);
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Arena a : reasons.keySet()) {
                    for (String reason : reasons.get(a)) {
                        if (!first) {
                            sb.append(", ");
                        }
                        sb.append("&e").append(a.getName()).append(":&e ").append(reason);
                        first = false;
                    }
                }
                throw new InvalidOptionException("&cCouldnt find an arena matching the params &6" + mp + "\n" + sb.toString());
            }
            autoFindArena = true;
        }
        if (!arena.valid()) {
            throw new InvalidOptionException("&cArena " + arena.getName() + " is not valid.");
        }
        String arenaName = arena.getName();
        if (autoFindArena) {
            arena = ac.nextArenaByMatchParams(mp);
            if (arena == null) {
                throw new InvalidOptionException("&cAll arenas matching those params are in use. wait till one is free ");
            }
        } else if ((arena = ac.reserveArena(arena)) == null) {
            throw new InvalidOptionException("&c Arena &6" + arenaName + "&c is currently in use, you'll have to wait till its free");
        }
        if (!(ap = arena.getParams()).matches(mp)) {
            throw new InvalidOptionException(StringUtils.join(ap.getInvalidMatchReasons(mp), (String)"\n"));
        }
        return arena;
    }

    public int getInterval() {
        return this.announceInterval == 0 ? Defaults.ANNOUNCE_EVENT_INTERVAL : this.announceInterval;
    }

    public int getSecTillStart() {
        return this.secTillStart == -1 ? Defaults.AUTO_EVENT_COUNTDOWN_TIME : this.secTillStart;
    }

    public void setSecTillStart(int secs) {
        this.secTillStart = secs;
    }

    public String getOpenCmd() {
        if (this.hasOption(EventOpenOption.AUTO)) {
            return EventOpenOption.AUTO.toString().toLowerCase();
        }
        return EventOpenOption.OPEN.toString().toLowerCase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventOpenOption {
        TEAMSIZE,
        NTEAMS,
        MAXTEAMS,
        SILENT,
        RATED,
        UNRATED,
        FORCEJOIN,
        OPEN,
        AUTO,
        TIME,
        INTERVAL,
        ARENA,
        COPYPARAMS;


        public static String getValidList() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (EventOpenOption r : EventOpenOption.values()) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                String val = "";
                switch (r) {
                    case TEAMSIZE: 
                    case NTEAMS: {
                        val = "=<int or range>";
                        break;
                    }
                    case TIME: 
                    case INTERVAL: {
                        val = "=<seconds>";
                        break;
                    }
                    case ARENA: {
                        val = "=<arena>";
                        break;
                    }
                }
                sb.append((Object)r).append(val);
            }
            return sb.toString();
        }
    }
}

