/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.options;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.containers.AbstractAreaContainer;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.exceptions.InvalidOptionException;
import mc.alk.arena.objects.spawns.SpawnLocation;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.MinMax;
import mc.alk.arena.util.PermissionsUtil;
import mc.alk.arena.util.TeamUtil;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class JoinOptions {
    final Map<JoinOption, Object> options = new EnumMap<JoinOption, Object>(JoinOption.class);
    Location joinedLocation = null;
    MatchParams params;
    MinMax teamSize;
    long joinTime = System.currentTimeMillis();

    public void setJoinLocation(Location joinLocation) {
        this.joinedLocation = joinLocation;
    }

    public boolean nearby(Arena arena, double distance) {
        if (this.joinedLocation == null) {
            return false;
        }
        UUID wid = this.joinedLocation.getWorld().getUID();
        Location arenajoinloc = arena.getJoinLocation();
        if (arenajoinloc != null) {
            return wid == arenajoinloc.getWorld().getUID() && arenajoinloc.distance(this.joinedLocation) <= distance;
        }
        for (List<SpawnLocation> list : arena.getSpawns()) {
            for (SpawnLocation l : list) {
                if (l.getLocation().getWorld().getUID() != wid) {
                    return false;
                }
                if (!(l.getLocation().distance(this.joinedLocation) <= distance)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean sameWorld(Arena arena) {
        UUID wid = this.joinedLocation.getWorld().getUID();
        Location arenajoinloc = arena.getJoinLocation();
        if (arenajoinloc != null) {
            return wid == arenajoinloc.getWorld().getUID();
        }
        for (List<SpawnLocation> list : arena.getSpawns()) {
            for (SpawnLocation l : list) {
                if (l.getLocation().getWorld().getUID() == wid) continue;
                return false;
            }
        }
        return true;
    }

    public static JoinOptions parseOptions(MatchParams omp, ArenaPlayer player, String[] args) throws InvalidOptionException, NumberFormatException {
        JoinOptions jos = new JoinOptions();
        MatchParams mp = new MatchParams(omp.getType());
        mp.setParent(omp);
        jos.setMatchParams(mp);
        jos.setJoinTime(System.currentTimeMillis());
        if (player != null) {
            jos.joinedLocation = player.getLocation();
        }
        Map<JoinOption, Object> ops = jos.options;
        AbstractAreaContainer arena = null;
        String lastArg = args.length > 0 ? args[args.length - 1] : "";
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            String op = args[i];
            if (op.isEmpty()) continue;
            Arena obj = null;
            op = MessageUtil.decolorChat(op);
            Arena a = BattleArena.getBAController().getArena(op);
            if (a != null) {
                if (arena != null) {
                    throw new InvalidOptionException("&cYou specified 2 arenas!");
                }
                if (!a.valid()) {
                    throw new InvalidOptionException("&cThe specified arena is not valid!");
                }
                arena = a;
                ops.put(JoinOption.ARENA, arena);
                continue;
            }
            try {
                Integer wantedSize = Integer.valueOf(op);
                ops.put(JoinOption.WANTEDTEAMSIZE, wantedSize);
                mp.setTeamSize(wantedSize);
                continue;
            }
            catch (Exception e) {
                JoinOption jo;
                Integer teamIndex = TeamUtil.getFromHumanTeamIndex(op);
                if (teamIndex != null) {
                    if (player != null && !PermissionsUtil.hasTeamPerm((CommandSender)player.getPlayer(), mp, teamIndex)) {
                        throw new InvalidOptionException("&cYou don't have permissions to add this team");
                    }
                    ops.put(JoinOption.TEAM, teamIndex);
                    continue;
                }
                try {
                    jo = JoinOption.fromName(op);
                    if (jo.needsValue && i + 1 >= args.length) {
                        throw new InvalidOptionException("&cThe option " + jo.name() + " needs a value!");
                    }
                }
                catch (IllegalArgumentException e2) {
                    throw new InvalidOptionException("&cThe arena or option " + op + " does not exist, \n&cvalid options=&6" + JoinOption.getValidList());
                }
                switch (jo) {
                    default: 
                }
                if (!jo.needsValue) {
                    ops.put(jo, null);
                    continue;
                }
                String val = args[++i];
                switch (jo) {
                    case ARENA: {
                        obj = BattleArena.getBAController().getArena(val);
                        if (obj == null) {
                            throw new InvalidOptionException("&cCouldnt find the arena &6" + val);
                        }
                        a = obj;
                        if (!a.valid()) {
                            throw new InvalidOptionException("&cThe specified arena is not valid!");
                        }
                        arena = a;
                    }
                }
                ops.put(jo, obj);
            }
        }
        if (arena != null) {
            mp.setParent(arena.getParams());
            if (!((Arena)arena).matches(jos)) {
                throw new InvalidOptionException("&cThe arena &6" + ((Arena)arena).getName() + "&c doesn't match your add requirements. " + StringUtils.join(((Arena)arena).getInvalidMatchReasons(mp, jos), (char)'\n'));
            }
        }
        MinMax mm = null;
        try {
            mm = MinMax.valueOf(lastArg);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (mm != null) {
            ops.put(JoinOption.WANTEDTEAMSIZE, mm);
        }
        jos.params = mp;
        return jos;
    }

    public void setJoinTime(Long currentTimeMillis) {
        this.joinTime = currentTimeMillis;
    }

    public Long getJoinTime() {
        return this.joinTime;
    }

    public String optionsString(MatchParams mp) {
        StringBuilder sb = new StringBuilder(mp.toPrettyString() + " ");
        for (JoinOption op : this.options.keySet()) {
            sb.append(op.getName());
            if (op.needsValue) {
                sb.append("=").append(this.options.get((Object)op));
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public boolean hasWantedTeamSize() {
        return this.options.containsKey((Object)JoinOption.WANTEDTEAMSIZE);
    }

    public boolean hasOption(JoinOption option) {
        return this.options.containsKey((Object)option);
    }

    public Object getOption(JoinOption option) {
        return this.options.get((Object)option);
    }

    public Object setOption(JoinOption option, Object value) {
        return this.options.put(option, value);
    }

    public boolean hasArena() {
        return this.options.containsKey((Object)JoinOption.ARENA) && this.options.get((Object)JoinOption.ARENA) != null;
    }

    public Arena getArena() {
        return this.hasArena() ? (Arena)this.options.get((Object)JoinOption.ARENA) : null;
    }

    public void setArena(Arena arena) {
        this.options.put(JoinOption.ARENA, arena);
    }

    public MatchParams getMatchParams() {
        return this.params;
    }

    public void setMatchParams(MatchParams matchParams) {
        this.params = matchParams;
    }

    public JoinOptions clone() {
        JoinOptions jo = new JoinOptions();
        jo.options.putAll(this.options);
        jo.joinedLocation = this.joinedLocation;
        jo.params = this.params;
        jo.teamSize = this.teamSize;
        jo.joinTime = this.joinTime;
        return jo;
    }

    public void setPlayer(ArenaPlayer player) throws InvalidOptionException {
        this.joinedLocation = player.getLocation();
        this.joinTime = System.currentTimeMillis();
        Object teamIndex = this.options.get((Object)JoinOption.TEAM);
        if (teamIndex != null && !PermissionsUtil.hasTeamPerm((CommandSender)player.getPlayer(), this.getMatchParams(), (Integer)teamIndex)) {
            throw new InvalidOptionException("&cYou don't have permissions to add this team");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JoinOption {
        ARENA("<arena>", false),
        TEAM("<team>", false),
        WANTEDTEAMSIZE("<teamSize>", false);

        public final boolean needsValue;
        final String name;

        private JoinOption(String name, boolean needsValue) {
            this.needsValue = needsValue;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static JoinOption fromName(String str) {
            str = str.toUpperCase();
            try {
                return JoinOption.valueOf(str);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException();
            }
        }

        public static String getValidList() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (JoinOption r : JoinOption.values()) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                String val = "";
                switch (r) {
                    default: 
                }
                sb.append(r.getName()).append(val);
            }
            return sb.toString();
        }
    }
}

