/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.options;

import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Material;

public class SpawnOptions {
    public HashMap<SpawnOption, Object> options = new HashMap();
    public String[] remainingArgs;

    public static SpawnOptions parseSpawnOptions(String[] args) {
        HashMap<SpawnOption, Integer> options = new HashMap<SpawnOption, Integer>();
        ArrayList<String> spawnArgs = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.contains("=")) {
                String[] as = arg.split("=");
                SpawnOption so = null;
                try {
                    so = SpawnOption.valueOf(as[0].toUpperCase());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (so == null || so != SpawnOption.DESPAWNMATERIAL) {
                    Integer time;
                    try {
                        time = Integer.valueOf(as[1]);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("time value not valid. arg='" + arg + "'");
                    }
                    if (as[0].equalsIgnoreCase("fs")) {
                        options.put(SpawnOption.FIRST_SPAWN, time);
                        continue;
                    }
                    if (as[0].equalsIgnoreCase("rs") || as[0].equalsIgnoreCase("rt")) {
                        options.put(SpawnOption.RESPAWN, time);
                        continue;
                    }
                    if (!as[0].equalsIgnoreCase("ds")) continue;
                    options.put(SpawnOption.DESPAWN, time);
                    continue;
                }
                try {
                    Material m = Material.valueOf((String)as[1]);
                    options.put(SpawnOption.DESPAWNMATERIAL, (Integer)m);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Material value not valid. arg='" + arg + "'");
                }
            }
            spawnArgs.add(arg);
        }
        SpawnOptions po = new SpawnOptions();
        po.options = options;
        po.remainingArgs = spawnArgs.toArray(new String[spawnArgs.size()]);
        return po;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpawnOption {
        FIRST_SPAWN,
        RESPAWN,
        DESPAWN,
        DESPAWNMATERIAL;

    }
}

