/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.options;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.plugins.MobArenaInterface;
import mc.alk.arena.objects.ArenaClass;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.ArenaSize;
import mc.alk.arena.objects.CommandLineString;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.PVPState;
import mc.alk.arena.objects.StateGraph;
import mc.alk.arena.objects.StateOption;
import mc.alk.arena.objects.exceptions.InvalidOptionException;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.util.EffectUtil;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.MinMax;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateOptions {
    Map<StateOption, Object> options;

    public StateOptions() {
    }

    public StateOptions(StateOptions o) {
        if (o == null) {
            return;
        }
        if (o.options != null) {
            this.options = new HashMap<StateOption, Object>(o.options);
        }
    }

    public void addOptions(StateOptions optionSet) {
        if (optionSet.options == null) {
            return;
        }
        this.addOptions(optionSet.options);
    }

    public void addOptions(Map<StateOption, Object> options) {
        if (this.options == null) {
            this.options = new HashMap<StateOption, Object>(options);
        } else {
            this.options.putAll(options);
        }
    }

    public void setOptions(Set<String> options) {
        this.options = new HashMap<StateOption, Object>();
        for (String s : options) {
            TransitionOption so = TransitionOption.valueOf(s);
            if (so == null) continue;
            this.options.put(so, null);
        }
    }

    public void setOptions(Map<StateOption, Object> options) {
        this.options = new HashMap<StateOption, Object>(options);
    }

    public List<ItemStack> getGiveItems() {
        Object o = this.options.get(TransitionOption.GIVEITEMS);
        return o == null ? null : (List)o;
    }

    public List<ItemStack> getNeedItems() {
        Object o = this.options.get(TransitionOption.NEEDITEMS);
        return o == null ? null : (List)o;
    }

    public List<ItemStack> getTakeItems() {
        Object o = this.options.get(TransitionOption.TAKEITEMS);
        return o == null ? null : (List)o;
    }

    public List<PotionEffect> getEffects() {
        Object o = this.options.get(TransitionOption.ENCHANTS);
        return o == null ? null : (List)o;
    }

    private boolean hasEffects() {
        return this.getEffects() != null;
    }

    public boolean clearInventory() {
        return this.options.containsKey(TransitionOption.CLEARINVENTORY);
    }

    public boolean needsArmor() {
        return this.options.containsKey(TransitionOption.NEEDARMOR);
    }

    public boolean needsItems() {
        return this.options.containsKey(TransitionOption.NEEDITEMS);
    }

    public boolean hasItems() {
        return this.options.containsKey(TransitionOption.NEEDITEMS) || this.options.containsKey(TransitionOption.GIVEITEMS);
    }

    public boolean hasGiveItems() {
        return this.options.containsKey(TransitionOption.GIVEITEMS);
    }

    public boolean shouldTeleportLobby() {
        return this.options.containsKey(TransitionOption.TELEPORTLOBBY) || this.options.containsKey(TransitionOption.TELEPORTMAINLOBBY);
    }

    public boolean shouldTeleportWaitRoom() {
        return this.options.containsKey(TransitionOption.TELEPORTWAITROOM) || this.options.containsKey(TransitionOption.TELEPORTMAINWAITROOM);
    }

    public boolean shouldTeleportSpectate() {
        return this.options.containsKey(TransitionOption.TELEPORTSPECTATE);
    }

    public boolean shouldTeleportIn() {
        return this.options.containsKey(TransitionOption.TELEPORTIN);
    }

    public boolean teleportsIn() {
        return this.shouldTeleportIn() || this.shouldTeleportWaitRoom();
    }

    public boolean shouldTeleportOut() {
        return this.options.containsKey(TransitionOption.TELEPORTOUT) || this.options.containsKey(TransitionOption.TELEPORTTO);
    }

    public boolean blockBreakOff() {
        return this.options.containsKey(TransitionOption.BLOCKBREAKOFF);
    }

    public boolean blockPlaceOff() {
        return this.options.containsKey(TransitionOption.BLOCKPLACEOFF);
    }

    public Double getHealth() {
        return this.getDouble(TransitionOption.HEALTH);
    }

    public Double getHealthP() {
        return this.getDouble(TransitionOption.HEALTHP);
    }

    public Integer getHunger() {
        return this.getInt(TransitionOption.HUNGER);
    }

    public Integer getMagic() {
        return this.getInt(TransitionOption.MAGIC);
    }

    public Integer getMagicP() {
        return this.getInt(TransitionOption.MAGICP);
    }

    public Double getWithinDistance() {
        return this.getDouble(TransitionOption.WITHINDISTANCE);
    }

    public GameMode getGameMode() {
        return this.getGameMode(TransitionOption.GAMEMODE);
    }

    public List<CommandLineString> getDoCommands() {
        Object o = this.options.get(TransitionOption.DOCOMMANDS);
        return o == null ? null : (List)o;
    }

    public Integer getInt(StateOption option) {
        Object o = this.options.get(option);
        return o == null ? null : (Integer)o;
    }

    public Double getDouble(StateOption option) {
        Object o = this.options.get(option);
        return o == null ? null : (Double)o;
    }

    public Float getFloat(StateOption option) {
        Object o = this.options.get(option);
        return o == null ? null : (Float)o;
    }

    public String getString(StateOption option) {
        Object o = this.options.get(option);
        return o == null ? null : (String)o;
    }

    public GameMode getGameMode(StateOption option) {
        Object o = this.options.get(option);
        return o == null ? null : (GameMode)o;
    }

    public Double getMoney() {
        return this.getDouble(TransitionOption.MONEY);
    }

    public boolean hasMoney() {
        Double d = this.getDouble(TransitionOption.MONEY);
        return d != null && d > 0.0;
    }

    public Float getFlightSpeed() {
        return this.getFloat(TransitionOption.FLIGHTSPEED);
    }

    public Integer getInvulnerable() {
        return this.getInt(TransitionOption.INVULNERABLE);
    }

    public Integer getRespawnTime() {
        return this.getInt(TransitionOption.RESPAWNTIME);
    }

    public Integer getExperience() {
        return this.getInt(TransitionOption.EXPERIENCE);
    }

    public boolean hasExperience() {
        return this.options.containsKey(TransitionOption.EXPERIENCE);
    }

    public String getDisguiseAllAs() {
        return this.getString(TransitionOption.DISGUISEALLAS);
    }

    public Boolean undisguise() {
        return this.options.containsKey(TransitionOption.UNDISGUISE);
    }

    public boolean playerReady(ArenaPlayer p, World w) {
        MinMax mm;
        if (p == null || !p.isOnline() || p.isDead() || p.getPlayer().isSleeping()) {
            return false;
        }
        if (this.needsItems()) {
            List<ItemStack> items = this.getNeedItems();
            PlayerInventory inv = p.getInventory();
            for (ItemStack is : items) {
                if (InventoryUtil.getItemAmountFromInventory((Inventory)inv, is) >= is.getAmount()) continue;
                return false;
            }
        }
        if (MobArenaInterface.hasMobArena() && MobArenaInterface.insideMobArena(p)) {
            return false;
        }
        if (this.options.containsKey(TransitionOption.GAMEMODE)) {
            GameMode gm = this.getGameMode();
            if (p.getPlayer().getGameMode() != gm) {
                return false;
            }
        }
        if (this.options.containsKey(TransitionOption.NOINVENTORY) && InventoryUtil.hasAnyItem(p.getPlayer())) {
            return false;
        }
        if (this.options.containsKey(TransitionOption.SAMEWORLD) && w != null && p.getLocation().getWorld().getUID() != w.getUID()) {
            return false;
        }
        if (this.needsArmor() && !InventoryUtil.hasArmor(p.getPlayer())) {
            return false;
        }
        return !this.options.containsKey(TransitionOption.LEVELRANGE) || (mm = (MinMax)this.options.get(TransitionOption.LEVELRANGE)).contains(p.getLevel());
    }

    public String getNotReadyMsg(String header) {
        StringBuilder sb = new StringBuilder();
        boolean hasSomething = false;
        if (header != null) {
            sb.append(header);
            hasSomething = true;
        }
        if (this.needsItems()) {
            List<ItemStack> items = this.getNeedItems();
            hasSomething = true;
            for (ItemStack is : items) {
                sb.append("&5 - &6").append(is.getAmount()).append(" ").append(is.getData());
            }
        }
        if (this.options.containsKey(TransitionOption.NOINVENTORY)) {
            hasSomething = true;
            sb.append("&5 - &6Clear Inventory");
        }
        if (this.options.containsKey(TransitionOption.GAMEMODE)) {
            hasSomething = true;
            GameMode gm = this.getGameMode();
            sb.append("&5 - &6GameMode=").append(gm.toString());
        }
        if (this.needsArmor()) {
            hasSomething = true;
            sb.append("&5 - &6Armor");
        }
        if (this.options.containsKey(TransitionOption.LEVELRANGE)) {
            MinMax mm = (MinMax)this.options.get(TransitionOption.LEVELRANGE);
            sb.append("&a - lvl=").append(mm.toString());
        }
        return hasSomething ? sb.toString() : null;
    }

    public String getNotReadyMsg(ArenaPlayer p, World w, String headerMsg) {
        MinMax mm;
        StringBuilder sb = new StringBuilder(headerMsg);
        boolean isReady = true;
        if (this.needsItems()) {
            PlayerInventory inv = p.getInventory();
            List<ItemStack> items = this.getNeedItems();
            for (ItemStack is : items) {
                int amountInInventory = InventoryUtil.getItemAmountFromInventory((Inventory)inv, is);
                if (amountInInventory >= is.getAmount()) continue;
                int needed = amountInInventory - is.getAmount();
                sb.append("&5 - &e").append(needed).append(" ").append(is.getType()).append("\n");
                isReady = false;
            }
        }
        if (this.options.containsKey(TransitionOption.GAMEMODE)) {
            GameMode gm = this.getGameMode();
            if (p.getPlayer().getGameMode() != gm) {
                sb.append("&5 -&e a &6You need to be in &c").append(gm).append("&e mode \n");
                isReady = false;
            }
        }
        if (this.options.containsKey(TransitionOption.NOINVENTORY) && InventoryUtil.hasAnyItem(p.getPlayer())) {
            sb.append("&5 -&e a &6Clear Inventory\n");
            isReady = false;
        }
        if (this.options.containsKey(TransitionOption.SAMEWORLD) && w != null && p.getLocation().getWorld().getUID() != w.getUID()) {
            sb.append("&5 -&c Not in same world\n");
            isReady = false;
        }
        if (MobArenaInterface.hasMobArena() && MobArenaInterface.insideMobArena(p)) {
            isReady = false;
            sb.append("&5 - &4You are Inside Mob Arena");
        }
        if (this.needsArmor() && !InventoryUtil.hasArmor(p.getPlayer())) {
            sb.append("&&5 - &6Armor\n");
            isReady = false;
        }
        if (this.options.containsKey(TransitionOption.LEVELRANGE) && !(mm = (MinMax)this.options.get(TransitionOption.LEVELRANGE)).contains(p.getLevel())) {
            sb.append("&a - lvl=").append(mm.toString());
            isReady = false;
        }
        return isReady ? null : sb.toString();
    }

    public String getPrizeMsg(String header) {
        return this.getPrizeMsg(header, null);
    }

    public String getPrizeMsg(String header, Double poolMoney) {
        StringBuilder sb = new StringBuilder();
        boolean hasSomething = false;
        if (header != null) {
            sb.append(header);
            hasSomething = true;
        }
        if (this.hasExperience()) {
            hasSomething = true;
            sb.append("&5 - &2").append(this.getExperience()).append(" experience");
        }
        if (this.hasMoney()) {
            hasSomething = true;
            sb.append("&5 - &6").append(this.getMoney()).append(" ").append(Defaults.MONEY_STR);
        }
        if (poolMoney != null) {
            hasSomething = true;
            sb.append("&5 - &6").append(poolMoney).append(" ").append(Defaults.MONEY_STR);
        }
        if (this.getGiveItems() != null) {
            hasSomething = true;
            List<ItemStack> items = this.getGiveItems();
            InventoryUtil.ArmorLevel lvl = InventoryUtil.hasArmorSet(items);
            if (lvl != null) {
                sb.append("&5 - &a").append(lvl.toString()).append(" ARMOR");
            }
            for (ItemStack is : items) {
                if (lvl != null && InventoryUtil.sameMaterial(lvl, is)) continue;
                String enchanted = !is.getEnchantments().isEmpty() ? " &4Enchanted " : "";
                sb.append("&5 - &a").append(is.getAmount()).append(enchanted).append(is.getType().toString());
            }
        }
        if (this.hasEffects()) {
            hasSomething = true;
            for (PotionEffect ewa : this.getEffects()) {
                if (ewa == null) continue;
                sb.append("&5 - &b").append(EffectUtil.getCommonName(ewa));
            }
        }
        return hasSomething ? sb.toString() : null;
    }

    public PVPState getPVP() {
        if (this.options.containsKey(TransitionOption.PVPON)) {
            return PVPState.ON;
        }
        if (this.options.containsKey(TransitionOption.PVPOFF)) {
            return PVPState.OFF;
        }
        if (this.options.containsKey(TransitionOption.INVINCIBLE)) {
            return PVPState.INVINCIBLE;
        }
        return null;
    }

    public boolean respawn() {
        return this.options.containsKey(TransitionOption.RESPAWN);
    }

    public boolean randomRespawn() {
        return this.options.containsKey(TransitionOption.RANDOMRESPAWN) || this.options.containsKey(TransitionOption.RANDOMSPAWN);
    }

    public boolean deEnchant() {
        return this.options.containsKey(TransitionOption.DEENCHANT);
    }

    public boolean woolTeams() {
        return this.options.containsKey(TransitionOption.WOOLTEAMS) || this.options.containsKey(TransitionOption.ALWAYSWOOLTEAMS);
    }

    public Map<StateOption, Object> getOptions() {
        return this.options;
    }

    public boolean shouldClearRegion() {
        return this.options.containsKey(TransitionOption.WGCLEARREGION);
    }

    public void addOption(StateOption option) throws InvalidOptionException {
        if (option.hasValue()) {
            throw new InvalidOptionException("StateOption needs a value!");
        }
        this.addOption(option, null);
    }

    public void addOption(StateOption option, Object value) throws InvalidOptionException {
        if (option.hasValue() && value == null) {
            throw new InvalidOptionException("StateOption needs a value!");
        }
        if (this.options == null) {
            this.options = new HashMap<StateOption, Object>();
        }
        this.options.put(option, value);
    }

    public boolean hasOption(StateOption op) {
        return this.options != null && this.options.containsKey(op);
    }

    public boolean hasAnyOption(StateOption ... ops) {
        if (this.options == null) {
            return false;
        }
        for (StateOption op : ops) {
            if (!this.options.containsKey(op)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(StateOptions tops) {
        if (tops.options == null && this.options != null) {
            return false;
        }
        if (tops.options == null) {
            return true;
        }
        for (StateOption op : tops.options.keySet()) {
            if (!this.options.containsKey(op)) {
                return false;
            }
            if (!op.hasValue() || this.options.get(op).equals(tops.options.get(op))) continue;
            return false;
        }
        return true;
    }

    public Object removeOption(StateOption op) {
        return this.options != null ? this.options.remove(op) : null;
    }

    public static String getInfo(MatchParams mp, String name) {
        StringBuilder sb = new StringBuilder();
        StateGraph sg = mp.getStateOptions();
        String required = sg.getRequiredString(null);
        String prestart = sg.getGiveString(MatchState.ONPRESTART);
        String start = sg.getGiveString(MatchState.ONSTART);
        String onspawn = sg.getGiveString(MatchState.ONSPAWN);
        String prizes = sg.getGiveString(MatchState.WINNERS);
        boolean rated = mp.isRated();
        String teamSizes = ArenaSize.rangeString(mp.getMinTeamSize(), mp.getMaxTeamSize());
        sb.append("&eThis is ").append(rated ? "a &4Rated" : "an &aUnrated").append("&e ").append(name).append(". ");
        sb.append("&eTeam size=&6").append(teamSizes);
        sb.append("\n&eRequirements to Join:");
        sb.append(required == null ? "&aNone" : required);
        if (prestart != null || start != null || onspawn != null) {
            sb.append("\n&eYou are given:");
            if (prestart != null) {
                sb.append(prestart);
            }
            if (start != null) {
                sb.append(start);
            }
            if (onspawn != null) {
                sb.append(onspawn);
            }
        }
        sb.append("\n&ePrize for &5winning&e a game:");
        sb.append(prizes == null ? "&aNone" : prizes);
        return sb.toString();
    }

    public Map<Integer, ArenaClass> getClasses() {
        Object o = this.options.get(TransitionOption.GIVECLASS);
        return o == null ? null : (Map)o;
    }

    public Map<Integer, String> getDisguises() {
        Object o = this.options.get(TransitionOption.GIVEDISGUISE);
        return o == null ? null : (Map)o;
    }

    public List<String> getAddPerms() {
        Object o = this.options.get(TransitionOption.ADDPERMS);
        return o == null ? null : (List)o;
    }

    public List<String> getRemovePerms() {
        Object o = this.options.get(TransitionOption.ADDPERMS);
        return o == null ? null : (List)o;
    }

    public Location getTeleportToLoc() {
        return this.returnLoc(TransitionOption.TELEPORTTO);
    }

    private Location returnLoc(StateOption to) {
        Object o = this.options.get(to);
        return o == null ? null : (Location)o;
    }

    private ChatColor getColor(StateOption v, StateOptions so) {
        return so != null && so.options.containsKey(v) ? ChatColor.WHITE : ChatColor.GOLD;
    }

    public String getOptionString(StateOptions so) {
        if (this.options == null) {
            return "[SO empty]";
        }
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (Map.Entry<StateOption, Object> entry : this.options.entrySet()) {
            StateOption i;
            if (!first) {
                sb.append("&2, ");
            }
            first = false;
            sb.append(this.getColor(entry.getKey(), so).toString());
            sb.append(entry.getKey());
            Object value = so != null && so.options.containsKey(entry.getKey()) ? so.options.get(entry.getKey()) : entry.getValue();
            if (value == null || (i = entry.getKey()).equals(TransitionOption.GIVECLASS) || i.equals(TransitionOption.ENCHANTS) || i.equals(TransitionOption.GIVEDISGUISE)) continue;
            sb.append(":").append(value);
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        return this.getOptionString(null);
    }
}

