/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.options;

import mc.alk.arena.controllers.ArenaClassController;
import mc.alk.arena.objects.StateOption;
import mc.alk.arena.util.EffectUtil;
import mc.alk.arena.util.MinMax;
import org.bukkit.GameMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TransitionOption implements StateOption
{
    DUELONLY("duelOnly", false, OPTYPE.CONFIG),
    ALWAYSOPEN("alwaysOpen", false, OPTYPE.CONFIG),
    INDIVIDUALWINS("individualWins", false, OPTYPE.CONFIG),
    NEEDARMOR("needArmor", false, OPTYPE.CONFIG),
    NOINVENTORY("noInventory", false, OPTYPE.CONFIG),
    NEEDITEMS("needItems", false, OPTYPE.CONFIG),
    TAKEITEMS("takeItems", false, OPTYPE.CONFIG),
    SAMEWORLD("sameWorld", false, OPTYPE.CONFIG),
    WITHINDISTANCE("withinDistance", true, OPTYPE.CONFIG),
    LEVELRANGE("levelRange", true, OPTYPE.CONFIG),
    STOREALL("storeAll", false, OPTYPE.TRANSITION),
    RESTOREALL("restoreAll", false, OPTYPE.TRANSITION),
    STOREEXPERIENCE("storeExperience", false, OPTYPE.TRANSITION),
    RESTOREEXPERIENCE("restoreExperience", false, OPTYPE.TRANSITION),
    STOREGAMEMODE("storeGamemode", false, OPTYPE.TRANSITION),
    RESTOREGAMEMODE("restoreGamemode", false, OPTYPE.TRANSITION),
    STOREITEMS("storeItems", false, OPTYPE.TRANSITION),
    RESTOREITEMS("restoreItems", false, OPTYPE.TRANSITION),
    STOREENCHANTS("storeEnchants", false, OPTYPE.TRANSITION),
    RESTOREENCHANTS("restoreEnchants", false, OPTYPE.TRANSITION),
    STOREHEALTH("storeHealth", false, OPTYPE.TRANSITION),
    RESTOREHEALTH("restoreHealth", false, OPTYPE.TRANSITION),
    STOREHUNGER("storeHunger", false, OPTYPE.TRANSITION),
    RESTOREHUNGER("restoreHunger", false, OPTYPE.TRANSITION),
    STOREGODMODE("storeGodmode", false, OPTYPE.TRANSITION),
    RESTOREGODMODE("restoreGodmode", false, OPTYPE.TRANSITION),
    STOREFLIGHT("storeFlight", false, OPTYPE.TRANSITION),
    RESTOREFLIGHT("restoreFlight", false, OPTYPE.TRANSITION),
    STOREMAGIC("storeMagic", false, OPTYPE.TRANSITION),
    RESTOREMAGIC("restoreMagic", false, OPTYPE.TRANSITION),
    STOREHEROCLASS("storeHeroClass", false, OPTYPE.TRANSITION),
    RESTOREHEROCLASS("restoreHeroClass", false, OPTYPE.TRANSITION),
    ARMORTEAMS("armorTeams", false, OPTYPE.CONFIG),
    WOOLTEAMS("woolTeams", false, OPTYPE.CONFIG),
    ALWAYSWOOLTEAMS("alwaysWoolTeams", false, OPTYPE.CONFIG),
    ALWAYSTEAMNAMES("alwaysTeamNames", false, OPTYPE.CONFIG),
    NOTEAMNAMECOLOR("noTeamNameColor", false, OPTYPE.CONFIG),
    DROPITEMS("dropItems", false, OPTYPE.CONFIG),
    TELEPORTMAINWAITROOM("teleportMainWaitRoom", false, OPTYPE.TRANSITION),
    TELEPORTWAITROOM("teleportWaitRoom", false, OPTYPE.TRANSITION),
    TELEPORTMAINLOBBY("teleportMainLobby", false, OPTYPE.TRANSITION),
    TELEPORTLOBBY("teleportLobby", false, OPTYPE.TRANSITION),
    TELEPORTSPECTATE("teleportSpectate", false, OPTYPE.TRANSITION),
    TELEPORTCOURTYARD("teleportCourtyard", false, OPTYPE.TRANSITION),
    TELEPORTIN("teleportIn", false, OPTYPE.TRANSITION),
    TELEPORTOUT("teleportOut", false, OPTYPE.TRANSITION),
    TELEPORTTO("teleportTo", true, OPTYPE.TRANSITION),
    NOTELEPORT("noTeleport", false, OPTYPE.TRANSITION),
    NOWORLDCHANGE("noWorldChange", false, OPTYPE.TRANSITION),
    RESPAWNTIME("respawnTime", true, OPTYPE.TRANSITION),
    CLEARINVENTORY("clearInventory", false, OPTYPE.TRANSITION),
    CLEAREXPERIENCE("clearExperience", false, OPTYPE.TRANSITION),
    GIVEITEMS("giveItems", false, OPTYPE.TRANSITION),
    GIVECLASS("giveClass", true, OPTYPE.TRANSITION),
    GIVEDISGUISE("giveDisguise", false, OPTYPE.TRANSITION),
    HEALTH("health", true, OPTYPE.TRANSITION),
    HEALTHP("healthp", true, OPTYPE.TRANSITION),
    HUNGER("hunger", true, OPTYPE.TRANSITION),
    EXPERIENCE("experience", true, OPTYPE.TRANSITION),
    MAGIC("magic", true, OPTYPE.TRANSITION),
    MAGICP("magicp", true, OPTYPE.TRANSITION),
    MONEY("money", true, OPTYPE.TRANSITION),
    EFFECT("effect", true, OPTYPE.TRANSITION),
    POTIONDAMAGEON("potionDamageOn", false, OPTYPE.TRANSITION),
    PVPON("pvpOn", false, OPTYPE.STATE),
    PVPOFF("pvpOff", false, OPTYPE.STATE),
    INVINCIBLE("invincible", false, OPTYPE.STATE),
    INVULNERABLE("invulnerable", true, OPTYPE.TRANSITION),
    BLOCKBREAKOFF("blockBreakOff", false, OPTYPE.STATE),
    BLOCKBREAKON("blockBreakOn", false, OPTYPE.STATE),
    BLOCKPLACEOFF("blockPlaceOff", false, OPTYPE.STATE),
    BLOCKPLACEON("blockPlaceOn", false, OPTYPE.STATE),
    ITEMDROPOFF("itemDropOff", false, OPTYPE.STATE),
    ITEMPICKUPOFF("itemPickupOff", false, OPTYPE.STATE),
    HUNGEROFF("hungerOff", false, OPTYPE.STATE),
    DISGUISEALLAS("disguiseAllAs", true, OPTYPE.TRANSITION),
    UNDISGUISE("undisguise", false, OPTYPE.TRANSITION),
    ENCHANTS("enchants", true, OPTYPE.TRANSITION),
    DEENCHANT("deEnchant", false, OPTYPE.TRANSITION),
    CLASSENCHANTS("classEnchants", false, OPTYPE.TRANSITION),
    ADDPERMS("addPerms", false, OPTYPE.TRANSITION),
    REMOVEPERMS("removePerms", false, OPTYPE.TRANSITION),
    GAMEMODE("gameMode", true, OPTYPE.TRANSITION),
    DOCOMMANDS("doCommands", true, OPTYPE.TRANSITION),
    FLIGHTOFF("flightOff", false, OPTYPE.TRANSITION),
    FLIGHTON("flightOn", false, OPTYPE.TRANSITION),
    FLIGHTSPEED("flightSpeed", true, OPTYPE.TRANSITION),
    NOLEAVE("noLeave", false, OPTYPE.STATE),
    RANDOMSPAWN("randomSpawn", false, OPTYPE.TRANSITION),
    RESPAWN("respawn", false, OPTYPE.TRANSITION),
    RANDOMRESPAWN("randomRespawn", false, OPTYPE.TRANSITION),
    NOEXPERIENCELOSS("noExperienceLoss", false, OPTYPE.TRANSITION),
    KEEPINVENTORY("keepInventory", false, OPTYPE.TRANSITION),
    ALWAYSJOIN("alwaysJoin", false, OPTYPE.CONFIG),
    REJOIN("rejoin", false, OPTYPE.CONFIG),
    RESPAWNWITHCLASS("respawnWithClass", false, OPTYPE.TRANSITION),
    WGCLEARREGION("wgClearRegion", false, OPTYPE.TRANSITION),
    WGRESETREGION("wgResetRegion", false, OPTYPE.TRANSITION),
    WGNOLEAVE("wgNoLeave", false, OPTYPE.STATE),
    WGNOENTER("wgNoEnter", false, OPTYPE.STATE),
    POOLMONEY("poolMoney", true, OPTYPE.TRANSITION);

    final String name;
    final boolean hasValue;
    final OPTYPE opType;

    public boolean isState() {
        return this.opType == OPTYPE.STATE;
    }

    public boolean isTransition() {
        return this.opType == OPTYPE.TRANSITION;
    }

    private TransitionOption(String name, Boolean hasValue, OPTYPE opType) {
        this.name = name;
        this.hasValue = hasValue;
        this.opType = opType;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean hasValue() {
        return this.hasValue;
    }

    public static TransitionOption fromString(String str) {
        str = str.toUpperCase();
        try {
            return TransitionOption.valueOf(str);
        }
        catch (IllegalArgumentException e) {
            if (str.equals("DROPITEMOFF")) {
                return ITEMDROPOFF;
            }
            if (str.equals("RESETREGION")) {
                return WGRESETREGION;
            }
            if (str.equals("DISGUISEALL")) {
                return DISGUISEALLAS;
            }
            if (str.equals("COMMANDS") || str.equals("COMMAND")) {
                return DOCOMMANDS;
            }
            if (str.equals("CLASS")) {
                return GIVECLASS;
            }
            if (str.equals("INVULNERABILITY") || str.equals("INV")) {
                return INVULNERABLE;
            }
            if (str.equals("STOREPOTIONEFFECTS")) {
                return STOREENCHANTS;
            }
            if (str.equals("RESTOREPOTIONEFFECTS")) {
                return RESTOREENCHANTS;
            }
            throw new IllegalArgumentException("The stage option " + str + " does not exist");
        }
    }

    public Object parseValue(String value) throws Exception {
        switch (this) {
            case HEALTHP: 
            case HEALTH: 
            case POOLMONEY: 
            case WITHINDISTANCE: 
            case MONEY: {
                return Double.valueOf(value);
            }
            case LEVELRANGE: {
                return MinMax.valueOf(value);
            }
            case DISGUISEALLAS: {
                return value;
            }
            case MAGIC: 
            case MAGICP: 
            case HUNGER: 
            case EXPERIENCE: 
            case INVULNERABLE: {
                return Integer.valueOf(value);
            }
            case FLIGHTSPEED: {
                return Float.valueOf(value);
            }
            case ENCHANTS: {
                return EffectUtil.parseArg(value, 0, 120);
            }
            case DOCOMMANDS: {
                return value;
            }
            case GIVECLASS: {
                return ArenaClassController.getClass(value);
            }
            case GAMEMODE: {
                GameMode gm;
                try {
                    gm = GameMode.getByValue((int)Integer.valueOf(value));
                }
                catch (Throwable e) {
                    gm = GameMode.valueOf((String)value.toUpperCase());
                }
                return gm;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OPTYPE {
        STATE,
        TRANSITION,
        CONFIG;

    }
}

