/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.regions;

import mc.alk.arena.util.SerializerUtil;
import org.bukkit.Location;
import org.bukkit.World;

public class BoundingBox {
    protected Location lower;
    protected Location upper;

    public BoundingBox() {
    }

    public BoundingBox(Location l, Location l2) {
        this.createBoundingBox(l, l2);
    }

    private void createBoundingBox(Location l1, Location l2) {
        this.lower = new Location(l1.getWorld(), (double)Math.min(l1.getBlockX(), l2.getBlockX()), (double)Math.min(l1.getBlockY(), l2.getBlockY()), (double)Math.min(l1.getBlockZ(), l2.getBlockZ()));
        this.upper = new Location(l1.getWorld(), (double)Math.max(l1.getBlockX(), l2.getBlockX()), (double)Math.max(l1.getBlockY(), l2.getBlockY()), (double)Math.max(l1.getBlockZ(), l2.getBlockZ()));
    }

    public boolean contains(Location l) {
        return l.getWorld().getName().equals(this.lower.getWorld().getName()) && l.getBlockX() >= this.lower.getBlockX() && l.getBlockX() <= this.upper.getBlockX() && l.getBlockY() >= this.lower.getBlockY() && l.getBlockY() <= this.upper.getBlockY() && l.getBlockZ() >= this.lower.getBlockZ() && l.getBlockZ() <= this.upper.getBlockZ();
    }

    public Location getCorner1() {
        return this.lower;
    }

    public Location getCorner2() {
        return this.upper;
    }

    public Location getLowerCorner() {
        return this.lower;
    }

    public Location getUpperCorner() {
        return this.upper;
    }

    public World getWorld() {
        return this.lower.getWorld();
    }

    public String toString() {
        return "[BB " + SerializerUtil.getLocString(this.lower) + ":" + SerializerUtil.getLocString(this.upper) + "]";
    }
}

