/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.regions;

import java.util.Map;
import mc.alk.arena.controllers.plugins.WorldGuardController;
import mc.alk.arena.objects.regions.ArenaRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldGuardRegion
implements ArenaRegion {
    protected String regionName;
    protected String regionWorld;

    public WorldGuardRegion() {
    }

    public WorldGuardRegion(String regionWorld, String regionName) {
        this.regionWorld = regionWorld;
        this.regionName = regionName;
    }

    @Override
    public Object yamlToObject(Map<String, Object> map, String value) {
        if (value == null) {
            return null;
        }
        String[] split = value.split(",");
        this.regionWorld = split[0];
        this.regionName = split[1];
        return new WorldGuardRegion(this.regionWorld, this.regionName);
    }

    @Override
    public Object objectToYaml() {
        return this.regionWorld + "," + this.regionName;
    }

    @Override
    public boolean valid() {
        return this.regionName != null && this.regionWorld != null && WorldGuardController.hasWorldGuard() && WorldGuardController.hasRegion(this.regionWorld, this.regionName);
    }

    @Override
    public String getID() {
        return this.regionName;
    }

    public void setID(String regionName) {
        this.regionName = regionName;
    }

    public String getRegionWorld() {
        return this.regionWorld;
    }

    public void setRegionWorld(String regionWorld) {
        this.regionWorld = regionWorld;
    }

    @Override
    public String getWorldName() {
        return this.regionWorld;
    }
}

