/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.scoreboard;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import mc.alk.arena.Defaults;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchResult;
import mc.alk.arena.objects.scoreboard.ArenaDisplaySlot;
import mc.alk.arena.objects.scoreboard.ArenaScoreboard;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.victoryconditions.interfaces.ScoreTracker;
import mc.alk.arena.util.ScoreMap;
import mc.alk.scoreboardapi.api.SAPIFactory;
import mc.alk.scoreboardapi.api.SEntry;
import mc.alk.scoreboardapi.api.SObjective;
import mc.alk.scoreboardapi.api.SScoreboard;
import mc.alk.scoreboardapi.api.STeam;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;
import mc.alk.scoreboardapi.scoreboard.bukkit.BObjective;
import org.bukkit.OfflinePlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArenaObjective
implements SObjective,
ScoreTracker {
    protected final ScoreMap<ArenaTeam> teamPoints = new ScoreMap();
    protected final ScoreMap<ArenaPlayer> playerPoints = new ScoreMap();
    protected final SObjective o;

    public ArenaObjective(String name, String criteria) {
        this(name, criteria, name, SAPIDisplaySlot.SIDEBAR, 50);
    }

    public ArenaObjective(String name, String criteria, int priority) {
        this(name, criteria, name, SAPIDisplaySlot.SIDEBAR, priority);
    }

    public ArenaObjective(String name, String criteria, String displayName, SAPIDisplaySlot slot) {
        this(name, criteria, displayName, slot, 50);
    }

    public ArenaObjective(String name, String criteria, String displayName, SAPIDisplaySlot slot, int priority) {
        this(name, criteria, displayName, slot, priority, 0);
    }

    public ArenaObjective(String id, String criteria, String displayName, SAPIDisplaySlot slot, int priority, int points) {
        SObjective sObjective = this.o = Defaults.TESTSERVER || !Defaults.USE_SCOREBOARD ? SAPIFactory.createSAPIObjective(id, displayName, criteria, slot, priority) : SAPIFactory.createObjective(id, displayName, criteria, slot, priority);
        if (displayName != null) {
            this.setDisplayName(displayName);
        }
    }

    public void setDisplaySlot(ArenaDisplaySlot sidebar) {
        this.o.setDisplaySlot(sidebar.toSAPI());
    }

    public Integer getPoints(ArenaTeam t) {
        return (Integer)this.teamPoints.get(t);
    }

    public void setAllPoints(int points) {
        for (ArenaTeam t : this.teamPoints.keySet()) {
            this.setPoints(t, points);
        }
        for (ArenaPlayer p : this.playerPoints.keySet()) {
            this.setPoints(p, points);
        }
    }

    public void setAllPoints(Match match, int points) {
        for (ArenaTeam t : match.getTeams()) {
            if (this.o.isDisplayTeams()) {
                this.setPoints(t, points);
            }
            if (!this.o.isDisplayPlayers()) continue;
            for (ArenaPlayer p : t.getPlayers()) {
                this.setPoints(p, points);
            }
        }
    }

    public Integer addPoints(ArenaTeam team, int points) {
        int oldPoints = this.teamPoints.getPoints(team);
        this.setPoints(team, points + oldPoints);
        return points + oldPoints;
    }

    public Integer addPoints(ArenaPlayer ap, int points) {
        int oldPoints = this.playerPoints.getPoints(ap);
        this.setPoints(ap, points + oldPoints);
        return points + oldPoints;
    }

    public Integer subtractPoints(ArenaTeam team, int points) {
        int oldPoints = this.teamPoints.getPoints(team);
        this.setPoints(team, oldPoints - points);
        return oldPoints - points;
    }

    public int subtractPoints(ArenaPlayer ap, int points) {
        int oldPoints = this.playerPoints.getPoints(ap);
        this.setPoints(ap, oldPoints - points);
        return oldPoints - points;
    }

    public List<ArenaTeam> getTeamLeaders() {
        return this.teamPoints.getLeaders();
    }

    public TreeMap<Integer, Collection<ArenaTeam>> getTeamRanks() {
        return this.teamPoints.getRankings();
    }

    public List<ArenaPlayer> getPlayerLeaders() {
        return this.playerPoints.getLeaders();
    }

    public TreeMap<Integer, Collection<ArenaPlayer>> getPlayerRanks() {
        return this.playerPoints.getRankings();
    }

    public MatchResult getMatchResult(Match match) {
        TreeMap<Integer, Collection<ArenaTeam>> ranks = this.getTeamRanks();
        HashSet<ArenaTeam> unfoundTeams = new HashSet<ArenaTeam>(match.getAliveTeams());
        for (Collection<ArenaTeam> t : ranks.values()) {
            unfoundTeams.removeAll(t);
        }
        Collection<ArenaTeam> zeroes = ranks.get(0);
        if (zeroes != null) {
            zeroes.addAll(unfoundTeams);
        } else {
            ranks.put(0, unfoundTeams);
        }
        MatchResult result = new MatchResult();
        if (ranks == null || ranks.isEmpty()) {
            return result;
        }
        if (ranks.size() == 1) {
            for (Collection<ArenaTeam> col : ranks.values()) {
                result.setDrawers(col);
            }
        } else {
            boolean first = true;
            for (Integer key : ranks.keySet()) {
                Collection<ArenaTeam> col = ranks.get(key);
                if (first) {
                    result.setVictors(col);
                    first = false;
                    continue;
                }
                result.addLosers(col);
            }
        }
        result.setRanking(ranks);
        return result;
    }

    public Integer setPoints(ArenaPlayer p, int points) {
        this.o.setPoints(p.getName(), points);
        return this.playerPoints.setPoints(p, points);
    }

    public Integer setPoints(ArenaTeam t, int points) {
        this.o.setPoints(t.getIDString(), points);
        return this.teamPoints.setPoints(t, points);
    }

    @Override
    public List<ArenaTeam> getLeaders() {
        return this.getTeamLeaders();
    }

    @Override
    public TreeMap<?, Collection<ArenaTeam>> getRanks() {
        return this.getTeamRanks();
    }

    @Override
    public void setScoreBoard(ArenaScoreboard scoreboard) {
        scoreboard.setObjectiveScoreboard(this);
    }

    @Override
    public void setDisplayName(String displayName) {
        this.o.setDisplayName(displayName);
    }

    @Override
    public String getDisplayNameSuffix() {
        return this.o.getDisplayNameSuffix();
    }

    @Override
    public void setDisplayNameSuffix(String suffix) {
        this.o.setDisplayNameSuffix(suffix);
    }

    @Override
    public String getDisplayNamePrefix() {
        return this.o.getDisplayNamePrefix();
    }

    @Override
    public void setDisplayNamePrefix(String prefix) {
        this.o.setDisplayNamePrefix(prefix);
    }

    @Override
    public boolean setPoints(SEntry entry, int points) {
        return this.o.setPoints(entry, points);
    }

    @Override
    public SAPIDisplaySlot getDisplaySlot() {
        return this.o.getDisplaySlot();
    }

    @Override
    public int getPriority() {
        return this.o.getPriority();
    }

    @Override
    public void setDisplaySlot(SAPIDisplaySlot slot) {
        this.o.setDisplaySlot(slot);
    }

    @Override
    public String getID() {
        return this.o.getID();
    }

    @Override
    public String getDisplayName() {
        return this.o.getDisplayName();
    }

    @Override
    public String getBaseDisplayName() {
        return this.o.getBaseDisplayName();
    }

    @Override
    public boolean setTeamPoints(STeam t, int points) {
        return this.o.setTeamPoints(t, points);
    }

    @Override
    public boolean setPoints(String id, int points) {
        return this.o.setPoints(id, points);
    }

    @Override
    public SEntry addEntry(String id, int points) {
        return this.o.addEntry(id, points);
    }

    @Override
    public void setDisplayPlayers(boolean b) {
        this.o.setDisplayPlayers(b);
    }

    @Override
    public void setDisplayTeams(boolean display) {
        this.o.setDisplayTeams(display);
    }

    @Override
    public void setScoreBoard(SScoreboard scoreboard) {
        this.o.setScoreBoard(scoreboard);
        scoreboard.registerNewObjective(this);
    }

    @Override
    public int getPoints(String id) {
        return this.o.getPoints(id);
    }

    @Override
    public int getPoints(SEntry e) {
        return this.o.getPoints(e);
    }

    public String toString() {
        return this.o.toString();
    }

    @Override
    public boolean isDisplayTeams() {
        return this.o.isDisplayTeams();
    }

    @Override
    public boolean isDisplayPlayers() {
        return this.o.isDisplayPlayers();
    }

    @Override
    public SScoreboard getScoreboard() {
        return this.o.getScoreboard();
    }

    @Override
    public SEntry addEntry(OfflinePlayer player, int points) {
        return this.o.addEntry(player, points);
    }

    @Override
    public SEntry removeEntry(OfflinePlayer player) {
        return this.o.removeEntry(player);
    }

    @Override
    public SEntry removeEntry(String id) {
        return this.o.removeEntry(id);
    }

    @Override
    public boolean addEntry(SEntry entry, int defaultPoints) {
        return this.o.addEntry(entry, defaultPoints);
    }

    @Override
    public SEntry removeEntry(SEntry entry) {
        return this.o.removeEntry(entry);
    }

    @Override
    public boolean contains(SEntry e) {
        return this.o.contains(e);
    }

    @Override
    public STeam addTeam(String id, int points) {
        return this.o.addTeam(id, points);
    }

    @Override
    public boolean addTeam(STeam entry, int points) {
        return this.o.addTeam(entry, points);
    }

    public void setDisplayName(String displayNamePrefix, String displayName, String displayNameSuffix, STeam team) {
        if (this.o instanceof BObjective) {
            ((BObjective)this.o).setDisplayName(displayNamePrefix, displayName, displayNameSuffix, team);
        }
    }
}

