/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.scoreboard.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import mc.alk.arena.Defaults;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.StateOption;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.objects.scoreboard.ArenaObjective;
import mc.alk.arena.objects.scoreboard.ArenaScoreboard;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.Log;
import mc.alk.scoreboardapi.api.SObjective;
import mc.alk.scoreboardapi.api.SScoreboard;
import mc.alk.scoreboardapi.api.STeam;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;
import mc.alk.scoreboardapi.scoreboard.bukkit.BScoreboard;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArenaBukkitScoreboard
extends ArenaScoreboard {
    final HashMap<ArenaTeam, STeam> teams = new HashMap();
    final BScoreboard bboard;
    final boolean colorPlayerNames;

    public ArenaBukkitScoreboard(String scoreboardName) {
        super(scoreboardName);
        this.colorPlayerNames = Defaults.USE_COLORNAMES;
        this.bboard = (BScoreboard)this.board;
    }

    public ArenaBukkitScoreboard(String scoreboardName, MatchParams params) {
        super(scoreboardName);
        this.colorPlayerNames = Defaults.USE_COLORNAMES && !params.getStateGraph().hasAnyOption((StateOption)TransitionOption.NOTEAMNAMECOLOR);
        this.bboard = (BScoreboard)this.board;
    }

    @Deprecated
    public ArenaBukkitScoreboard(Match match, MatchParams params) {
        this(match.getName(), params);
    }

    @Override
    public ArenaObjective createObjective(String id, String criteria, String displayName) {
        return this.createObjective(id, criteria, displayName, SAPIDisplaySlot.SIDEBAR);
    }

    @Override
    public ArenaObjective createObjective(String id, String criteria, String displayName, SAPIDisplaySlot slot) {
        return this.createObjective(id, criteria, displayName, slot, 50);
    }

    @Override
    public ArenaObjective createObjective(String id, String criteria, String displayName, SAPIDisplaySlot slot, int priority) {
        ArenaObjective o = new ArenaObjective(id, criteria, displayName, slot, priority);
        this.addObjective(o);
        return o;
    }

    @Override
    public void addObjective(ArenaObjective objective) {
        this.bboard.registerNewObjective(objective);
        this.bboard.addAllEntries(objective);
    }

    @Override
    public STeam removeTeam(ArenaTeam team) {
        STeam t = this.teams.remove(team);
        if (t != null) {
            super.removeEntry(t);
            for (SObjective o : this.getObjectives()) {
                o.removeEntry(t);
                for (OfflinePlayer offlinePlayer : t.getPlayers()) {
                    o.removeEntry(offlinePlayer);
                }
            }
        }
        return t;
    }

    @Override
    public STeam addTeam(ArenaTeam team) {
        STeam t = this.teams.get(team);
        if (t != null) {
            return t;
        }
        t = this.createTeamEntry(team.getIDString(), team.getScoreboardDisplayName());
        Set<Player> bukkitPlayers = team.getBukkitPlayers();
        t.addPlayers(bukkitPlayers);
        for (Player p : bukkitPlayers) {
            this.bboard.setScoreboard(p);
        }
        if (this.colorPlayerNames) {
            t.setPrefix(team.getTeamChatColor() + "");
        }
        this.teams.put(team, t);
        for (SObjective o : this.getObjectives()) {
            o.addTeam(t, 0);
            if (!o.isDisplayPlayers()) continue;
            for (ArenaPlayer player : team.getPlayers()) {
                o.addEntry(player.getName(), 0);
            }
        }
        return t;
    }

    @Override
    public STeam addedToTeam(ArenaTeam team, ArenaPlayer player) {
        STeam t = this.teams.get(team);
        if (t == null) {
            t = this.addTeam(team);
        }
        this.addedToTeam(t, player);
        return t;
    }

    @Override
    public void addedToTeam(STeam team, ArenaPlayer player) {
        team.addPlayer((OfflinePlayer)player.getPlayer());
        this.bboard.setScoreboard(player.getPlayer());
    }

    @Override
    public STeam removedFromTeam(ArenaTeam team, ArenaPlayer player) {
        STeam t = this.teams.get(team);
        if (t == null) {
            Log.err(this.teams.size() + "  Removing from a team that doesn't exist player=" + player.getName() + "   team=" + team + "  " + team.getId());
            return null;
        }
        this.removedFromTeam(t, player);
        return t;
    }

    @Override
    public void removedFromTeam(STeam team, ArenaPlayer player) {
        team.removePlayer((OfflinePlayer)player.getPlayer());
        this.bboard.removeScoreboard(player.getPlayer());
    }

    @Override
    public void leaving(ArenaTeam team, ArenaPlayer player) {
        this.removedFromTeam(team, player);
    }

    @Override
    public void setDead(ArenaTeam team, ArenaPlayer player) {
        this.removedFromTeam(team, player);
    }

    @Override
    public List<STeam> getTeams() {
        return new ArrayList<STeam>(this.teams.values());
    }

    public String toString() {
        return this.getPrintString();
    }

    @Override
    public SScoreboard getBScoreboard() {
        return this.bboard;
    }
}

