/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.spawns;

import java.util.Collection;
import mc.alk.arena.objects.spawns.BlockSpawn;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChestSpawn
extends BlockSpawn {
    ItemStack[] items;

    public ChestSpawn(Block block, boolean setItems) {
        super(block, setItems);
        if (setItems && block.getState() instanceof Chest) {
            Chest chest = (Chest)block.getState();
            ItemStack[] contents = chest.getInventory().getContents();
            this.items = new ItemStack[contents.length];
            for (int i = 0; i < contents.length; ++i) {
                this.items[i] = contents[i] != null ? contents[i].clone() : null;
            }
        }
    }

    public void setItems(Collection<ItemStack> items) {
        this.items = items.toArray(new ItemStack[items.size()]);
    }

    @Override
    public void spawn() {
        super.spawn();
        Chest chest = (Chest)this.loc.getBlock().getState();
        chest.getInventory().clear();
        chest.getInventory().setContents(this.items);
        chest.update(true);
    }

    @Override
    public void despawn() {
        Block b = this.getLocation().getBlock();
        if (b.getState() instanceof Chest) {
            Chest chest = (Chest)this.loc.getBlock().getState();
            chest.getInventory().clear();
            chest.update(true);
        }
        b.setType(Material.AIR);
    }

    @Override
    public String toString() {
        return "[ChestSpawn " + this.mat.name() + "]";
    }

    public boolean isDoubleChest() {
        Block b = this.loc.getBlock();
        return ChestSpawn.isChest(b.getRelative(BlockFace.NORTH)) || ChestSpawn.isChest(b.getRelative(BlockFace.SOUTH)) || ChestSpawn.isChest(b.getRelative(BlockFace.EAST)) || ChestSpawn.isChest(b.getRelative(BlockFace.WEST));
    }

    public static boolean isChest(Block block) {
        return block.getState() instanceof Chest;
    }

    public ItemStack[] getItems() {
        return this.items;
    }
}

