/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.spawns;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.spawns.SpawnInstance;
import mc.alk.arena.util.EntityUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.TeamUtil;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;

public class EntitySpawn
extends SpawnInstance {
    private final EntityType et;
    final List<LivingEntity> uids = new ArrayList<LivingEntity>();
    int number = 1;
    ArenaPlayer owner;
    static Method spawnEntityMethod;

    public EntitySpawn(EntityType et) {
        super(null);
        this.et = et;
    }

    public EntitySpawn(EntityType et, int number) {
        super(null);
        this.et = et;
        this.number = number;
    }

    public EntitySpawn(EntitySpawn entitySpawn) {
        super(null);
        this.et = entitySpawn.et;
        this.number = entitySpawn.number;
    }

    public void spawn() {
        if (spawnEntityMethod == null) {
            return;
        }
        for (LivingEntity id : this.uids) {
            if (id.isDead()) continue;
            return;
        }
        this.uids.clear();
        for (int i = 0; i < this.number; ++i) {
            try {
                LivingEntity le = (LivingEntity)spawnEntityMethod.invoke((Object)this.loc.getWorld(), this.loc, this.et);
                if (le instanceof Wolf && this.owner != null && this.owner.getTeam() != null) {
                    EntityUtil.setCollarColor((Wolf)le, TeamUtil.getDyeColor(this.owner.getTeam().getIndex()));
                }
                this.uids.add(le);
                continue;
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
    }

    public void despawn() {
        for (LivingEntity id : this.uids) {
            if (id.isDead()) continue;
            id.remove();
        }
        this.uids.clear();
    }

    public void setOwner(ArenaPlayer player) {
        this.owner = player;
        this.setOwner((AnimalTamer)player.getPlayer());
    }

    public void setOwner(AnimalTamer tamer) {
        for (LivingEntity le : this.uids) {
            if (le.isDead()) continue;
            if (le instanceof Tameable) {
                ((Tameable)le).setTamed(true);
                ((Tameable)le).setOwner(tamer);
            }
            if (!(le instanceof Wolf)) continue;
            ((Wolf)le).setSitting(false);
            if (this.owner == null || this.owner.getTeam() == null) continue;
            EntityUtil.setCollarColor((Wolf)le, TeamUtil.getDyeColor(this.owner.getTeam().getIndex()));
        }
    }

    public String getEntityString() {
        return this.et.getName();
    }

    public int getNumber() {
        return this.number;
    }

    public String toString() {
        return "[ES " + this.et + ":" + this.number + "]";
    }

    public void setTarget(LivingEntity entity) {
        for (LivingEntity id : this.uids) {
            if (id.isDead() || !(id instanceof Creature)) continue;
            ((Creature)id).setTarget(entity);
        }
    }

    static {
        try {
            spawnEntityMethod = World.class.getMethod("spawnEntity", new Class[0]);
        }
        catch (Exception e) {
            try {
                spawnEntityMethod = World.class.getMethod("spawnCreature", Location.class, EntityType.class);
            }
            catch (NoSuchMethodException e1) {
                Log.printStackTrace(e1);
            }
        }
    }
}

