/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.spawns;

import java.util.ArrayList;
import java.util.List;
import mc.alk.arena.objects.spawns.SpawnInstance;
import mc.alk.arena.objects.spawns.Spawnable;
import org.bukkit.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpawnGroup
extends SpawnInstance
implements Spawnable {
    String name;
    List<SpawnInstance> spawns = new ArrayList<SpawnInstance>();

    public SpawnGroup(String name) {
        super(null);
        this.name = name;
    }

    public SpawnGroup(SpawnInstance spawn) {
        super(null);
        this.spawns.add(spawn);
    }

    public void addSpawns(List<SpawnInstance> _spawns) {
        this.spawns.addAll(_spawns);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void despawn() {
        for (Spawnable spawnable : this.spawns) {
            spawnable.despawn();
        }
    }

    @Override
    public void spawn() {
        for (Spawnable spawnable : this.spawns) {
            spawnable.spawn();
        }
    }

    @Override
    public void setLocation(Location l) {
        this.loc = l;
        for (SpawnInstance spawn : this.spawns) {
            spawn.setLocation(l);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[SpawnGroup " + this.name + " ");
        boolean first = true;
        for (Spawnable spawnable : this.spawns) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(spawnable.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

