/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.spawns;

import mc.alk.arena.BattleArena;
import mc.alk.arena.objects.spawns.SpawnInstance;
import mc.alk.arena.objects.spawns.Spawnable;
import mc.alk.arena.util.SerializerUtil;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TimedSpawn
implements Spawnable {
    static int count = 0;
    SpawnInstance sg;
    final int id = count++;
    Long firstSpawnTime;
    Long respawnInterval;
    Long timeToDespawn;
    BukkitTask despawnTimer;

    public TimedSpawn(long firstSpawnTime, long respawnTime, long timeToDespawn, SpawnInstance sg) {
        this.firstSpawnTime = firstSpawnTime;
        this.sg = sg;
        this.respawnInterval = respawnTime;
        this.timeToDespawn = timeToDespawn;
    }

    public Long getRespawnTime() {
        return this.respawnInterval;
    }

    public void setRespawnTime(Long timeToNext) {
        this.respawnInterval = timeToNext;
    }

    public Long getFirstSpawnTime() {
        return this.firstSpawnTime;
    }

    public void setFirstSpawnTime(Long timeToStart) {
        this.firstSpawnTime = timeToStart;
    }

    public int getId() {
        return this.id;
    }

    public SpawnInstance getSpawn() {
        return this.sg;
    }

    public Long getTimeToDespawn() {
        return this.timeToDespawn;
    }

    public void despawn() {
        this.sg.despawn();
    }

    public void spawn() {
        this.sg.spawn();
        if (this.timeToDespawn > 0L) {
            if (this.despawnTimer != null) {
                Bukkit.getScheduler().cancelTask(this.despawnTimer.getTaskId());
            }
            this.despawnTimer = new BukkitRunnable(){

                public void run() {
                    TimedSpawn.this.despawn();
                }
            }.runTaskLater((Plugin)BattleArena.getSelf(), this.timeToDespawn * 20L);
        }
    }

    public String toString() {
        return "[" + this.id + " loc=" + SerializerUtil.getBlockLocString(this.sg.getLocation()) + " s=" + this.sg + " fs=" + this.firstSpawnTime + " rs=" + this.respawnInterval + " ds=" + this.timeToDespawn + "]";
    }

    public String getDisplayName() {
        return "&e[" + this.sg + " loc=&6" + SerializerUtil.getBlockLocString(this.sg.getLocation()) + "&e fs=&5" + this.firstSpawnTime + "&6 rs=" + this.respawnInterval + "&7 ds=" + this.timeToDespawn + "]";
    }
}

