/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.teams;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mc.alk.arena.controllers.plugins.TrackerController;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.scoreboard.ArenaObjective;
import mc.alk.arena.objects.stats.ArenaStat;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.teams.CompositeTeam;
import mc.alk.arena.util.MessageUtil;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTeam
implements ArenaTeam {
    static int count = 0;
    final int id = count++;
    protected final Set<ArenaPlayer> players = new HashSet<ArenaPlayer>();
    protected final Set<ArenaPlayer> deadplayers = new HashSet<ArenaPlayer>();
    protected final Set<ArenaPlayer> leftplayers = new HashSet<ArenaPlayer>();
    protected boolean nameManuallySet = false;
    protected boolean nameChanged = true;
    protected String name = null;
    protected String displayName = null;
    protected String scoreboardDisplayName = null;
    final HashMap<ArenaPlayer, Integer> kills = new HashMap();
    final HashMap<ArenaPlayer, Integer> deaths = new HashMap();
    protected boolean isPickupTeam = false;
    int minPlayers = -1;
    int maxPlayers = -1;
    ArenaObjective objective;
    protected ChatColor color = null;
    protected ItemStack headItem = null;
    ArenaStat stat;
    MatchParams params;
    int index = -1;
    String strID = null;

    public AbstractTeam() {
        this.init();
    }

    protected AbstractTeam(ArenaPlayer p) {
        this.init();
        this.players.add(p);
        this.nameChanged = true;
    }

    protected AbstractTeam(Collection<ArenaPlayer> teammates) {
        this.init();
        this.players.addAll(teammates);
        this.nameChanged = true;
    }

    protected AbstractTeam(ArenaPlayer p, Collection<ArenaPlayer> teammates) {
        this.init();
        this.players.add(p);
        this.players.addAll(teammates);
        this.nameChanged = true;
    }

    @Override
    public void init() {
        this.reset();
    }

    @Override
    public void reset() {
        this.players.clear();
        this.deaths.clear();
        this.kills.clear();
        this.deadplayers.clear();
        this.nameChanged = true;
    }

    protected String createName() {
        if (this.nameManuallySet || !this.nameChanged) {
            return this.name;
        }
        ArrayList<String> list = new ArrayList<String>(this.players.size());
        for (ArenaPlayer p : this.players) {
            list.add(p.getName());
        }
        for (ArenaPlayer p : this.leftplayers) {
            list.add(p.getName());
        }
        if (list.size() > 1) {
            Collections.sort(list);
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : list) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(s);
            first = false;
        }
        this.name = sb.toString();
        this.nameChanged = false;
        return this.name;
    }

    @Override
    public Set<ArenaPlayer> getPlayers() {
        return this.players;
    }

    @Override
    public Set<Player> getBukkitPlayers() {
        HashSet<Player> ps = new HashSet<Player>();
        for (ArenaPlayer ap : this.players) {
            Player p = ap.getPlayer();
            if (p == null) continue;
            ps.add(p);
        }
        return ps;
    }

    @Override
    public Set<ArenaPlayer> getDeadPlayers() {
        return this.deadplayers;
    }

    @Override
    public Set<ArenaPlayer> getLeftPlayers() {
        return this.leftplayers;
    }

    @Override
    public Set<ArenaPlayer> getLivingPlayers() {
        HashSet<ArenaPlayer> living = new HashSet<ArenaPlayer>();
        for (ArenaPlayer p : this.players) {
            if (!this.hasAliveMember(p)) continue;
            living.add(p);
        }
        return living;
    }

    @Override
    public boolean wouldBeDeadWithout(ArenaPlayer p) {
        Set<ArenaPlayer> living = this.getLivingPlayers();
        living.remove(p);
        int offline = 0;
        for (ArenaPlayer ap : living) {
            if (ap.isOnline()) continue;
            ++offline;
        }
        return living.isEmpty() || living.size() <= offline;
    }

    @Override
    public boolean hasMember(ArenaPlayer p) {
        return this.players.contains(p);
    }

    @Override
    public boolean hasLeft(ArenaPlayer p) {
        return this.leftplayers.contains(p);
    }

    @Override
    public boolean hasAliveMember(ArenaPlayer p) {
        return this.hasMember(p) && !this.deadplayers.contains(p);
    }

    @Override
    public boolean isPickupTeam() {
        return this.isPickupTeam;
    }

    @Override
    public void setPickupTeam(boolean isPickupTeam) {
        this.isPickupTeam = isPickupTeam;
    }

    public void setHealth(int health) {
        for (ArenaPlayer p : this.players) {
            p.setHealth(health);
        }
    }

    public void setHunger(int hunger) {
        for (ArenaPlayer p : this.players) {
            p.setFoodLevel(hunger);
        }
    }

    @Override
    public String getName() {
        return this.createName();
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.nameManuallySet = true;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setAlive() {
        this.deadplayers.clear();
    }

    @Override
    public void setAlive(ArenaPlayer player) {
        this.deadplayers.remove(player);
    }

    @Override
    public boolean isDead() {
        if (this.deadplayers.size() >= this.players.size()) {
            return true;
        }
        Set<ArenaPlayer> living = this.getLivingPlayers();
        if (living.isEmpty()) {
            return true;
        }
        int offline = 0;
        for (ArenaPlayer ap : living) {
            if (ap.isOnline()) continue;
            ++offline;
        }
        return living.size() <= offline;
    }

    @Override
    public boolean isReady() {
        for (ArenaPlayer ap : this.getLivingPlayers()) {
            if (ap.isReady()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.players.size();
    }

    @Override
    public int addDeath(ArenaPlayer teamMemberWhoDied) {
        Integer d = this.deaths.get(teamMemberWhoDied);
        if (d == null) {
            d = 0;
        }
        d = d + 1;
        this.deaths.put(teamMemberWhoDied, d);
        return d;
    }

    @Override
    public int addKill(ArenaPlayer teamMemberWhoKilled) {
        Integer d = this.kills.get(teamMemberWhoKilled);
        if (d == null) {
            d = 0;
        }
        d = d + 1;
        this.kills.put(teamMemberWhoKilled, d);
        if (this.objective != null) {
            this.objective.setPoints(teamMemberWhoKilled, (int)d);
            this.objective.setPoints(this, (int)d);
        }
        return d;
    }

    @Override
    public int getNKills() {
        int nkills = 0;
        for (Integer i : this.kills.values()) {
            nkills += i.intValue();
        }
        return nkills;
    }

    @Override
    public int getNDeaths() {
        int nkills = 0;
        for (Integer i : this.deaths.values()) {
            nkills += i.intValue();
        }
        return nkills;
    }

    @Override
    public Integer getNDeaths(ArenaPlayer p) {
        return this.deaths.get(p);
    }

    @Override
    public Integer getNKills(ArenaPlayer p) {
        return this.kills.get(p);
    }

    @Override
    public boolean killMember(ArenaPlayer p) {
        if (!this.hasMember(p)) {
            return false;
        }
        this.deadplayers.add(p);
        return this.deadplayers.size() == this.players.size();
    }

    @Override
    public boolean allPlayersOffline() {
        for (ArenaPlayer p : this.players) {
            if (!p.isOnline()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sendMessage(String message) {
        for (ArenaPlayer p : this.players) {
            MessageUtil.sendMessage(p, message);
        }
    }

    @Override
    public void sendToOtherMembers(ArenaPlayer player, String message) {
        for (ArenaPlayer p : this.players) {
            if (p.equals(player)) continue;
            MessageUtil.sendMessage(p, message);
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? this.getName() : this.displayName;
    }

    @Override
    public void setDisplayName(String teamName) {
        this.displayName = teamName;
        this.nameManuallySet = true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractTeam)) {
            return false;
        }
        return this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "[" + this.getDisplayName() + "]";
    }

    @Override
    public boolean hasTeam(ArenaTeam team) {
        if (team instanceof CompositeTeam) {
            for (ArenaTeam t : ((CompositeTeam)team).getOldTeams()) {
                if (!this.hasTeam(t)) continue;
                return true;
            }
            return false;
        }
        return this.equals(team);
    }

    @Override
    public String getTeamInfo(Set<UUID> insideMatch) {
        StringBuilder sb = new StringBuilder("&eTeam: ");
        if (this.displayName != null) {
            sb.append(this.displayName);
        }
        sb.append(" ").append(this.isDead() ? "&4dead" : "&aalive").append("&e, ");
        for (ArenaPlayer p : this.players) {
            sb.append("&6").append(p.getName());
            boolean isAlive = this.hasAliveMember(p);
            boolean online = p.isOnline();
            String inmatch = insideMatch == null ? "" : (insideMatch.contains(p.getID()) ? "&e(in)" : "&4(out)");
            int k = this.kills.containsKey(p) ? this.kills.get(p) : 0;
            int d = this.deaths.containsKey(p) ? this.deaths.get(p) : 0;
            sb.append("&e(&c").append(k).append("&e,&7").append(d).append("&e)");
            sb.append("&e:").append(isAlive ? "&ah=" + p.getHealth() : "&40").append(!online ? "&4(O)" : "").append(inmatch).append("&e ");
        }
        return sb.toString();
    }

    @Override
    public String getTeamSummary() {
        StringBuilder sb = new StringBuilder("&6" + this.getDisplayName());
        for (ArenaPlayer p : this.players) {
            int k = this.kills.containsKey(p) ? this.kills.get(p) : 0;
            int d = this.deaths.containsKey(p) ? this.deaths.get(p) : 0;
            sb.append("&e(&c").append(k).append("&e,&7").append(d).append("&e)");
        }
        return sb.toString();
    }

    @Override
    public String getOtherNames(ArenaPlayer player) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ArenaPlayer p : this.players) {
            if (p.equals(player)) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(p.getName());
            first = false;
        }
        return sb.toString();
    }

    @Override
    public boolean hasSetName() {
        return this.nameManuallySet;
    }

    @Override
    public int getPriority() {
        int priority = Integer.MAX_VALUE;
        for (ArenaPlayer ap : this.players) {
            if (ap.getPriority() >= priority) continue;
            priority = ap.getPriority();
        }
        return priority;
    }

    @Override
    public void addPlayer(ArenaPlayer player) {
        this.players.add(player);
        this.leftplayers.remove(player);
        this.nameChanged = true;
    }

    @Override
    public boolean removePlayer(ArenaPlayer player) {
        this.deadplayers.remove(player);
        this.leftplayers.remove(player);
        this.kills.remove(player);
        this.deaths.remove(player);
        this.nameChanged = true;
        return this.players.remove(player);
    }

    @Override
    public void playerLeft(ArenaPlayer p) {
        if (!this.hasMember(p)) {
            return;
        }
        this.deadplayers.remove(p);
        this.players.remove(p);
        this.leftplayers.add(p);
    }

    @Override
    public void addPlayers(Collection<ArenaPlayer> players) {
        this.players.addAll(players);
        this.nameChanged = true;
    }

    @Override
    public void removePlayers(Collection<ArenaPlayer> players) {
        this.players.removeAll(players);
        this.deadplayers.removeAll(players);
        this.leftplayers.removeAll(players);
        for (ArenaPlayer ap : players) {
            this.kills.remove(ap);
            this.deaths.remove(ap);
        }
        this.nameChanged = true;
    }

    @Override
    public void clear() {
        this.players.clear();
        this.deadplayers.clear();
        this.leftplayers.clear();
        this.nameManuallySet = false;
        this.nameChanged = false;
        this.name = "Empty";
        this.kills.clear();
        this.deadplayers.clear();
    }

    @Override
    public void setArenaObjective(ArenaObjective objective) {
        this.objective = objective;
        int tk = 0;
        for (ArenaPlayer player : this.getPlayers()) {
            Integer kills = this.getNKills(player);
            if (kills == null) {
                kills = 0;
            }
            objective.setPoints(player, (int)kills);
            tk += kills.intValue();
        }
        objective.setPoints(this, tk);
    }

    @Override
    public void setTeamChatColor(ChatColor color) {
        this.color = color;
    }

    @Override
    public ChatColor getTeamChatColor() {
        return this.color;
    }

    @Override
    public String getIDString() {
        return this.strID == null ? String.valueOf(this.id) : this.strID;
    }

    @Override
    public void setScoreboardDisplayName(String name) {
        this.scoreboardDisplayName = name;
    }

    @Override
    public String getScoreboardDisplayName() {
        if (this.scoreboardDisplayName != null) {
            return this.scoreboardDisplayName;
        }
        String name = this.getDisplayName();
        return name.length() > 16 ? name.substring(0, 16) : name;
    }

    @Override
    public ItemStack getHeadItem() {
        return this.headItem;
    }

    @Override
    public void setHeadItem(ItemStack item) {
        this.headItem = item;
    }

    @Override
    public MatchParams getCurrentParams() {
        return this.params;
    }

    @Override
    public void setCurrentParams(MatchParams params) {
        this.params = params;
    }

    @Override
    public void setArenaStat(ArenaStat stat) {
        this.stat = stat;
    }

    @Override
    public ArenaStat getStat() {
        return TrackerController.loadRecord(this.getCurrentParams(), this);
    }

    @Override
    public ArenaStat getStat(MatchParams params) {
        return TrackerController.loadRecord(params, this);
    }

    @Override
    public int getMinPlayers() {
        return this.minPlayers;
    }

    @Override
    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    @Override
    public void setMinPlayers(int num) {
        this.minPlayers = num;
    }

    @Override
    public void setMaxPlayers(int num) {
        this.maxPlayers = num;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIDString(String id) {
        this.strID = id;
    }
}

