/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.teams;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.teams.AbstractTeam;
import mc.alk.arena.objects.teams.ArenaTeam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompositeTeam
extends AbstractTeam {
    final Set<ArenaTeam> oldTeams = new HashSet<ArenaTeam>();

    public CompositeTeam() {
        this.isPickupTeam = true;
    }

    protected CompositeTeam(ArenaPlayer ap) {
        super(ap);
        this.isPickupTeam = true;
    }

    protected CompositeTeam(Collection<ArenaPlayer> players) {
        super(players);
        this.isPickupTeam = true;
    }

    protected CompositeTeam(ArenaTeam team) {
        this();
        this.addTeam(team);
    }

    protected CompositeTeam(Set<ArenaPlayer> tplayers) {
        super(tplayers);
        this.isPickupTeam = true;
    }

    public void addTeam(ArenaTeam t) {
        if (t instanceof CompositeTeam) {
            CompositeTeam ct = (CompositeTeam)t;
            this.oldTeams.add(ct);
            this.oldTeams.addAll(ct.oldTeams);
            this.players.addAll(ct.getPlayers());
            this.nameChanged = true;
        } else if (this.oldTeams.add(t)) {
            this.nameChanged = true;
            this.players.addAll(t.getPlayers());
        }
    }

    public boolean removeTeam(ArenaTeam t) {
        boolean has;
        if (t instanceof CompositeTeam) {
            for (ArenaTeam tt : ((CompositeTeam)t).getOldTeams()) {
                if (!this.oldTeams.remove(tt)) continue;
                this.nameChanged = true;
            }
        }
        if (has = this.oldTeams.remove(t)) {
            this.players.removeAll(t.getPlayers());
            this.nameChanged = true;
        }
        return has;
    }

    @Override
    public boolean hasTeam(ArenaTeam team) {
        for (ArenaTeam t : this.oldTeams) {
            if (!t.hasTeam(team)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removePlayer(ArenaPlayer p) {
        boolean success = super.removePlayer(p);
        for (ArenaTeam t : this.oldTeams) {
            if (!t.hasMember(p)) continue;
            success |= t.removePlayer(p);
            if (t.size() == 0) {
                this.oldTeams.remove(t);
            }
            this.nameChanged = true;
            break;
        }
        return success;
    }

    public Collection<ArenaTeam> getOldTeams() {
        return this.oldTeams;
    }

    @Override
    public void clear() {
        super.clear();
        for (ArenaTeam t : this.oldTeams) {
            t.clear();
        }
    }
}

