/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.teams;

import java.util.HashSet;
import java.util.Set;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.teams.AbstractTeam;
import mc.alk.arena.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormingTeam
extends AbstractTeam {
    Set<ArenaPlayer> joined_players = new HashSet<ArenaPlayer>();

    public FormingTeam() {
    }

    public FormingTeam(ArenaPlayer p, Set<ArenaPlayer> teammates) {
        super(p, teammates);
        this.joined_players.add(p);
    }

    public void joinTeam(ArenaPlayer p) {
        this.joined_players.add(p);
    }

    public Set<ArenaPlayer> getJoinedPlayers() {
        return this.joined_players;
    }

    public boolean hasJoined(ArenaPlayer p) {
        return this.joined_players.contains(p);
    }

    public boolean isJoining(ArenaPlayer p) {
        return !this.hasJoined(p);
    }

    public Set<ArenaPlayer> getUnjoinedPlayers() {
        if (this.hasAllPlayers()) {
            return null;
        }
        HashSet<ArenaPlayer> ps = new HashSet<ArenaPlayer>(this.players);
        ps.removeAll(this.joined_players);
        return ps;
    }

    public void sendJoinedPlayersMessage(String message) {
        for (ArenaPlayer p : this.joined_players) {
            MessageUtil.sendMessage(p, message);
        }
    }

    public void sendUnjoinedPlayersMessage(String message) {
        Set<ArenaPlayer> unjoined = this.getUnjoinedPlayers();
        if (unjoined == null) {
            return;
        }
        for (ArenaPlayer p : unjoined) {
            MessageUtil.sendMessage(p, message);
        }
    }

    public boolean hasAllPlayers() {
        return this.joined_players.size() == this.players.size();
    }

    @Override
    public boolean isReady() {
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.joined_players.clear();
    }
}

