/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.teams;

import java.awt.Color;
import mc.alk.arena.util.MessageUtil;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.inventory.ItemStack;

public class TeamAppearance {
    final String name;
    final ItemStack headItem;
    final ChatColor chatColor;
    final DyeColor dyeColor;
    final Color color;

    public TeamAppearance(ItemStack is, String name, Color color) {
        this.headItem = is;
        this.name = name;
        this.chatColor = MessageUtil.getFirstColor(name);
        this.color = color;
        this.dyeColor = this.findDyeColor(color);
    }

    private DyeColor findDyeColor(Color color) {
        DyeColor closest = DyeColor.WHITE;
        double min = 3.4028234663852886E38;
        for (DyeColor dc : DyeColor.values()) {
            org.bukkit.Color c = dc.getColor();
            double dev = Math.pow(Math.abs(c.getRed() - color.getRed()), 2.0) + Math.pow(Math.abs(c.getGreen() - color.getGreen()), 2.0) + Math.pow(Math.abs(c.getBlue() - color.getBlue()), 2.0);
            if (!(dev < min)) continue;
            min = dev;
            closest = dc;
        }
        return closest;
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getItem() {
        return this.headItem;
    }

    public ChatColor getChatColor() {
        return this.chatColor;
    }

    public Color getColor() {
        return this.color;
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }
}

