/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.victoryconditions;

import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.controllers.plugins.TrackerController;
import mc.alk.arena.events.matches.MatchFindCurrentLeaderEvent;
import mc.alk.arena.events.players.ArenaPlayerKillEvent;
import mc.alk.arena.objects.WinLossDraw;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.events.EventPriority;
import mc.alk.arena.objects.scoreboard.ArenaObjective;
import mc.alk.arena.objects.scoreboard.ArenaScoreboard;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.victoryconditions.VictoryCondition;
import mc.alk.arena.objects.victoryconditions.interfaces.ScoreTracker;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;
import org.bukkit.configuration.ConfigurationSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KillLimit
extends VictoryCondition
implements ScoreTracker {
    final ArenaObjective kills;
    final TrackerController sc;
    final int numKills;
    final int playerKillPoints;

    public KillLimit(Match match, ConfigurationSection section) {
        super(match);
        this.numKills = section.getInt("numKills", 50);
        this.playerKillPoints = section.getInt("points.player", 1);
        String displayName = section.getString("displayName", "&4Kill Limit");
        String criteria = section.getString("criteria", "&eFirst to &4" + this.numKills);
        this.kills = new ArenaObjective(this.getClass().getSimpleName(), displayName, criteria, SAPIDisplaySlot.SIDEBAR, 60);
        boolean isRated = match.getParams().isRated();
        boolean soloRating = match.getParams().isTeamRating() == false;
        this.sc = isRated && soloRating ? new TrackerController(match.getParams()) : null;
    }

    @ArenaEventHandler(priority=EventPriority.LOW)
    public void playerKillEvent(ArenaPlayerKillEvent event) {
        this.kills.addPoints(event.getPlayer(), this.playerKillPoints);
        Integer points = this.kills.addPoints(event.getTeam(), this.playerKillPoints);
        if (this.sc != null) {
            this.sc.addRecord(event.getPlayer(), event.getTarget(), WinLossDraw.WIN);
        }
        if (points >= this.numKills) {
            this.match.setVictor(event.getTeam());
        }
    }

    @ArenaEventHandler(priority=EventPriority.LOW)
    public void onFindCurrentLeader(MatchFindCurrentLeaderEvent event) {
        if (event.isMatchEnding()) {
            event.setResult(this.kills.getMatchResult(this.match));
        } else {
            List<ArenaTeam> leaders = this.kills.getLeaders();
            if (leaders.size() > 1) {
                event.setCurrentDrawers(leaders);
            } else {
                event.setCurrentLeaders(leaders);
            }
        }
    }

    @Override
    public List<ArenaTeam> getLeaders() {
        return this.kills.getTeamLeaders();
    }

    public TreeMap<Integer, Collection<ArenaTeam>> getRanks() {
        return this.kills.getTeamRanks();
    }

    @Override
    public void setScoreBoard(ArenaScoreboard scoreboard) {
        this.kills.setScoreBoard(scoreboard);
        scoreboard.addObjective(this.kills);
    }

    @Override
    public void setDisplayTeams(boolean display) {
        this.kills.setDisplayPlayers(display);
    }
}

