/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.victoryconditions;

import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.events.matches.MatchFindCurrentLeaderEvent;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.events.EventPriority;
import mc.alk.arena.objects.scoreboard.ArenaObjective;
import mc.alk.arena.objects.scoreboard.ArenaScoreboard;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.victoryconditions.VictoryCondition;
import mc.alk.arena.objects.victoryconditions.interfaces.ScoreTracker;
import mc.alk.arena.util.DmgDeathUtil;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.entity.EntityDeathEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobKills
extends VictoryCondition
implements ScoreTracker {
    final ArenaObjective mkills;

    public MobKills(Match match, ConfigurationSection section) {
        super(match);
        String displayName = section.getString("displayName", "Mob Kills");
        String criteria = section.getString("criteria", "Kill mobs");
        this.mkills = new ArenaObjective(this.getClass().getSimpleName(), displayName, criteria, SAPIDisplaySlot.SIDEBAR, 60);
    }

    @Override
    public List<ArenaTeam> getLeaders() {
        return this.mkills.getTeamLeaders();
    }

    public TreeMap<Integer, Collection<ArenaTeam>> getRanks() {
        return this.mkills.getTeamRanks();
    }

    @ArenaEventHandler(priority=EventPriority.LOW)
    public void mobDeathEvent(EntityDeathEvent event) {
        switch (event.getEntityType()) {
            case BLAZE: {
                break;
            }
            case CAVE_SPIDER: {
                break;
            }
            case CHICKEN: {
                break;
            }
            case COW: {
                break;
            }
            case CREEPER: {
                break;
            }
            case ENDERMAN: {
                break;
            }
            case ENDER_DRAGON: {
                break;
            }
            case GHAST: {
                break;
            }
            case GIANT: {
                break;
            }
            case IRON_GOLEM: {
                break;
            }
            case MAGMA_CUBE: {
                break;
            }
            case MUSHROOM_COW: {
                break;
            }
            case OCELOT: {
                break;
            }
            case PIG: {
                break;
            }
            case PIG_ZOMBIE: {
                break;
            }
            case SHEEP: {
                break;
            }
            case SILVERFISH: {
                break;
            }
            case SKELETON: {
                break;
            }
            case SLIME: {
                break;
            }
            case SNOWMAN: {
                break;
            }
            case SPIDER: {
                break;
            }
            case SQUID: {
                break;
            }
            case VILLAGER: {
                break;
            }
            case WOLF: {
                break;
            }
            case ZOMBIE: {
                break;
            }
            default: {
                return;
            }
        }
        ArenaPlayer killer = DmgDeathUtil.getPlayerCause(event.getEntity().getLastDamageCause());
        if (killer == null) {
            return;
        }
        ArenaTeam t = this.match.getTeam(killer);
        if (t == null) {
            return;
        }
        t.addKill(killer);
        this.mkills.addPoints(t, 1);
        this.mkills.addPoints(killer, 1);
    }

    @ArenaEventHandler(priority=EventPriority.LOW)
    public void onFindCurrentLeader(MatchFindCurrentLeaderEvent event) {
        event.setResult(this.mkills.getMatchResult(this.match));
    }

    @Override
    public void setScoreBoard(ArenaScoreboard scoreboard) {
        this.mkills.setScoreBoard(scoreboard);
        scoreboard.addObjective(this.mkills);
    }

    @Override
    public void setDisplayTeams(boolean display) {
        this.mkills.setDisplayTeams(display);
    }
}

