/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.victoryconditions;

import java.util.ArrayList;
import java.util.HashSet;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.events.teams.TeamDeathEvent;
import mc.alk.arena.objects.MatchResult;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.victoryconditions.VictoryCondition;
import mc.alk.arena.objects.victoryconditions.interfaces.DefinesNumTeams;
import mc.alk.arena.util.MinMax;

public class NTeamsNeeded
extends VictoryCondition
implements DefinesNumTeams {
    MinMax neededTeams;

    public NTeamsNeeded(Match match, int nTeams) {
        super(match);
        this.neededTeams = new MinMax(nTeams);
    }

    public MinMax getNeededNumberOfTeams() {
        return this.neededTeams;
    }

    @ArenaEventHandler
    public void onTeamDeathEvent(TeamDeathEvent event) {
        ArrayList<ArenaTeam> leftAlive = new ArrayList<ArenaTeam>(this.neededTeams.min + 1);
        for (ArenaTeam t : this.match.getTeams()) {
            if (t.isDead()) continue;
            leftAlive.add(t);
            if (leftAlive.size() < this.neededTeams.min) continue;
            return;
        }
        if (leftAlive.isEmpty()) {
            this.match.setLosers();
            return;
        }
        if (leftAlive.size() < this.neededTeams.min) {
            MatchResult mr = new MatchResult();
            mr.setVictors(leftAlive);
            HashSet<ArenaTeam> losers = new HashSet<ArenaTeam>(this.match.getTeams());
            losers.removeAll(leftAlive);
            mr.setLosers(losers);
            this.match.endMatchWithResult(mr);
        }
    }

    public String toString() {
        return "[VC " + this.getClass().getSimpleName() + " : " + this.id + " nTeams=" + this.neededTeams + "]";
    }
}

