/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.victoryconditions;

import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.events.matches.MatchFinishedEvent;
import mc.alk.arena.objects.MatchResult;
import mc.alk.arena.objects.WinLossDraw;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.events.EventPriority;
import mc.alk.arena.objects.scoreboard.ArenaScoreboard;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.victoryconditions.VictoryCondition;
import mc.alk.arena.objects.victoryconditions.interfaces.DefinesTimeLimit;
import mc.alk.arena.util.Countdown;
import mc.alk.arena.util.MessageUtil;
import mc.alk.scoreboardapi.api.SObjective;
import mc.alk.scoreboardapi.api.STeam;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;
import mc.alk.scoreboardapi.scoreboard.bukkit.BObjective;
import org.bukkit.plugin.Plugin;

public class TeamTimeLimit
extends VictoryCondition
implements DefinesTimeLimit,
Countdown.CountdownCallback {
    Countdown timer;
    int announceInterval;
    final ArenaTeam team;

    public TeamTimeLimit(Match match, ArenaTeam team) {
        super(match);
        this.team = team;
    }

    public void startCountdown() {
        this.timer = new Countdown((Plugin)BattleArena.getSelf(), this.match.getParams().getMatchTime(), 1, (Countdown.CountdownCallback)this);
    }

    public void stopCountdown() {
        this.cancelTimers();
    }

    @ArenaEventHandler(priority=EventPriority.LOW)
    public void onFinished(MatchFinishedEvent event) {
        this.cancelTimers();
    }

    private void cancelTimers() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public boolean intervalTick(int remaining) {
        if (this.match.isEnding()) {
            return false;
        }
        if (remaining <= 0) {
            MatchResult cr = new MatchResult();
            cr.setResult(WinLossDraw.LOSS);
            cr.addLoser(this.team);
            this.match.endMatchWithResult(cr);
        }
        if (!Defaults.USE_SCOREBOARD) {
            return true;
        }
        ArenaScoreboard as = this.match.getScoreboard();
        if (as == null) {
            return true;
        }
        STeam t = as.getTeam(this.team.getIDString());
        SObjective ao = as.getObjective(SAPIDisplaySlot.SIDEBAR);
        if (t != null && ao != null && ao instanceof BObjective) {
            ((BObjective)ao).setDisplayName(ao.getDisplayNamePrefix(), ao.getBaseDisplayName(), MessageUtil.colorChat("&e(" + remaining + ")"), t);
        }
        return true;
    }

    public int getTime() {
        return this.match.getParams().getMatchTime();
    }
}

