/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.victoryconditions;

import mc.alk.arena.BattleArena;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.events.matches.MatchFinishedEvent;
import mc.alk.arena.events.matches.MatchResultEvent;
import mc.alk.arena.events.matches.MatchStartEvent;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.events.EventPriority;
import mc.alk.arena.objects.victoryconditions.VictoryCondition;
import mc.alk.arena.objects.victoryconditions.interfaces.DefinesTimeLimit;
import mc.alk.arena.util.Countdown;
import org.bukkit.plugin.Plugin;

public class TimeLimit
extends VictoryCondition
implements DefinesTimeLimit,
Countdown.CountdownCallback {
    Countdown timer;
    int announceInterval;

    public TimeLimit(Match match) {
        super(match);
    }

    @ArenaEventHandler(priority=EventPriority.LOW)
    public void onStart(MatchStartEvent event) {
        this.cancelTimers();
        this.announceInterval = this.match.getParams().getIntervalTime();
        this.timer = new Countdown((Plugin)BattleArena.getSelf(), this.match.getParams().getMatchTime(), this.announceInterval, (Countdown.CountdownCallback)this);
    }

    @ArenaEventHandler(priority=EventPriority.LOW)
    public void onVictory(MatchResultEvent event) {
        if (event.isMatchEnding()) {
            this.cancelTimers();
        }
    }

    @ArenaEventHandler(priority=EventPriority.LOW)
    public void onFinished(MatchFinishedEvent event) {
        this.cancelTimers();
    }

    private void cancelTimers() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public boolean intervalTick(int remaining) {
        if (remaining <= 0) {
            this.match.timeExpired();
        } else if (remaining % this.announceInterval == 0) {
            this.match.intervalTick(remaining);
        }
        return true;
    }

    public int getTime() {
        return this.match.getParams().getMatchTime();
    }
}

