/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.objects.victoryconditions;

import java.lang.reflect.Constructor;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.objects.victoryconditions.NLives;
import mc.alk.arena.objects.victoryconditions.VictoryCondition;
import mc.alk.arena.serializers.BaseConfig;
import mc.alk.arena.util.CaseInsensitiveMap;
import mc.alk.arena.util.Log;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VictoryType {
    public static final CaseInsensitiveMap<VictoryType> types = new CaseInsensitiveMap();
    public static final CaseInsensitiveMap<Class<?>> classes = new CaseInsensitiveMap();
    public static final CaseInsensitiveMap<BaseConfig> configs = new CaseInsensitiveMap();
    static int count = 0;
    final String name;
    final Plugin ownerPlugin;
    final int id = count++;

    private VictoryType(String name, Plugin plugin) {
        this.name = name;
        this.ownerPlugin = plugin;
        if (!types.containsKey(name)) {
            types.put(name, this);
        }
    }

    public static VictoryType fromString(String type) {
        if (type.equalsIgnoreCase("none")) {
            return types.get("custom");
        }
        return type == null ? null : types.get(type);
    }

    public static VictoryType getType(VictoryCondition vc) {
        return vc == null ? null : types.get(vc.getClass().getSimpleName());
    }

    public static VictoryType getType(Class<? extends VictoryCondition> vc) {
        return vc == null ? null : types.get(vc.getSimpleName());
    }

    public static String getValidList() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (VictoryType at : types.values()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(at.name);
        }
        return sb.toString();
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public static VictoryCondition createVictoryCondition(Match match) {
        VictoryType vt = match.getParams().getVictoryType();
        Class<?> vcClass = classes.get(vt.getName());
        if (vcClass == null) {
            return null;
        }
        BaseConfig config = configs.get(vt.getName());
        Constructor<?> constructor = null;
        try {
            constructor = vcClass.getConstructor(Match.class, ConfigurationSection.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            VictoryCondition newVC;
            if (constructor != null) {
                Object[] args = new Object[]{match, config != null ? config.getConfig() : null};
                newVC = (VictoryCondition)constructor.newInstance(args);
            } else {
                constructor = vcClass.getConstructor(Match.class);
                newVC = (VictoryCondition)constructor.newInstance(match);
            }
            if (newVC instanceof NLives) {
                Integer nlives = match.getParams().getNLives();
                ((NLives)newVC).setMaxLives(nlives == null ? 1 : nlives);
            }
            return newVC;
        }
        catch (Exception e) {
            Log.err("VictoryType = " + vt + "  class=" + vcClass.getSimpleName());
            Log.printStackTrace(e);
            return null;
        }
    }

    public static void register(Class<? extends VictoryCondition> vc, Plugin plugin) {
        String vcName = vc.getSimpleName().toUpperCase();
        if (!classes.containsKey(vcName)) {
            classes.put(vcName, vc);
        }
        if (!types.containsKey(vcName)) {
            new VictoryType(vc.getSimpleName(), plugin);
        }
    }

    public static boolean registered(VictoryCondition vc) {
        String vcName = vc.getClass().getSimpleName().toUpperCase();
        return classes.containsKey(vcName) && types.containsKey(vcName);
    }

    public int ordinal() {
        return this.id;
    }

    public static VictoryType[] values() {
        return types.values().toArray(new VictoryType[types.size()]);
    }

    public static void addConfig(VictoryType type, BaseConfig config) {
        configs.put(type.getName(), config);
    }
}

