/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.serializers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.PlayerController;
import mc.alk.arena.controllers.PlayerRestoreController;
import mc.alk.arena.listeners.BAPlayerListener;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.serializers.BaseConfig;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.SerializerUtil;
import mc.alk.arena.util.Util;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class ArenaControllerSerializer
extends BaseConfig {
    public ArenaControllerSerializer() {
        this.setConfig(BattleArena.getSelf().getDataFolder() + "/saves/arenaplayers.yml");
    }

    public void load() {
        UUID id;
        try {
            this.config.load(this.file);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        ConfigurationSection cs = this.config.getConfigurationSection("tpOnReenter");
        if (cs != null) {
            for (String name : cs.getKeys(false)) {
                ConfigurationSection loccs = cs.getConfigurationSection(name);
                Location loc = null;
                try {
                    loc = SerializerUtil.getLocation(loccs.getString("loc"));
                }
                catch (IllegalArgumentException e) {
                    Log.printStackTrace(e);
                }
                if (loc == null) {
                    System.err.println("Couldnt load the player " + name + " when reading tpOnReenter inside arenaplayers.yml");
                    continue;
                }
                id = Util.fromString(name);
                ArenaPlayer ap = PlayerController.toArenaPlayer(id);
                BAPlayerListener.teleportOnReenter(ap, loc, null);
            }
        }
        if ((cs = this.config.getConfigurationSection("clearInventoryOnReenter")) != null) {
            Set strs = cs.getKeys(false);
            for (String s : strs) {
                UUID id2 = Util.fromString(s);
                BAPlayerListener.clearInventoryOnReenter(PlayerController.toArenaPlayer(id2));
            }
        }
        if ((cs = this.config.getConfigurationSection("restoreGameModeOnReenter")) != null) {
            for (String name : cs.getKeys(false)) {
                GameMode gm;
                block17: {
                    ConfigurationSection cs2 = cs.getConfigurationSection(name);
                    String strgm = cs2.getString("gamemode");
                    if (strgm == null) {
                        System.err.println("Couldnt load the player " + name + " when reading restoreGameModeOnReenter inside arenaplayers.yml");
                        continue;
                    }
                    try {
                        gm = GameMode.valueOf((String)strgm);
                        if (gm == null) {
                            System.err.println("Couldnt load the player " + name + " when reading restoreGameModeOnReenter inside arenaplayers.yml");
                        }
                        break block17;
                    }
                    catch (Exception e) {
                        System.err.println("Couldnt load the player " + name + " when reading restoreGameModeOnReenter inside arenaplayers.yml");
                    }
                    continue;
                }
                UUID id3 = Util.fromString(name);
                BAPlayerListener.restoreGameModeOnEnter(PlayerController.toArenaPlayer(id3), gm);
            }
        }
        if ((cs = this.config.getConfigurationSection("restoreInv")) != null) {
            for (String name : cs.getKeys(false)) {
                ConfigurationSection pcs = cs.getConfigurationSection(name);
                InventoryUtil.PInv pinv = ArenaControllerSerializer.getInventory(pcs);
                id = Util.fromString(name);
                BAPlayerListener.restoreItemsOnReenter(PlayerController.toArenaPlayer(id), pinv);
            }
        }
    }

    public static InventoryUtil.PInv getInventory(ConfigurationSection cs) {
        ItemStack is;
        InventoryUtil.PInv pinv = new InventoryUtil.PInv();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        List stritems = cs.getStringList("armor");
        for (String stritem : stritems) {
            try {
                is = InventoryUtil.parseItem(stritem);
            }
            catch (Exception e) {
                System.err.println("Couldnt reparse " + stritem + " for player " + cs.getName());
                Log.printStackTrace(e);
                continue;
            }
            items.add(is);
        }
        pinv.armor = items.toArray(new ItemStack[items.size()]);
        items = new ArrayList();
        stritems = cs.getStringList("contents");
        for (String stritem : stritems) {
            try {
                is = InventoryUtil.parseItem(stritem);
            }
            catch (Exception e) {
                System.err.println("Couldnt reparse " + stritem + " for player " + cs.getName());
                Log.printStackTrace(e);
                continue;
            }
            items.add(is);
        }
        pinv.contents = items.toArray(new ItemStack[items.size()]);
        return pinv;
    }

    public void save() {
        ConfigurationSection pc;
        HashMap<UUID, PlayerRestoreController> prcs = new HashMap<UUID, PlayerRestoreController>(BAPlayerListener.getPlayerRestores());
        HashMap<UUID, Location> playerLocs = new HashMap<UUID, Location>();
        ArrayList<UUID> dieOnReenter = new ArrayList<UUID>();
        ArrayList<UUID> clearInventoryReenter = new ArrayList<UUID>();
        HashMap<UUID, GameMode> gameModes = new HashMap<UUID, GameMode>();
        HashMap<UUID, InventoryUtil.PInv> items = new HashMap<UUID, InventoryUtil.PInv>();
        for (PlayerRestoreController prc : prcs.values()) {
            UUID uUID = prc.getUUID();
            if (prc.getTeleportLocation() != null) {
                playerLocs.put(uUID, prc.getTeleportLocation());
            }
            if (prc.getKill()) {
                dieOnReenter.add(uUID);
            }
            if (prc.getClearInventory()) {
                clearInventoryReenter.add(uUID);
            }
            if (prc.getGamemode() != null) {
                gameModes.put(uUID, prc.getGamemode());
            }
            if (prc.getItem() == null) continue;
            items.put(uUID, prc.getItem());
        }
        ConfigurationSection cs = this.config.createSection("tpOnReenter");
        for (UUID uUID : playerLocs.keySet()) {
            pc = cs.createSection(uUID.toString());
            Location loc = (Location)playerLocs.get(uUID);
            pc.set("loc", (Object)SerializerUtil.getLocString(loc));
        }
        cs = this.config.createSection("dieOnReenter");
        for (UUID uUID : dieOnReenter) {
            cs.createSection(uUID.toString());
        }
        cs = this.config.createSection("clearInventoryOnReenter");
        for (UUID uUID : clearInventoryReenter) {
            cs.createSection(uUID.toString());
        }
        cs = this.config.createSection("restoreGameModeOnReenter");
        for (Map.Entry entry : gameModes.entrySet()) {
            pc = cs.createSection(((UUID)entry.getKey()).toString());
            pc.set("gamemode", (Object)((GameMode)entry.getValue()).toString());
        }
        cs = this.config.createSection("restoreInv");
        for (UUID uUID : items.keySet()) {
            ConfigurationSection pcs = cs.createSection(uUID.toString());
            InventoryUtil.PInv inv = (InventoryUtil.PInv)items.get(uUID);
            ArrayList<String> stritems = new ArrayList<String>();
            for (ItemStack is : inv.armor) {
                if (is == null || is.getType() == Material.AIR) continue;
                stritems.add(InventoryUtil.getItemString(is));
            }
            pcs.set("armor", stritems);
            stritems = new ArrayList();
            for (ItemStack is : inv.contents) {
                if (is == null || is.getType() == Material.AIR) continue;
                stritems.add(InventoryUtil.getItemString(is));
            }
            pcs.set("contents", stritems);
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            Log.printStackTrace(e);
        }
    }
}

