/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.serializers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.BattleArenaController;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.controllers.RoomController;
import mc.alk.arena.controllers.Scheduler;
import mc.alk.arena.controllers.containers.AreaContainer;
import mc.alk.arena.controllers.containers.RoomContainer;
import mc.alk.arena.controllers.plugins.WorldGuardController;
import mc.alk.arena.objects.ArenaParams;
import mc.alk.arena.objects.LocationType;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.StateGraph;
import mc.alk.arena.objects.StateOption;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.arenas.ArenaControllerInterface;
import mc.alk.arena.objects.arenas.ArenaType;
import mc.alk.arena.objects.arenas.Persistable;
import mc.alk.arena.objects.exceptions.RegionNotFound;
import mc.alk.arena.objects.options.EventOpenOptions;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.objects.spawns.BlockSpawn;
import mc.alk.arena.objects.spawns.ChestSpawn;
import mc.alk.arena.objects.spawns.EntitySpawn;
import mc.alk.arena.objects.spawns.ItemSpawn;
import mc.alk.arena.objects.spawns.SpawnGroup;
import mc.alk.arena.objects.spawns.SpawnInstance;
import mc.alk.arena.objects.spawns.SpawnLocation;
import mc.alk.arena.objects.spawns.SpawnTime;
import mc.alk.arena.objects.spawns.TimedSpawn;
import mc.alk.arena.serializers.BaseConfig;
import mc.alk.arena.serializers.ConfigSerializer;
import mc.alk.arena.serializers.SpawnSerializer;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MinMax;
import mc.alk.arena.util.SerializerUtil;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArenaSerializer
extends BaseConfig {
    static BattleArenaController arenaController;
    static HashMap<Plugin, Set<ArenaSerializer>> configs;
    Plugin plugin;

    public static void setBAC(BattleArenaController bac) {
        arenaController = bac;
    }

    public ArenaSerializer(Plugin plugin, File file) {
        this.setConfig(file);
        this.plugin = plugin;
        this.config = new YamlConfiguration();
        Set<ArenaSerializer> paths = configs.get(plugin);
        if (paths == null) {
            paths = new HashSet<ArenaSerializer>();
            configs.put(plugin, paths);
        } else {
            for (ArenaSerializer as : paths) {
                if (!as.file.getPath().equals(this.file.getPath())) continue;
                return;
            }
        }
        paths.add(this);
    }

    public static void loadAllArenas() {
        for (Plugin plugin : configs.keySet()) {
            ArenaSerializer.loadAllArenas(plugin);
        }
    }

    public static void loadAllArenas(Plugin plugin) {
        for (ArenaSerializer serializer : configs.get(plugin)) {
            serializer.loadArenas(plugin);
        }
    }

    public static void loadAllArenas(Plugin plugin, ArenaType arenaType) {
        Set<ArenaSerializer> serializers = configs.get(plugin);
        if (serializers == null || serializers.isEmpty()) {
            Log.err(plugin.getName() + " has no arenas to load");
            return;
        }
        for (ArenaSerializer serializer : serializers) {
            serializer.loadArenas(plugin, arenaType);
        }
    }

    public void loadArenas(Plugin plugin) {
        try {
            this.config.load(this.file);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        this.loadArenas(plugin, BattleArena.getBAController(), (ConfigurationSection)this.config, null);
    }

    public void loadArenas(Plugin plugin, ArenaType arenaType) {
        try {
            this.config.load(this.file);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        this.loadArenas(plugin, BattleArena.getBAController(), (ConfigurationSection)this.config, arenaType);
    }

    protected void loadArenas(Plugin plugin, BattleArenaController bac, ConfigurationSection cs, ArenaType arenaType) {
        String pname = "[" + plugin.getName() + "] ";
        if (cs == null) {
            Log.info(pname + " " + arenaType + " has no arenas, cs is null");
            return;
        }
        ConfigurationSection as = cs.getConfigurationSection("arenas");
        ConfigurationSection bks = cs.getConfigurationSection("brokenArenas");
        if (as == null && bks == null) {
            return;
        }
        ArrayList keys = as == null ? new ArrayList() : new ArrayList(as.getKeys(false));
        int oldGoodSize = keys.size();
        Set brokenKeys = bks == null ? new HashSet() : bks.getKeys(false);
        int oldBrokenSize = brokenKeys.size();
        keys.addAll(brokenKeys);
        HashSet<String> brokenArenas = new HashSet<String>();
        HashSet<String> loadedArenas = new HashSet<String>();
        for (String name : keys) {
            String path;
            String atype;
            String section;
            if (loadedArenas.contains(name) || brokenArenas.contains(name)) continue;
            boolean broken = brokenKeys.contains(name);
            String string = section = broken ? "brokenArenas" : "arenas";
            if (!(arenaType == null || (atype = cs.getString((path = section + "." + name) + ".type", null)) != null && ArenaType.isSame(atype, arenaType))) {
                if (brokenArenas.remove(name)) {
                    --oldBrokenSize;
                    continue;
                }
                --oldGoodSize;
                continue;
            }
            Arena arena = null;
            try {
                arena = ArenaSerializer.loadArena(plugin, bac, cs.getConfigurationSection(section + "." + name));
                if (arena != null) {
                    loadedArenas.add(arena.getName());
                    if (broken) {
                        ArenaSerializer.transfer(cs, "brokenArenas." + name, "arenas." + name);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Log.err(e.getMessage());
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
            if (arena != null) continue;
            brokenArenas.add(name);
            if (broken) continue;
            ArenaSerializer.transfer(cs, "arenas." + name, "brokenArenas." + name);
        }
        if (!loadedArenas.isEmpty()) {
            Log.info(pname + "Loaded " + arenaType + " arenas: " + StringUtils.join(loadedArenas, (String)", "));
        }
        if (!brokenArenas.isEmpty()) {
            Log.warn("&c" + pname + "&eFailed loading arenas: " + StringUtils.join(brokenArenas, (String)", ") + " arenatype=" + arenaType + " cs=" + cs.getName());
        }
        if (oldGoodSize != loadedArenas.size() || oldBrokenSize != brokenArenas.size()) {
            try {
                this.config.save(this.file);
            }
            catch (IOException e) {
                Log.printStackTrace(e);
            }
        }
    }

    private static void transfer(ConfigurationSection cs, String string, String string2) {
        try {
            HashMap map = new HashMap(cs.getConfigurationSection(string).getValues(false));
            cs.createSection(string2, map);
            cs.set(string, null);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public static Arena loadArena(Plugin plugin, final BattleArenaController bac, ConfigurationSection cs) {
        ConfigurationSection spawncs;
        RoomContainer rc;
        MinMax mm;
        String name = cs.getName().toLowerCase();
        ArenaType atype = ArenaType.fromString(cs.getString("type"));
        if (atype == null) {
            Log.err(" Arena type not found for " + name);
            return null;
        }
        MatchParams mp = new MatchParams(atype);
        try {
            if (cs.contains("params")) {
                mp = ConfigSerializer.loadMatchParams(plugin, atype, name, cs.getConfigurationSection("params"), true);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        if (cs.contains("teamSize")) {
            mm = MinMax.valueOf(cs.getString("teamSize"));
            mp.setTeamSize(mm);
        }
        if (cs.contains("nTeams")) {
            mm = MinMax.valueOf(cs.getString("nTeams"));
            mp.setNTeams(mm);
        }
        if (!mp.valid()) {
            Log.err(name + " This arena is not valid arenaq=" + mp.toString());
            return null;
        }
        final Arena arena = ArenaType.createArena(name, mp, false);
        if (arena == null) {
            Log.err("Couldnt load the Arena " + name);
            return null;
        }
        Map<Integer, List<SpawnLocation>> locs = SerializerUtil.parseLocations(cs.getConfigurationSection("locations"));
        if (locs != null) {
            ArenaSerializer.setSpawns(arena, locs);
        }
        if ((locs = SerializerUtil.parseLocations(cs.getConfigurationSection("waitRoomLocations"))) != null) {
            rc = RoomController.getOrCreateRoom(arena, LocationType.WAITROOM);
            ArenaSerializer.setSpawns(rc, locs);
        }
        if ((locs = SerializerUtil.parseLocations(cs.getConfigurationSection("spectateLocations"))) != null) {
            rc = RoomController.getOrCreateRoom(arena, LocationType.SPECTATE);
            ArenaSerializer.setSpawns(rc, locs);
        }
        if ((locs = SerializerUtil.parseLocations(cs.getConfigurationSection("visitorLocations"))) != null) {
            rc = RoomController.getOrCreateRoom(arena, LocationType.VISITOR);
            ArenaSerializer.setSpawns(rc, locs);
        }
        if ((spawncs = cs.getConfigurationSection("spawns")) != null) {
            for (String spawnStr : spawncs.getKeys(false)) {
                TimedSpawn s;
                ConfigurationSection scs = spawncs.getConfigurationSection(spawnStr);
                try {
                    s = ArenaSerializer.parseSpawnable(scs);
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                    continue;
                }
                if (s == null) continue;
                arena.addTimedSpawn(Long.parseLong(spawnStr), s);
            }
        }
        cs = cs.getConfigurationSection("persistable");
        Persistable.yamlToObjects(arena, cs, Arena.class);
        ArenaSerializer.updateRegions(arena);
        ArenaControllerInterface aci = new ArenaControllerInterface(arena);
        aci.init();
        bac.addArena(arena);
        if (arena.getParams().hasAnyOption(TransitionOption.ALWAYSOPEN)) {
            Scheduler.scheduleSynchronousTask(new Runnable(){

                public void run() {
                    try {
                        EventOpenOptions eoo = EventOpenOptions.parseOptions(new String[]{"COPYPARAMS"}, null, arena.getParams());
                        Arena a = bac.reserveArena(arena);
                        if (a == null) {
                            Log.warn("&cArena &6" + arena.getName() + " &cwas set to always open but could not be reserved");
                        } else {
                            eoo.setSecTillStart(0);
                            bac.createAndAutoMatch(arena, eoo);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return arena;
    }

    private static void setSpawns(AreaContainer rc, Map<Integer, List<SpawnLocation>> locs) {
        for (Map.Entry<Integer, List<SpawnLocation>> entry : locs.entrySet()) {
            try {
                List<SpawnLocation> list = entry.getValue();
                for (int i = 0; i < list.size(); ++i) {
                    rc.setSpawnLoc(entry.getKey(), i, list.get(i));
                }
            }
            catch (IllegalStateException e) {
                Log.printStackTrace(e);
            }
        }
    }

    private static void updateRegions(Arena arena) {
        MatchParams mp;
        if (!WorldGuardController.hasWorldGuard()) {
            return;
        }
        if (!arena.hasRegion()) {
            return;
        }
        if (!WorldGuardController.hasRegion(arena.getWorldGuardRegion())) {
            Log.err("Arena " + arena.getName() + " has a world guard region defined but it no longer exists inside of WorldGuard." + "You will have to remake the region.  /arena alter <arena name> addregion");
        }
        if ((mp = ParamController.getMatchParamCopy(arena.getArenaType().getName())) == null) {
            return;
        }
        StateGraph trans = mp.getThisStateGraph();
        if (trans == null) {
            return;
        }
        WorldGuardController.setFlag(arena.getWorldGuardRegion(), "entry", !trans.hasAnyOption((StateOption)TransitionOption.WGNOENTER));
        try {
            WorldGuardController.trackRegion(arena.getWorldGuardRegion());
        }
        catch (RegionNotFound e) {
            Log.printStackTrace(e);
        }
    }

    private void saveArenas(boolean log) {
        ArenaSerializer.saveArenas(BattleArena.getBAController().getArenas().values(), this.file, (ConfigurationSection)this.config, this.plugin, log);
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            Log.printStackTrace(e);
        }
    }

    private static void saveArenas(Collection<Arena> arenas, File f, ConfigurationSection config, Plugin plugin, boolean log) {
        ConfigurationSection maincs = config.createSection("arenas");
        config.createSection("brokenArenas");
        ArrayList<String> saved = new ArrayList<String>();
        for (Arena arena : arenas) {
            String arenaname = null;
            try {
                Map<String, Object> persisted;
                Map<Long, TimedSpawn> timedSpawns;
                arenaname = arena.getName();
                ArenaType at = arena.getArenaType();
                if (!at.getPlugin().getName().equals(plugin.getName())) continue;
                ArenaParams parentParams = arena.getParams().getParent();
                arena.getParams().setParent(null);
                HashMap<String, Object> amap = new HashMap<String, Object>();
                amap.put("type", at.getName());
                Map<String, List<String>> locs = SerializerUtil.toSpawnMap(arena);
                if (locs != null) {
                    amap.put("locations", locs);
                }
                if ((locs = SerializerUtil.toSpawnMap(arena.getWaitroom())) != null) {
                    amap.put("waitRoomLocations", locs);
                }
                if ((locs = SerializerUtil.toSpawnMap(arena.getSpectatorRoom())) != null) {
                    amap.put("spectateLocations", locs);
                }
                if ((locs = SerializerUtil.toSpawnMap(arena.getVisitorRoom())) != null) {
                    amap.put("visitorLocations", locs);
                }
                if ((timedSpawns = arena.getTimedSpawns()) != null && !timedSpawns.isEmpty()) {
                    HashMap<String, HashMap<String, Object>> spawnmap = new HashMap<String, HashMap<String, Object>>();
                    for (Long key : timedSpawns.keySet()) {
                        TimedSpawn ts = timedSpawns.get(key);
                        HashMap<String, Object> itemSpawnMap = ArenaSerializer.saveSpawnable(ts);
                        spawnmap.put(key.toString(), itemSpawnMap);
                    }
                    amap.put("spawns", spawnmap);
                }
                if ((persisted = Persistable.objectsToYamlMap(arena, Arena.class)) != null && !persisted.isEmpty()) {
                    amap.put("persistable", persisted);
                }
                saved.add(arenaname);
                ConfigurationSection arenacs = maincs.createSection(arenaname);
                SerializerUtil.expandMapIntoConfig(arenacs, amap);
                ConfigSerializer.saveParams(arena.getParams(), arenacs.createSection("params"), true);
                arena.getParams().setParent(parentParams);
                config.set("brokenArenas." + arenaname, null);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                if (arenaname == null) continue;
                ArenaSerializer.transfer(config, "arenas." + arenaname, "brokenArenas." + arenaname);
            }
        }
        if (log) {
            Log.info(plugin.getName() + " Saving arenas " + StringUtils.join(saved, (String)",") + " to " + f.getPath() + " configSection=" + config.getCurrentPath() + "." + config.getName());
        }
    }

    protected void saveArenas() {
        this.saveArenas(false);
    }

    @Override
    public void save() {
        this.saveArenas(true);
    }

    public static void saveAllArenas(boolean log) {
        for (Plugin plugin : configs.keySet()) {
            for (ArenaSerializer serializer : configs.get(plugin)) {
                serializer.saveArenas(log);
            }
        }
    }

    public static void saveArenas(Plugin plugin) {
        if (!configs.containsKey(plugin)) {
            return;
        }
        for (ArenaSerializer serializer : configs.get(plugin)) {
            serializer.saveArenas(true);
        }
    }

    private static TimedSpawn parseSpawnable(ConfigurationSection cs) throws IllegalArgumentException {
        SpawnInstance si;
        if (!(cs.contains("spawn") && cs.contains("time") && cs.contains("loc"))) {
            Log.err("configuration section cs = " + cs + "  is missing either spawn,time,or loc");
            return null;
        }
        SpawnTime st = ArenaSerializer.parseSpawnTime(cs.getString("time"));
        Location loc = SerializerUtil.getLocation(cs.getString("loc"));
        List<String> strings = SpawnSerializer.convertToStringList(cs.getString("spawn"));
        if (strings == null || strings.isEmpty()) {
            return null;
        }
        if (cs.contains("type") && cs.getString("type").equalsIgnoreCase("block")) {
            si = new BlockSpawn(loc.getBlock(), false);
            Material mat = Material.valueOf((String)cs.getString("spawn"));
            ((BlockSpawn)si).setMaterial(mat);
            try {
                mat = Material.valueOf((String)cs.getString("despawnMaterial", "AIR"));
            }
            catch (Exception e) {
                Log.err("Error setting despawnMaterial. " + e.getMessage());
                mat = Material.AIR;
            }
            if (mat != null) {
                ((BlockSpawn)si).setDespawnMaterial(mat);
            }
        } else if (cs.contains("type") && cs.getString("type").equalsIgnoreCase("chest")) {
            si = new ChestSpawn(loc.getBlock(), false);
            Material mat = Material.valueOf((String)cs.getString("spawn"));
            ((BlockSpawn)si).setMaterial(mat);
            ArrayList<Object> items = InventoryUtil.getItemList(cs, "giveItems");
            if (items == null) {
                items = new ArrayList();
            }
            ((ChestSpawn)si).setItems(items);
        } else {
            List<SpawnInstance> spawns = SpawnSerializer.parseSpawnable(strings);
            if (spawns == null || spawns.isEmpty()) {
                return null;
            }
            spawns.get(0).setLocation(loc);
            si = spawns.get(0);
        }
        return new TimedSpawn(st.i1, st.i2, st.i3, si);
    }

    public static SpawnTime parseSpawnTime(String str) {
        String[] strs = str.split(" ");
        Integer[] is = new Integer[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            is[i] = Integer.valueOf(strs[i]);
        }
        return new SpawnTime(is[0], is[1], is[2]);
    }

    private static HashMap<String, Object> saveSpawnable(TimedSpawn ts) {
        HashMap<String, Object> spawnMap = new HashMap<String, Object>();
        SpawnInstance si = ts.getSpawn();
        String key = null;
        String value = null;
        if (si instanceof SpawnGroup) {
            SpawnGroup in = (SpawnGroup)si;
            key = in.getName();
            value = "1";
        } else if (si instanceof ItemSpawn) {
            ItemSpawn in = (ItemSpawn)si;
            key = InventoryUtil.getItemString(in.getItemStack());
        } else if (si instanceof EntitySpawn) {
            EntitySpawn in = (EntitySpawn)si;
            key = in.getEntityString() + " " + in.getNumber();
        } else if (si instanceof ChestSpawn) {
            ChestSpawn bs = (ChestSpawn)si;
            key = bs.getMaterial().name();
            ItemStack[] items = bs.getItems();
            spawnMap.put("type", "chest");
            if (items != null) {
                spawnMap.put("items", ConfigSerializer.getItems(Arrays.asList(items)));
            }
        } else if (si instanceof BlockSpawn) {
            BlockSpawn bs = (BlockSpawn)si;
            spawnMap.put("type", "block");
            spawnMap.put("despawnMat", bs.getDespawnMaterial() != null ? bs.getDespawnMaterial().name() : "AIR");
            key = bs.getMaterial().name();
        }
        if (value == null) {
            spawnMap.put("spawn", key);
        } else {
            spawnMap.put("spawn", key + ":" + value);
        }
        spawnMap.put("loc", SerializerUtil.getLocString(si.getLocation()));
        spawnMap.put("time", ts.getFirstSpawnTime() + " " + ts.getRespawnTime() + " " + ts.getTimeToDespawn());
        return spawnMap;
    }

    static {
        configs = new HashMap();
    }
}

