/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.serializers;

import java.io.File;
import java.io.IOException;
import java.util.List;
import mc.alk.arena.serializers.FileConfig;
import mc.alk.arena.util.Log;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseConfig
implements FileConfig {
    FileConfiguration config;
    File file = null;

    @Override
    public int getInt(String node, int defaultValue) {
        return this.config.getInt(node, defaultValue);
    }

    @Override
    public boolean getBoolean(String node, boolean defaultValue) {
        return this.config.getBoolean(node, false);
    }

    @Override
    public double getDouble(String node, double defaultValue) {
        return this.config.getDouble(node, defaultValue);
    }

    @Override
    public String getString(String node, String defaultValue) {
        return this.config.getString(node, defaultValue);
    }

    public ConfigurationSection getConfigurationSection(String node) {
        return this.config.getConfigurationSection(node);
    }

    public BaseConfig() {
    }

    public BaseConfig(File file) {
        this.setConfig(file);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public File getFile() {
        return this.file;
    }

    public boolean setConfig(String file) {
        return this.setConfig(new File(file));
    }

    public boolean setConfig(File file) {
        this.file = file;
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    Log.err("Couldn't create the config file=" + file);
                    return false;
                }
            }
            catch (IOException e) {
                Log.err("Couldn't create the config file=" + file);
                Log.printStackTrace(e);
                return false;
            }
        }
        this.config = new YamlConfiguration();
        try {
            this.config.load(file);
        }
        catch (Exception e) {
            Log.err("Couldn't load the config file=" + file);
            Log.printStackTrace(e);
            return false;
        }
        return true;
    }

    public void reloadFile() {
        try {
            this.config.load(this.file);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void save() {
        if (this.config == null) {
            return;
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            Log.printStackTrace(e);
        }
    }

    @Override
    public List<String> getStringList(String node) {
        return this.config.getStringList(node);
    }

    @Override
    public void load(File file) {
        this.file = file;
        this.reloadFile();
    }
}

