/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.serializers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.ArenaClassController;
import mc.alk.arena.controllers.ModuleController;
import mc.alk.arena.controllers.OptionSetController;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.controllers.StateController;
import mc.alk.arena.controllers.plugins.TrackerController;
import mc.alk.arena.objects.ArenaClass;
import mc.alk.arena.objects.ArenaParams;
import mc.alk.arena.objects.ArenaSize;
import mc.alk.arena.objects.CommandLineString;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.JoinType;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.StateGraph;
import mc.alk.arena.objects.StateOption;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.arenas.ArenaType;
import mc.alk.arena.objects.exceptions.ConfigException;
import mc.alk.arena.objects.exceptions.InvalidOptionException;
import mc.alk.arena.objects.messaging.AnnouncementOptions;
import mc.alk.arena.objects.modules.ArenaModule;
import mc.alk.arena.objects.modules.BrokenArenaModule;
import mc.alk.arena.objects.options.StateOptions;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.objects.victoryconditions.OneTeamLeft;
import mc.alk.arena.objects.victoryconditions.VictoryType;
import mc.alk.arena.serializers.BAConfigSerializer;
import mc.alk.arena.serializers.BaseConfig;
import mc.alk.arena.serializers.PlayerContainerSerializer;
import mc.alk.arena.util.BTInterface;
import mc.alk.arena.util.EffectUtil;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MinMax;
import mc.alk.arena.util.SerializerUtil;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigSerializer
extends BaseConfig {
    final Plugin plugin;
    final String name;

    public ConfigSerializer(Plugin plugin, File configFile, String name) {
        this.setConfig(configFile);
        this.name = name;
        this.plugin = plugin;
    }

    public MatchParams loadMatchParams() throws ConfigException, InvalidOptionException {
        return ConfigSerializer.loadMatchParams(this.plugin, this, this.name);
    }

    public static MatchParams loadMatchParams(Plugin plugin, BaseConfig config, String name) throws ConfigException, InvalidOptionException {
        ArenaType at;
        FileConfiguration cs = config.getConfig();
        if (config.getConfigurationSection(name) != null) {
            cs = config.getConfigurationSection(name);
        }
        if ((at = ConfigSerializer.getArenaType((ConfigurationSection)cs)) == null && !name.equalsIgnoreCase("tourney")) {
            throw new ConfigException("Could not parse arena type. Valid types. " + ArenaType.getValidList());
        }
        return ConfigSerializer.loadMatchParams(plugin, at, name, (ConfigurationSection)cs);
    }

    public static MatchParams loadMatchParams(Plugin plugin, ArenaType at, String name, ConfigurationSection cs) throws ConfigException, InvalidOptionException {
        return ConfigSerializer.loadMatchParams(plugin, at, name, cs, false);
    }

    public static MatchParams loadMatchParams(Plugin plugin, ArenaType at, String name, ConfigurationSection cs, boolean isNonBaseConfig) throws ConfigException, InvalidOptionException {
        ConfigurationSection teamcs;
        Set teamKeys;
        MatchParams mp;
        MatchParams matchParams = mp = at != null ? new MatchParams(at) : new MatchParams();
        if (!isNonBaseConfig || cs.contains("victoryCondition")) {
            mp.setVictoryType(ConfigSerializer.loadVictoryType(cs));
        }
        if (!isNonBaseConfig) {
            mp.setName(name);
            mp.setCommand(cs.getString("command", name));
            if (cs.contains("cmd")) {
                mp.setCommand(cs.getString("cmd"));
            }
        }
        ConfigSerializer.loadGameSize(cs, mp, isNonBaseConfig);
        if (cs.contains("prefix")) {
            mp.setPrefix(cs.getString("prefix", "&6[" + name + "]"));
        }
        if (cs.contains("displayName")) {
            mp.setDisplayName(cs.getString("displayName"));
        }
        if (cs.contains("signDisplayName")) {
            mp.setSignDisplayName(cs.getString("signDisplayName"));
        }
        ConfigSerializer.loadTimes(cs, mp);
        if (!isNonBaseConfig || cs.contains("nLives")) {
            mp.setNLives(ConfigSerializer.toPositiveSize(cs.getString("nLives"), 1));
        }
        ConfigSerializer.loadBTOptions(cs, mp, isNonBaseConfig);
        if (cs.contains("nConcurrentCompetitions")) {
            mp.setNConcurrentCompetitions(ArenaSize.toInt(cs.getString("nConcurrentCompetitions", "infinite")));
        }
        if (cs.contains("waitroomClosedWhileRunning")) {
            mp.setWaitroomClosedWhileRunning(cs.getBoolean("waitroomClosedWhileRunning", true));
        }
        if (cs.contains("cancelIfNotEnoughPlayers")) {
            mp.setCancelIfNotEnoughPlayers(cs.getBoolean("cancelIfNotEnoughPlayers", false));
        }
        if (cs.contains("arenaCooldown")) {
            mp.setArenaCooldown(cs.getInt("arenaCooldown"));
        }
        if (cs.contains("allowedTeamSizeDifference")) {
            mp.setAllowedTeamSizeDifference(cs.getInt("allowedTeamSizeDifference"));
        }
        if (cs.contains("forceStartTime")) {
            mp.setForceStartTime(cs.getInt("forceStartTime"));
        }
        if (cs.contains("teamParams") && (teamKeys = (teamcs = cs.getConfigurationSection("teamParams")).getKeys(false)) != null) {
            HashMap<Integer, MatchParams> teamParams = new HashMap<Integer, MatchParams>();
            for (String s : teamKeys) {
                try {
                    Integer index = Integer.valueOf(s.substring(4)) - 1;
                    MatchParams p = ConfigSerializer.loadMatchParams(plugin, null, s, teamcs.getConfigurationSection(s), true);
                    p.setParent(mp);
                    teamParams.put(index, p);
                }
                catch (Exception e) {
                    Log.warn("team index " + s + " not found");
                }
            }
            if (!teamParams.isEmpty()) {
                mp.setTeamParams(teamParams);
            }
        }
        ConfigSerializer.loadAnnouncementsOptions(cs, mp);
        List<String> modules = ConfigSerializer.loadModules(cs, mp);
        StateGraph tops = ConfigSerializer.loadTransitionOptions(cs, mp);
        mp.setStateGraph(tops);
        mp.setParent(ParamController.getDefaultConfig());
        if (!isNonBaseConfig) {
            ParamController.removeMatchType(mp);
            ParamController.addMatchParams(mp);
        }
        try {
            PlayerContainerSerializer pcs = new PlayerContainerSerializer();
            pcs.setConfig(BattleArena.getSelf().getDataFolder() + "/saves/containers.yml");
            pcs.load(mp);
        }
        catch (Exception e) {
            Log.err("Error loading Player Containers");
        }
        if (!isNonBaseConfig) {
            // empty if block
        }
        return mp;
    }

    public static VictoryType loadVictoryType(ConfigurationSection cs) throws ConfigException {
        VictoryType vt = cs.contains("victoryCondition") ? VictoryType.fromString(cs.getString("victoryCondition")) : VictoryType.getType(OneTeamLeft.class);
        if (vt == null) {
            throw new ConfigException("Could not add the victoryCondition " + cs.getString("victoryCondition") + "\n" + "valid types are " + VictoryType.getValidList());
        }
        return vt;
    }

    private static StateGraph loadTransitionOptions(ConfigurationSection cs, MatchParams mp) throws InvalidOptionException {
        StateGraph allTops = new StateGraph();
        boolean found = false;
        for (CompetitionState cstate : StateController.values()) {
            StateOptions tops;
            block20: {
                if (cstate == MatchState.ONCANCEL) continue;
                try {
                    tops = ConfigSerializer.getTransitionOptions(cs.getConfigurationSection(cstate.toString()));
                    if (tops == null && cstate == MatchState.ONPRESTART) {
                        tops = ConfigSerializer.getTransitionOptions(cs.getConfigurationSection("onPrestart"));
                    } else if (tops == null && cstate == MatchState.WINNERS) {
                        tops = ConfigSerializer.getTransitionOptions(cs.getConfigurationSection("winner"));
                    }
                    StateOptions prevOptions = allTops.getOptions(cstate);
                    if (prevOptions == null) break block20;
                    if (tops == null) {
                        tops = prevOptions;
                    } else {
                        tops.addOptions(prevOptions.getOptions());
                    }
                }
                catch (Exception e) {
                    Log.err("Invalid Option was not added!!! transition= " + cstate);
                    Log.printStackTrace(e);
                    continue;
                }
            }
            if (tops == null) {
                allTops.removeStateOptions(cstate);
                continue;
            }
            found = true;
            if (cstate == MatchState.ONCOMPLETE) {
                if (allTops.hasOptionAt(MatchState.ONLEAVE, TransitionOption.CLEARINVENTORY)) {
                    tops.addOption(TransitionOption.CLEARINVENTORY);
                }
                StateOptions cancelOps = new StateOptions(tops);
                allTops.addStateOptions(MatchState.ONCANCEL, cancelOps);
            } else if (cstate == MatchState.ONLEAVE) {
                if (tops.hasOption(TransitionOption.TELEPORTOUT)) {
                    tops.removeOption(TransitionOption.TELEPORTOUT);
                    Log.warn("You should never use the option teleportOut inside of onLeave!");
                }
            } else if (cstate == MatchState.DEFAULTS && cs.getBoolean("duelOnly", false)) {
                tops.addOption(TransitionOption.DUELONLY);
            }
            ConfigSerializer.splitOptions(allTops, cstate, tops);
            allTops.addStateOptions(cstate, tops);
        }
        if (allTops.hasOptionAt(MatchState.DEFAULTS, TransitionOption.ALWAYSOPEN)) {
            allTops.addStateOption(MatchState.ONJOIN, TransitionOption.ALWAYSJOIN);
        }
        if (mp.hasOptionAt((CompetitionState)MatchState.ONSPAWN, TransitionOption.RESPAWN) && !cs.contains("nLives")) {
            mp.setNLives(Integer.MAX_VALUE);
        }
        if (mp.getNLives() != null && mp.getNLives() > 1) {
            allTops.addStateOption(MatchState.ONDEATH, TransitionOption.RESPAWN);
        }
        if (!found && allTops.getAllOptions().isEmpty()) {
            return null;
        }
        return allTops;
    }

    private static void splitOptions(StateGraph allTops, CompetitionState state, StateOptions tops) {
        if (!(state instanceof MatchState) || state != MatchState.ONOPEN && state != MatchState.ONPRESTART && state != MatchState.ONSTART && state != MatchState.ONVICTORY) {
            return;
        }
        MatchState other = null;
        ArrayList<StateOption> add = new ArrayList<StateOption>();
        for (StateOption op : tops.getOptions().keySet()) {
            MatchState o = ((MatchState)state).getCorrectState(op);
            if (o.equals(state)) continue;
            if (other == null) {
                other = o;
            }
            add.add(op);
        }
        if (!add.isEmpty()) {
            StateOptions newTops = new StateOptions();
            for (StateOption op : add) {
                Object o = tops.removeOption(op);
                try {
                    newTops.addOption(op, o);
                }
                catch (InvalidOptionException e) {
                    e.printStackTrace();
                }
            }
            allTops.addStateOptions(other, newTops);
        }
    }

    private static void loadAnnouncementsOptions(ConfigurationSection cs, MatchParams mp) {
        if (cs.contains("announcements")) {
            AnnouncementOptions an = new AnnouncementOptions();
            BAConfigSerializer.parseAnnouncementOptions(an, true, cs.getConfigurationSection("announcements"), false);
            BAConfigSerializer.parseAnnouncementOptions(an, false, cs.getConfigurationSection("eventAnnouncements"), false);
            mp.setAnnouncementOptions(an);
        }
    }

    private static List<String> loadModules(ConfigurationSection cs, MatchParams mp) {
        List keys;
        ArrayList<String> modules = new ArrayList<String>();
        if (cs.contains("modules") && (keys = cs.getList("modules")) != null) {
            for (Object key : keys) {
                ArenaModule am = ModuleController.getModule(key.toString());
                if (am == null) {
                    Log.err("Module " + key + " not found!");
                    mp.addModule(new BrokenArenaModule(key.toString()));
                    continue;
                }
                mp.addModule(am);
                modules.add(am.getName());
            }
        }
        return modules;
    }

    private static void loadBTOptions(ConfigurationSection cs, MatchParams mp, boolean isNonBaseConfig) throws ConfigException {
        String dbName;
        if (cs.contains("tracking")) {
            cs = cs.getConfigurationSection("tracking");
        }
        String string = dbName = cs.contains("database") ? cs.getString("database", null) : cs.getString("db", null);
        if (dbName == null) {
            dbName = cs.getString("dbTableName", null);
        }
        if (dbName != null) {
            mp.setTableName(dbName);
            if (TrackerController.enabled()) {
                try {
                    if (!BTInterface.addBTI(mp)) {
                        Log.err("Couldn't add tracker interface");
                    }
                }
                catch (Exception e) {
                    Log.err("Couldn't add tracker interface");
                }
            }
        }
        if (cs.contains("overrideBattleTracker")) {
            mp.setUseTrackerPvP(cs.getBoolean("overrideBattleTracker", true));
        } else {
            mp.setUseTrackerPvP(cs.getBoolean("useTrackerPvP", false));
        }
        if (!isNonBaseConfig || cs.contains("useTrackerMessages")) {
            mp.setUseTrackerMessages(cs.getBoolean("useTrackerMessages", false));
        }
        if (cs.contains("teamRating")) {
            mp.setTeamRating(cs.getBoolean("teamRating", false));
        }
        if (cs.contains("rated")) {
            mp.setRated(cs.getBoolean("rated", true));
        }
    }

    private static void loadGameSize(ConfigurationSection cs, MatchParams mp, boolean isArena) {
        if (cs.contains("gameSize") || isArena) {
            cs = cs.getConfigurationSection("gameSize");
        }
        if (!isArena || cs != null && cs.contains("teamSize")) {
            mp.setTeamSize(MinMax.valueOf(cs.getString("teamSize", "1+")));
        }
        if (!isArena || cs != null && cs.contains("nTeams")) {
            mp.setNTeams(MinMax.valueOf(cs.getString("nTeams", "2+")));
        }
    }

    private static void loadTimes(ConfigurationSection cs, MatchParams mp) {
        if (cs.contains("times")) {
            cs = cs.getConfigurationSection("times");
        }
        if (cs == null) {
            return;
        }
        if (cs.contains("timeBetweenRounds")) {
            mp.setTimeBetweenRounds(cs.getInt("timeBetweenRounds", 15));
        }
        if (cs.contains("secondsToLoot")) {
            mp.setSecondsToLoot(cs.getInt("secondsToLoot", Defaults.SECONDS_TO_LOOT));
        }
        if (cs.contains("secondsTillMatch")) {
            mp.setSecondsTillMatch(cs.getInt("secondsTillMatch", Defaults.SECONDS_TILL_MATCH));
        }
        if (cs.contains("matchTime")) {
            mp.setMatchTime(ConfigSerializer.toPositiveSize(cs.getString("matchTime"), Defaults.MATCH_TIME));
        }
        if (cs.contains("matchUpdateInterval")) {
            mp.setIntervalTime(cs.getInt("matchUpdateInterval", Defaults.MATCH_UPDATE_INTERVAL));
        }
    }

    public static int toPositiveSize(String value, int defValue) {
        int s = ArenaSize.toInt(value, defValue);
        return s <= 0 ? defValue : s;
    }

    public static int toNonNegativeSize(String value, int defValue) {
        int s = ArenaSize.toInt(value, defValue);
        return s < 0 ? defValue : s;
    }

    public static int toSize(String value, int defValue) {
        return ArenaSize.toInt(value, defValue);
    }

    public static ArenaType getArenaType(ConfigurationSection cs) throws ConfigException {
        ArenaType at = ArenaType.fromString(cs.getName());
        return at;
    }

    public static Class<? extends Arena> getArenaClass(ConfigurationSection cs) throws ConfigException {
        ArenaType at;
        String type = null;
        if ((cs.contains("arenaType") || cs.contains("type") || cs.contains("arenaClass")) && (type = cs.getString("arenaClass")) == null) {
            String string = type = cs.contains("type") ? cs.getString("type") : cs.getString("arenaType");
        }
        if (type != null && (at = ArenaType.fromString(type)) != null) {
            return ArenaType.getArenaClass(at);
        }
        return null;
    }

    public static ArenaType getArenaGameType(ConfigurationSection cs) throws ConfigException {
        String s;
        ArenaType at = null;
        if (cs.contains("gameType") && (at = ArenaType.fromString(s = cs.getString("gameType"))) == null) {
            at = ConfigSerializer.getArenaType(cs);
        }
        return at;
    }

    public static StateOptions getTransitionOptions(ConfigurationSection cs) throws InvalidOptionException, IllegalArgumentException {
        ArrayList<ItemStack> items;
        if (cs == null) {
            return null;
        }
        HashMap<StateOption, Object> options = new HashMap<StateOption, Object>();
        StateOptions tops = new StateOptions();
        if (cs.contains("options")) {
            if (!cs.isList("options")) {
                throw new InvalidOptionException("options: should be a list, instead it was '" + cs.getString("options", null) + "'");
            }
            List optionsstr = cs.getStringList("options");
            for (String obj : optionsstr) {
                Object ovalue;
                TransitionOption to;
                String[] split = obj.split("=");
                String key = split[0].trim().toUpperCase();
                String value = split.length > 1 ? split[1].trim() : null;
                StateOptions optionSet = OptionSetController.getOptionSet(key);
                if (optionSet != null) {
                    tops.addOptions(optionSet);
                    continue;
                }
                try {
                    to = TransitionOption.fromString(key);
                    if (to == TransitionOption.ENCHANTS) continue;
                    if (to.hasValue() && value == null) {
                        Log.err("Transition Option " + to + " needs a value! " + key + "=<value>");
                        continue;
                    }
                    ovalue = to.parseValue(value);
                }
                catch (Exception e) {
                    Log.err("Couldn't parse Option " + key + " value=" + value);
                    continue;
                }
                options.put(to, ovalue);
            }
        }
        if (!options.isEmpty()) {
            tops.addOptions(options);
        }
        try {
            if (cs.contains("teleportTo")) {
                tops.addOption(TransitionOption.TELEPORTTO, SerializerUtil.getLocation(cs.getString("teleportTo")));
            }
        }
        catch (Exception e) {
            Log.err("Error setting the value of teleportTo ");
            Log.printStackTrace(e);
        }
        try {
            if (cs.contains("giveClass")) {
                tops.addOption(TransitionOption.GIVECLASS, ConfigSerializer.getArenaClasses(cs.getConfigurationSection("giveClass")));
            }
        }
        catch (Exception e) {
            Log.err("Error setting the value of giveClass ");
            Log.printStackTrace(e);
        }
        try {
            if (cs.contains("giveDisguise")) {
                tops.addOption(TransitionOption.GIVEDISGUISE, ConfigSerializer.getArenaDisguises(cs.getConfigurationSection("giveDisguise")));
            }
        }
        catch (Exception e) {
            Log.err("Error setting the value of giveDisguise ");
            Log.printStackTrace(e);
        }
        try {
            if (cs.contains("doCommands")) {
                tops.addOption(TransitionOption.DOCOMMANDS, ConfigSerializer.getDoCommands(cs.getStringList("doCommands")));
            }
        }
        catch (Exception e) {
            Log.err("Error setting the value of doCommands ");
            Log.printStackTrace(e);
        }
        try {
            items = InventoryUtil.getItemList(cs, "needItems");
            if (items == null && options.containsKey(TransitionOption.NEEDITEMS)) {
                items = InventoryUtil.getItemList(cs, "items");
                if (items != null && !items.isEmpty()) {
                    tops.addOption(TransitionOption.NEEDITEMS, items);
                } else {
                    options.remove(TransitionOption.NEEDITEMS);
                }
            } else if (items != null && !items.isEmpty()) {
                tops.addOption(TransitionOption.NEEDITEMS, items);
            } else {
                options.remove(TransitionOption.NEEDITEMS);
            }
        }
        catch (Exception e) {
            Log.err("Error setting the value of needItems ");
            Log.printStackTrace(e);
        }
        try {
            items = InventoryUtil.getItemList(cs, "giveItems");
            if (items == null) {
                items = InventoryUtil.getItemList(cs, "items");
            }
            if (items != null && !items.isEmpty()) {
                tops.addOption(TransitionOption.GIVEITEMS, items);
            } else {
                options.remove(TransitionOption.GIVEITEMS);
            }
        }
        catch (Exception e) {
            Log.err("Error setting the value of giveItems ");
            Log.printStackTrace(e);
        }
        try {
            items = InventoryUtil.getItemList(cs, "takeItems");
            if (items != null && !items.isEmpty()) {
                tops.addOption(TransitionOption.TAKEITEMS, items);
            } else {
                options.remove(TransitionOption.TAKEITEMS);
            }
        }
        catch (Exception e) {
            Log.err("Error setting the value of takeItems ");
            Log.printStackTrace(e);
        }
        try {
            List<PotionEffect> effects = ConfigSerializer.getEffectList(cs, "enchants");
            if (effects != null && !effects.isEmpty()) {
                tops.addOption(TransitionOption.ENCHANTS, effects);
            } else {
                options.remove(TransitionOption.ENCHANTS);
            }
        }
        catch (Exception e) {
            Log.err("Error setting the value of enchants ");
            Log.printStackTrace(e);
        }
        ConfigSerializer.setPermissionSection(cs, "addPerms", tops);
        return tops.getOptions() == null || tops.getOptions().isEmpty() ? null : tops;
    }

    public static List<CommandLineString> getDoCommands(List<String> list) throws InvalidOptionException {
        ArrayList<CommandLineString> commands = new ArrayList<CommandLineString>();
        for (String line : list) {
            CommandLineString cls = CommandLineString.parse(line);
            commands.add(cls);
        }
        return commands;
    }

    private static void setPermissionSection(ConfigurationSection cs, String nodeString, StateOptions tops) throws InvalidOptionException {
        if (cs == null || !cs.contains(nodeString)) {
            return;
        }
        List olist = cs.getList(nodeString);
        ArrayList<String> permlist = new ArrayList<String>();
        for (Object perm : olist) {
            permlist.add(perm.toString());
        }
        if (permlist.isEmpty()) {
            return;
        }
        tops.addOption(TransitionOption.ADDPERMS, permlist);
    }

    public static HashMap<Integer, ArenaClass> getArenaClasses(ConfigurationSection cs) {
        HashMap<Integer, ArenaClass> classes = new HashMap<Integer, ArenaClass>();
        Set keys = cs.getKeys(false);
        for (String whichTeam : keys) {
            int team;
            String className = cs.getString(whichTeam);
            ArenaClass ac = ArenaClassController.getClass(className);
            if (whichTeam.equalsIgnoreCase("default")) {
                team = ArenaClass.DEFAULT;
            } else {
                try {
                    team = Integer.valueOf(whichTeam.replaceAll("team", "")) - 1;
                }
                catch (Exception e) {
                    Log.err("Couldn't find which team this class belongs to '" + whichTeam + "'");
                    continue;
                }
            }
            if (team == -1) {
                Log.err("Couldn't find which team this class belongs to '" + whichTeam + "'");
                continue;
            }
            if (ac == null) {
                Log.err("Couldn't find arenaClass " + className);
                ac = new ArenaClass(className);
            }
            classes.put(team, ac);
        }
        return classes;
    }

    public static HashMap<Integer, String> getArenaDisguises(ConfigurationSection cs) {
        HashMap<Integer, String> disguises = new HashMap<Integer, String>();
        Set keys = cs.getKeys(false);
        for (String whichTeam : keys) {
            int team;
            String disguiseName = cs.getString(whichTeam);
            if (whichTeam.equalsIgnoreCase("default")) {
                team = Integer.MAX_VALUE;
            } else {
                try {
                    team = Integer.valueOf(whichTeam.replaceAll("team", "")) - 1;
                }
                catch (Exception e) {
                    Log.err("Couldnt find which team this disguise belongs to '" + whichTeam + "'");
                    continue;
                }
            }
            if (team == -1) {
                Log.err("Couldnt find which team this disguise belongs to '" + whichTeam + "'");
                continue;
            }
            disguises.put(team, disguiseName);
        }
        return disguises;
    }

    public static List<PotionEffect> getEffectList(ConfigurationSection cs, String nodeString) {
        if (cs == null || cs.getList(nodeString) == null) {
            return null;
        }
        boolean strengthDefault = false;
        int timeDefault = 60;
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        try {
            for (Object o : cs.getList(nodeString)) {
                String str = o.toString();
                try {
                    PotionEffect ewa = EffectUtil.parseArg(str, 0, 60);
                    effects.add(ewa);
                }
                catch (Exception e) {
                    Log.err("Effect " + cs.getCurrentPath() + "." + nodeString + "." + str + " could not be parsed in classes.yml. " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            Log.err("Effect " + cs.getCurrentPath() + "." + nodeString + " could not be parsed in classes.yml");
        }
        return effects;
    }

    public static JoinType getJoinType(ConfigurationSection cs) {
        if (cs == null || cs.getName() == null) {
            return null;
        }
        if (cs.getName().equalsIgnoreCase("Tourney")) {
            return JoinType.JOINPHASE;
        }
        boolean isMatch = !cs.getBoolean("isEvent", false);
        isMatch = cs.getBoolean("queue", isMatch);
        if (cs.contains("joinType")) {
            String type = cs.getString("joinType");
            try {
                return JoinType.fromString(type);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
        return isMatch ? JoinType.QUEUE : JoinType.JOINPHASE;
    }

    public void save(MatchParams params) {
        ConfigurationSection main = this.config.createSection(params.getName());
        ConfigSerializer.saveParams(params, main, false);
        super.save();
    }

    public static void saveParams(MatchParams params, ConfigurationSection maincs, boolean isNonBaseConfig) {
        StateGraph alltops;
        AnnouncementOptions ao;
        Set<ArenaModule> modules;
        ConfigurationSection cs;
        ArenaParams parent = params.getParent();
        params.setParent(null);
        if (!isNonBaseConfig) {
            maincs.set("name", (Object)params.getName());
            maincs.set("command", (Object)params.getCommand());
        }
        if (params.getPrefix() != null) {
            maincs.set("prefix", (Object)params.getPrefix());
        }
        if (params.getThisDisplayName() != null) {
            maincs.set("displayName", (Object)params.getThisDisplayName());
        }
        if (params.getSignDisplayName() != null) {
            maincs.set("signDisplayName", (Object)params.getSignDisplayName());
        }
        if (params.getNTeams() != null || params.getTeamSize() != null) {
            cs = maincs.createSection("gameSize");
            if (params.getNTeams() != null) {
                cs.set("nTeams", (Object)params.getNTeams().toString());
            }
            if (params.getTeamSize() != null) {
                cs.set("teamSize", (Object)params.getTeamSize().toString());
            }
        }
        if (params.getNLives() != null) {
            maincs.set("nLives", (Object)ArenaSize.toString(params.getNLives()));
        }
        if (params.getVictoryType() != null) {
            maincs.set("victoryCondition", (Object)params.getVictoryType().getName());
        }
        if (params.getSecondsTillMatch() != null || params.getMatchTime() != null || params.getSecondsToLoot() != null || params.getTimeBetweenRounds() != null || params.getIntervalTime() != null) {
            cs = maincs.createSection("times");
            if (params.getSecondsTillMatch() != null) {
                cs.set("secondsTillMatch", (Object)params.getSecondsTillMatch());
            }
            if (params.getMatchTime() != null) {
                cs.set("matchTime", (Object)params.getMatchTime());
            }
            if (params.getSecondsToLoot() != null) {
                cs.set("secondsToLoot", (Object)params.getSecondsToLoot());
            }
            if (params.getTimeBetweenRounds() != null) {
                cs.set("timeBetweenRounds", (Object)params.getTimeBetweenRounds());
            }
            if (params.getIntervalTime() != null) {
                cs.set("matchUpdateInterval", (Object)params.getIntervalTime());
            }
        }
        if (params.isRated() != null || params.getDBTableName() != null || params.getUseTrackerMessages() != null) {
            cs = maincs.createSection("tracking");
            if (params.getDBTableName() != null) {
                cs.set("dbTableName", (Object)params.getDBTableName());
            }
            if (params.isRated() != null) {
                cs.set("rated", (Object)params.isRated());
            }
            if (params.getUseTrackerMessages() != null) {
                cs.set("useTrackerMessages", (Object)params.getUseTrackerMessages());
            }
        }
        if (!isNonBaseConfig && params.getType() != null) {
            maincs.set("arenaType", (Object)params.getType().getName());
            try {
                maincs.set("arenaClass", (Object)ArenaType.getArenaClass(params.getType()).getSimpleName());
            }
            catch (Exception e) {
                maincs.set("arenaClass", (Object)params.getType().getClass().getSimpleName());
            }
        }
        if (params.getTeamParams() != null) {
            cs = maincs.createSection("teamParams");
            for (Map.Entry<Integer, MatchParams> entry : params.getTeamParams().entrySet()) {
                ConfigSerializer.saveParams(entry.getValue(), cs.createSection("team" + (entry.getKey() + 1)), false);
            }
        }
        if (params.getNConcurrentCompetitions() != null) {
            maincs.set("nConcurrentCompetitions", (Object)ArenaSize.toString(params.getNConcurrentCompetitions()));
        }
        if (params.isWaitroomClosedWhenRunning() != null) {
            maincs.set("waitroomClosedWhileRunning", (Object)params.isWaitroomClosedWhenRunning());
        }
        if (params.isCancelIfNotEnoughPlayers() != null) {
            maincs.set("cancelIfNotEnoughPlayers", (Object)params.isCancelIfNotEnoughPlayers());
        }
        if (params.getArenaCooldown() != null) {
            maincs.set("arenaCooldown", (Object)params.getArenaCooldown());
        }
        if (params.getAllowedTeamSizeDifference() != null) {
            maincs.set("allowedTeamSizeDifference", (Object)params.getAllowedTeamSizeDifference());
        }
        if (params.getForceStartTime() != null) {
            maincs.set("forceStartTime", (Object)params.getForceStartTime());
        }
        if ((modules = params.getModules()) != null && !modules.isEmpty()) {
            maincs.set("modules", ConfigSerializer.getModuleList(modules));
        }
        if ((ao = params.getAnnouncementOptions()) != null) {
            Map<MatchState, Map<AnnouncementOptions.AnnouncementOption, Object>> map = ao.getMatchOptions();
            if (map != null) {
                ConfigurationSection cs2 = maincs.createSection("announcements");
                for (Map.Entry<MatchState, Map<AnnouncementOptions.AnnouncementOption, Object>> entry : map.entrySet()) {
                    ArrayList<String> ops = new ArrayList<String>();
                    for (Map.Entry<AnnouncementOptions.AnnouncementOption, Object> entry2 : entry.getValue().entrySet()) {
                        Object o = entry2.getValue();
                        ops.add((Object)((Object)entry2.getKey()) + (o != null ? o.toString() : ""));
                    }
                    cs2.set(entry.getKey().name(), ops);
                }
            }
            if ((map = ao.getEventOptions()) != null) {
                for (Map.Entry<MatchState, Map<AnnouncementOptions.AnnouncementOption, Object>> entry : map.entrySet()) {
                    ArrayList<String> ops = new ArrayList<String>();
                    for (Map.Entry<AnnouncementOptions.AnnouncementOption, Object> entry2 : entry.getValue().entrySet()) {
                        Object o = entry2.getValue();
                        ops.add((Object)((Object)entry2.getKey()) + (o != null ? o.toString() : ""));
                    }
                    if (ops.isEmpty()) continue;
                    ConfigurationSection cs3 = maincs.createSection("eventAnnouncements");
                    cs3.set(entry.getKey().name(), ops);
                }
            }
        }
        if ((alltops = params.getThisStateGraph()) != null) {
            TreeMap<CompetitionState, StateOptions> transitions = new TreeMap<CompetitionState, StateOptions>(new Comparator<CompetitionState>(){

                @Override
                public int compare(CompetitionState o1, CompetitionState o2) {
                    return o1.globalOrdinal() - o2.globalOrdinal();
                }
            });
            transitions.putAll(alltops.getAllOptions());
            for (CompetitionState ms : transitions.keySet()) {
                try {
                    StateOptions tops;
                    if (ms == MatchState.ONCANCEL || (tops = (StateOptions)transitions.get(ms)) == null || tops.getOptions() == null) continue;
                    tops = new StateOptions(tops);
                    TreeMap<StateOption, Object> ops = new TreeMap<StateOption, Object>(tops.getOptions());
                    ArrayList<String> list = new ArrayList<String>();
                    for (Map.Entry<String, StateOptions> entry : OptionSetController.getOptionSets().entrySet()) {
                        if (!tops.containsAll(entry.getValue())) continue;
                        list.add(entry.getKey());
                        for (StateOption op : entry.getValue().getOptions().keySet()) {
                            ops.remove(op);
                        }
                    }
                    LinkedHashMap<String, Object> tmap = new LinkedHashMap<String, Object>();
                    ops = new TreeMap<StateOption, Object>((Map<StateOption, Object>)ops);
                    for (StateOption to : ops.keySet()) {
                        try {
                            if (to.equals(TransitionOption.NEEDITEMS)) {
                                tmap.put(to.toString(), ConfigSerializer.getItems(tops.getNeedItems()));
                                continue;
                            }
                            if (to.equals(TransitionOption.GIVEITEMS)) {
                                tmap.put(to.toString(), ConfigSerializer.getItems(tops.getGiveItems()));
                                continue;
                            }
                            if (to.equals(TransitionOption.TAKEITEMS)) {
                                tmap.put(to.toString(), ConfigSerializer.getItems(tops.getTakeItems()));
                                continue;
                            }
                            if (to.equals(TransitionOption.GIVECLASS)) {
                                tmap.put(to.toString(), ConfigSerializer.getArenaClasses(tops.getClasses()));
                                continue;
                            }
                            if (to.equals(TransitionOption.ENCHANTS)) {
                                tmap.put(to.toString(), ConfigSerializer.getEnchants(tops.getEffects()));
                                continue;
                            }
                            if (to.equals(TransitionOption.DOCOMMANDS)) {
                                tmap.put(to.toString(), ConfigSerializer.getDoCommandsStringList(tops.getDoCommands()));
                                continue;
                            }
                            if (to.equals(TransitionOption.TELEPORTTO)) {
                                tmap.put(to.toString(), SerializerUtil.getLocString(tops.getTeleportToLoc()));
                                continue;
                            }
                            Object value = ops.get(to);
                            String s = value == null ? to.toString() : to.toString() + "=" + value.toString();
                            list.add(s);
                        }
                        catch (Exception e) {
                            Log.err("[BA Error] couldn't save " + to);
                            Log.printStackTrace(e);
                        }
                    }
                    tmap.put("options", list);
                    maincs.set(ms.toString(), tmap);
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            }
        }
        params.setParent(parent);
    }

    public static List<String> getModuleList(Collection<ArenaModule> modules) {
        ArrayList<String> list = new ArrayList<String>();
        if (modules != null) {
            for (ArenaModule m : modules) {
                list.add(m.getName());
            }
        }
        return list;
    }

    public static List<String> getEnchants(List<PotionEffect> effects) {
        ArrayList<String> list = new ArrayList<String>();
        if (effects != null) {
            for (PotionEffect is : effects) {
                list.add(EffectUtil.getEnchantString(is));
            }
        }
        return list;
    }

    public static List<String> getItems(List<ItemStack> items) {
        ArrayList<String> list = new ArrayList<String>();
        if (items != null) {
            for (ItemStack is : items) {
                if (is == null) continue;
                list.add(InventoryUtil.getItemString(is));
            }
        }
        return list;
    }

    public static Map<String, Object> getArenaClasses(Map<Integer, ArenaClass> classes) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Integer teamNumber : classes.keySet()) {
            String teamName = teamNumber.intValue() == ArenaClass.DEFAULT.intValue() ? "default" : "team" + teamNumber;
            map.put(teamName, classes.get(teamNumber).getName());
        }
        return map;
    }

    public static List<String> getDoCommandsStringList(List<CommandLineString> doCommands) {
        ArrayList<String> list = new ArrayList<String>();
        if (doCommands != null) {
            for (CommandLineString s : doCommands) {
                list.add(s.getRawCommand());
            }
        }
        return list;
    }
}

