/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.serializers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.EventScheduler;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.pairs.EventPair;
import mc.alk.arena.serializers.BaseConfig;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.SerializerUtil;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;

public class EventScheduleSerializer
extends BaseConfig {
    EventScheduler es;

    public void loadAll() {
        try {
            this.config.load(this.file);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        this.loadScheduledEvents(this.config.getConfigurationSection("events"));
    }

    public void loadScheduledEvents(ConfigurationSection cs) {
        if (cs == null) {
            Log.info(BattleArena.getPluginName() + " has no scheduled events");
            return;
        }
        ArrayList keys = new ArrayList(cs.getKeys(false));
        Collections.sort(keys);
        for (String key : keys) {
            String se = cs.getString(key);
            if (se == null) continue;
            String[] fullargs = se.split(" ");
            MatchParams eventParams = ParamController.getMatchParamCopy(fullargs[0]);
            if (eventParams == null) {
                Log.err(BattleArena.getPluginName() + " couldn't reparse the scheduled command " + fullargs[0]);
                continue;
            }
            String[] args = Arrays.copyOfRange(fullargs, 1, fullargs.length);
            this.es.scheduleEvent(eventParams, args);
        }
    }

    public void saveScheduledEvents() {
        if (this.es == null) {
            return;
        }
        List<EventPair> events = this.es.getEvents();
        if (events == null) {
            return;
        }
        int i = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (EventPair ep : events) {
            map.put(i++ + "", ep.getEventParams().getName() + " " + StringUtils.join((Object[])ep.getArgs(), (String)" "));
        }
        ConfigurationSection cs = this.config.createSection("events");
        SerializerUtil.expandMapIntoConfig(cs, map);
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            Log.printStackTrace(e);
        }
    }

    public void addScheduler(EventScheduler es) {
        this.es = es;
    }
}

