/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.serializers;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TimerTask;
import java.util.UUID;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.Scheduler;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.serializers.ArenaControllerSerializer;
import mc.alk.arena.serializers.BaseConfig;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.KeyValue;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.PlayerUtil;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InventorySerializer {
    public static List<String> getDates(OfflinePlayer player) {
        UUID id = PlayerUtil.getID(player);
        BaseConfig serializer = InventorySerializer.getSerializer(id);
        if (serializer == null) {
            return null;
        }
        PriorityQueue dates = new PriorityQueue(Defaults.NUM_INV_SAVES, Collections.reverseOrder());
        Set keys = serializer.config.getKeys(false);
        DateFormat format = DateFormat.getDateTimeInstance(1, 1);
        for (String key : keys) {
            Date date;
            ConfigurationSection cs = serializer.config.getConfigurationSection(key);
            if (cs == null) continue;
            String strdate = cs.getString("storedDate");
            try {
                date = format.parse(strdate);
            }
            catch (ParseException e) {
                Log.printStackTrace(e);
                continue;
            }
            dates.add(date.getTime());
        }
        ArrayList<String> strdates = new ArrayList<String>();
        for (Long l : dates) {
            strdates.add(format.format(l));
        }
        return strdates;
    }

    public static InventoryUtil.PInv getInventory(OfflinePlayer player, int index) {
        if (index < 0 || index >= Defaults.NUM_INV_SAVES) {
            return null;
        }
        UUID id = PlayerUtil.getID(player);
        BaseConfig serializer = InventorySerializer.getSerializer(id);
        if (serializer == null) {
            return null;
        }
        PriorityQueue<KeyValue<Long, InventoryUtil.PInv>> dates = new PriorityQueue<KeyValue<Long, InventoryUtil.PInv>>(Defaults.NUM_INV_SAVES, new Comparator<KeyValue<Long, InventoryUtil.PInv>>(){

            @Override
            public int compare(KeyValue<Long, InventoryUtil.PInv> arg0, KeyValue<Long, InventoryUtil.PInv> arg1) {
                return ((Long)arg1.key).compareTo((Long)arg0.key);
            }
        });
        Set keys = serializer.config.getKeys(false);
        DateFormat format = DateFormat.getDateTimeInstance(1, 1);
        for (String key : keys) {
            Date date;
            ConfigurationSection cs = serializer.config.getConfigurationSection(key);
            if (cs == null) continue;
            String strdate = cs.getString("storedDate");
            try {
                date = format.parse(strdate);
            }
            catch (ParseException e) {
                Log.printStackTrace(e);
                continue;
            }
            InventoryUtil.PInv pinv = ArenaControllerSerializer.getInventory(cs);
            dates.add(new KeyValue<Long, InventoryUtil.PInv>(date.getTime(), pinv));
        }
        int i = 0;
        for (KeyValue<Long, InventoryUtil.PInv> l : dates) {
            if (i++ != index) continue;
            return (InventoryUtil.PInv)l.value;
        }
        return null;
    }

    public static void saveInventory(final UUID id, final InventoryUtil.PInv pinv) {
        if (Defaults.NUM_INV_SAVES <= 0) {
            return;
        }
        Scheduler.scheduleAsynchronousTask(new TimerTask(){

            public void run() {
                BaseConfig serializer = InventorySerializer.getSerializer(id);
                if (serializer == null) {
                    return;
                }
                Date now = new Date();
                String date = DateFormat.getDateTimeInstance(1, 1).format(now);
                int curSection = serializer.config.getInt("curSection", 0);
                serializer.config.set("curSection", (Object)((curSection + 1) % Defaults.NUM_INV_SAVES));
                ConfigurationSection pcs = serializer.config.createSection(curSection + "");
                pcs.set("storedDate", (Object)date);
                ArrayList<String> stritems = new ArrayList<String>();
                for (ItemStack is : pinv.armor) {
                    if (is == null || is.getType() == Material.AIR) continue;
                    stritems.add(InventoryUtil.getItemString(is));
                }
                pcs.set("armor", stritems);
                stritems = new ArrayList();
                for (ItemStack is : pinv.contents) {
                    if (is == null || is.getType() == Material.AIR) continue;
                    stritems.add(InventoryUtil.getItemString(is));
                }
                pcs.set("contents", stritems);
                serializer.save();
            }
        }, 0L);
    }

    private static BaseConfig getSerializer(UUID id) {
        BaseConfig bs = new BaseConfig();
        File dir = new File(BattleArena.getSelf().getDataFolder() + "/saves/inventories/");
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bs.setConfig(dir.getPath() + "/" + id + ".yml") ? bs : null;
    }

    public static boolean giveInventory(ArenaPlayer player, Integer index, Player other) {
        InventoryUtil.PInv pinv = InventorySerializer.getInventory((OfflinePlayer)player.getPlayer(), index);
        if (pinv == null) {
            return false;
        }
        for (ItemStack is : pinv.armor) {
            InventoryUtil.addItemToInventory(other, is);
        }
        for (ItemStack is : pinv.contents) {
            InventoryUtil.addItemToInventory(other, is);
        }
        try {
            other.updateInventory();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

