/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.serializers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import mc.alk.arena.controllers.messaging.MessageFormatter;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.messaging.Channel;
import mc.alk.arena.objects.messaging.Channels;
import mc.alk.arena.objects.messaging.Message;
import mc.alk.arena.objects.messaging.MessageOptions;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.serializers.BaseConfig;
import org.bukkit.ChatColor;
import org.bukkit.configuration.MemorySection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageSerializer
extends BaseConfig {
    private static MessageSerializer defaultMessages;
    private HashMap<String, MessageOptions> msgOptions = new HashMap();
    private static final HashMap<String, MessageSerializer> files;
    protected final MatchParams mp;

    public MessageSerializer(String name, MatchParams params) {
        this.mp = params;
        if (name == null) {
            return;
        }
        MessageSerializer ms = files.get(name.toUpperCase());
        if (ms != null) {
            this.config = ms.config;
            this.file = ms.file;
            this.msgOptions = ms.msgOptions;
        }
    }

    public static void addMessageSerializer(String name, MessageSerializer ms) {
        files.put(name.toUpperCase(), ms);
    }

    public static MessageSerializer getMessageSerializer(String name) {
        return files.get(name.toUpperCase());
    }

    public void loadAll() {
        this.initMessageOptions();
    }

    public static void reloadConfig(String params) {
        MessageSerializer ms = files.get(params.toUpperCase());
        if (ms != null) {
            ms.reloadFile();
            ms.initMessageOptions();
        }
    }

    public void initMessageOptions() {
        if (this.config == null) {
            return;
        }
        this.msgOptions.clear();
        Set keys = this.config.getKeys(true);
        keys.remove("version");
        for (String key : keys) {
            Object obj = this.config.get(key);
            if (obj == null || obj instanceof MemorySection) continue;
            this.msgOptions.put(key, new MessageOptions(String.valueOf(obj)));
        }
    }

    public static Message getDefaultMessage(String path) {
        return defaultMessages != null ? defaultMessages.getNodeMessage(path) : null;
    }

    public Message getNodeMessage(String path) {
        if (this.config != null && this.config.contains(path)) {
            return new Message(this.config.getString(path), this.msgOptions.get(path));
        }
        if (this != defaultMessages) {
            return defaultMessages.getNodeMessage(path);
        }
        return null;
    }

    public String getNodeText(String path) {
        if (this.config != null && this.config.contains(path)) {
            return this.config.getString(path);
        }
        if (this != defaultMessages) {
            return defaultMessages.getNodeText(path);
        }
        return null;
    }

    private boolean contains(String path) {
        return this.config.contains(path);
    }

    public static boolean hasMessage(String prefix, String node) {
        return defaultMessages != null && defaultMessages.contains(prefix + "." + node);
    }

    public static void loadDefaults() {
        if (defaultMessages != null) {
            defaultMessages.reloadFile();
        }
    }

    public static void setDefaultConfig(MessageSerializer messageSerializer) {
        defaultMessages = messageSerializer;
    }

    public static String colorChat(String msg) {
        return msg.replace('&', 'w');
    }

    public static String decolorChat(String msg) {
        return msg.contains("\u00a7") || msg.contains("&") ? ChatColor.stripColor((String)msg).replaceAll("(&|\u00a7).", "") : msg;
    }

    protected static String getStringPathFromSize(int size) {
        if (size == 1) {
            return "oneTeam";
        }
        if (size == 2) {
            return "twoTeams";
        }
        return "multipleTeams";
    }

    protected void sendVictory(Channel serverChannel, Collection<ArenaTeam> victors, Collection<ArenaTeam> losers, MatchParams mp, String winnerpath, String loserpath, String serverPath) {
        String newmsg;
        ArenaTeam vic;
        int size = victors != null ? victors.size() : 0;
        size += losers != null ? losers.size() : 0;
        Message winnermessage = this.getNodeMessage(winnerpath);
        Message losermessage = this.getNodeMessage(loserpath);
        Message serverMessage = this.getNodeMessage(serverPath);
        Set<MessageOptions.MessageOption> ops = winnermessage.getOptions();
        if (ops == null) {
            ops = new HashSet<MessageOptions.MessageOption>();
        }
        ops.addAll(losermessage.getOptions());
        if (serverChannel != Channels.NullChannel && serverMessage != null) {
            ops.addAll(serverMessage.getOptions());
        }
        MessageFormatter msgf = new MessageFormatter(this, mp, size, losermessage, ops);
        ArrayList<Object> teams = losers != null ? new ArrayList<ArenaTeam>(losers) : new ArrayList();
        if (victors != null) {
            teams.addAll(victors);
        }
        msgf.formatCommonOptions(teams, mp.getSecondsToLoot());
        ArenaTeam arenaTeam = vic = victors != null && !victors.isEmpty() ? victors.iterator().next() : null;
        if (losers != null) {
            for (ArenaTeam t : losers) {
                msgf.formatTeamOptions(t, false);
                msgf.formatTwoTeamsOptions(t, teams);
                msgf.formatTeams(teams);
                msgf.formatWinnerOptions(t, false);
                if (vic != null) {
                    msgf.formatWinnerOptions(vic, true);
                }
                newmsg = msgf.getFormattedMessage(losermessage);
                t.sendMessage(newmsg);
            }
        }
        if (victors != null) {
            for (ArenaTeam victor : victors) {
                msgf = new MessageFormatter(this, mp, size, winnermessage, ops);
                msgf.formatCommonOptions(teams, mp.getSecondsToLoot());
                msgf.formatTeamOptions(victor, true);
                msgf.formatTwoTeamsOptions(victor, teams);
                msgf.formatTeams(teams);
                if (losers != null && !losers.isEmpty()) {
                    msgf.formatWinnerOptions(losers.iterator().next(), false);
                }
                msgf.formatWinnerOptions(victor, true);
                newmsg = msgf.getFormattedMessage(winnermessage);
                victor.sendMessage(newmsg);
            }
        }
        if (serverChannel != Channels.NullChannel && serverMessage != null) {
            String msg = msgf.getFormattedMessage(serverMessage);
            serverChannel.broadcast(msg);
        }
    }

    public void sendAddedToTeam(ArenaTeam team, ArenaPlayer player) {
        Message message = this.getNodeMessage("common.added_to_team");
        Set<MessageOptions.MessageOption> ops = message.getOptions();
        MessageFormatter msgf = new MessageFormatter(this, this.mp, 1, message, ops);
        msgf.formatTeamOptions(team, false);
        msgf.formatPlayerOptions(player);
        team.sendToOtherMembers(player, msgf.getFormattedMessage(message));
    }

    public void sendTeamJoinedEvent(Channel serverChannel, ArenaTeam team) {
        Message message = this.getNodeMessage("common.onjoin");
        Message serverMessage = this.getNodeMessage("common.onjoin_server");
        Set<MessageOptions.MessageOption> ops = message.getOptions();
        if (serverChannel != Channels.NullChannel) {
            ops.addAll(serverMessage.getOptions());
        }
        ArrayList<ArenaTeam> teams = new ArrayList<ArenaTeam>();
        teams.add(team);
        MessageFormatter msgf = new MessageFormatter(this, this.mp, teams.size(), message, ops);
        msgf.formatCommonOptions(teams);
        for (ArenaTeam t : teams) {
            msgf.formatTeamOptions(t, false);
            msgf.formatTeams(teams);
            String newmsg = msgf.getFormattedMessage(message);
            t.sendMessage(newmsg);
        }
        if (serverChannel != Channels.NullChannel) {
            String msg = msgf.getFormattedMessage(serverMessage);
            serverChannel.broadcast(msg);
        }
    }

    static {
        files = new HashMap();
    }
}

