/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.serializers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mc.alk.arena.controllers.RoomController;
import mc.alk.arena.controllers.containers.RoomContainer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.spawns.FixedLocation;
import mc.alk.arena.objects.spawns.SpawnLocation;
import mc.alk.arena.serializers.BaseConfig;
import mc.alk.arena.util.SerializerUtil;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;

public class PlayerContainerSerializer
extends BaseConfig {
    public void load(MatchParams params) {
        ConfigurationSection cs = this.config.getConfigurationSection("lobbies." + params.getType());
        if (cs != null) {
            List strlocs = cs.getStringList("spawns");
            if (strlocs == null || strlocs.isEmpty()) {
                return;
            }
            for (int i = 0; i < strlocs.size(); ++i) {
                Location l = SerializerUtil.getLocation((String)strlocs.get(i));
                RoomController.addLobby(params.getType(), i, 0, new FixedLocation(l));
            }
        }
    }

    public void save() {
        ConfigurationSection main = this.config.createSection("lobbies");
        for (RoomContainer roomContainer : RoomController.getLobbies()) {
            HashMap<String, Map<String, List<String>>> amap = new HashMap<String, Map<String, List<String>>>();
            List<List<SpawnLocation>> locs = roomContainer.getSpawns();
            if (locs != null) {
                Map<String, List<String>> strlocs = SerializerUtil.createSaveableLocations(SerializerUtil.toMap(locs));
                amap.put("spawns", strlocs);
            }
            main.set(roomContainer.getParams().getType().getName(), amap);
        }
        super.save();
    }
}

