/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.serializers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.SpawnController;
import mc.alk.arena.objects.options.SpawnOptions;
import mc.alk.arena.objects.spawns.EntitySpawn;
import mc.alk.arena.objects.spawns.ItemSpawn;
import mc.alk.arena.objects.spawns.SpawnGroup;
import mc.alk.arena.objects.spawns.SpawnInstance;
import mc.alk.arena.objects.spawns.TimedSpawn;
import mc.alk.arena.util.EntityUtil;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.Log;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpawnSerializer {
    public YamlConfiguration config = new YamlConfiguration();
    File f = new File(BattleArena.getSelf().getDataFolder() + "/spawns.yml");

    public void setConfig(File f) {
        this.f = f;
        this.config = new YamlConfiguration();
        this.loadAll();
    }

    public void loadAll() {
        try {
            this.config.load(this.f);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        ConfigurationSection as = this.config.getConfigurationSection("spawnGroups");
        if (as == null) {
            Log.info("spawn section is empty in config cs=" + this.config.getCurrentPath());
            return;
        }
        Set keys = as.getKeys(false);
        for (String key : keys) {
            SpawnGroup sg = SpawnSerializer.parseSpawnGroup(as.getConfigurationSection(key));
            if (sg == null) continue;
            SpawnController.registerSpawn(sg.getName(), sg);
        }
    }

    private static SpawnGroup parseSpawnGroup(ConfigurationSection cs) {
        if (cs == null) {
            return null;
        }
        ArrayList<SpawnInstance> spawns = SpawnSerializer.getSpawnList(cs);
        SpawnGroup sg = new SpawnGroup(cs.getName());
        sg.addSpawns(spawns);
        return sg;
    }

    public static ArrayList<SpawnInstance> getSpawnList(ConfigurationSection cs) {
        ArrayList<SpawnInstance> spawns = new ArrayList<SpawnInstance>();
        try {
            Set keys = cs.getKeys(false);
            for (String key : keys) {
                List<SpawnInstance> sis = SpawnSerializer.parseSpawnable(SpawnSerializer.convertToStringList(cs, key));
                if (sis == null) continue;
                for (SpawnInstance si : sis) {
                    spawns.add(si);
                }
            }
        }
        catch (Exception e) {
            Log.warn(cs.getCurrentPath() + " could not be parsed in config.yml");
            Log.printStackTrace(e);
        }
        return spawns;
    }

    public static List<String> convertToStringList(ConfigurationSection cs, String key) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(key);
        args.addAll(SpawnSerializer.convertToStringList(cs.getString(key)));
        return args;
    }

    public static List<String> convertToStringList(String str) {
        return new ArrayList<String>(Arrays.asList(str.split(" ")));
    }

    public static List<SpawnInstance> parseSpawnable(List<String> args) {
        String key = args.get(0);
        StringBuilder sb = new StringBuilder(key);
        ArrayList<SpawnInstance> spawns = new ArrayList<SpawnInstance>();
        for (int i = 1; i < args.size(); ++i) {
            sb.append(" ").append(args.get(i));
        }
        String value = sb.toString();
        try {
            SpawnInstance sg = SpawnController.getSpawnable(key);
            if (sg != null) {
                int number = 1;
                try {
                    number = Integer.parseInt(args.get(1));
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (int i = 0; i < number; ++i) {
                    spawns.add(sg);
                }
                return spawns;
            }
            int number = 1;
            try {
                number = Integer.parseInt(value);
            }
            catch (Exception e) {
                // empty catch block
            }
            ItemStack is = InventoryUtil.parseItem(value);
            EntityType et = EntityUtil.parseEntityType(key);
            if (is != null && et != null) {
                int esizedif;
                int keysize = key.length();
                int isizedif = Math.abs(is.getType().name().length() - keysize);
                if (isizedif <= (esizedif = Math.abs(et.getName().length() - keysize))) {
                    spawns.add(new ItemSpawn(is));
                } else {
                    try {
                        number = Integer.parseInt(args.get(args.size() - 1));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    spawns.add(new EntitySpawn(et, number));
                }
                return spawns;
            }
            if (is != null) {
                spawns.add(new ItemSpawn(is));
                return spawns;
            }
            if (et != null) {
                try {
                    number = Integer.parseInt(args.get(args.size() - 1));
                }
                catch (Exception e) {
                    // empty catch block
                }
                spawns.add(new EntitySpawn(et, number));
                return spawns;
            }
            String[] split = key.split(":");
            sg = SpawnController.getSpawnable(split[0]);
            number = 1;
            try {
                number = Integer.valueOf(split[1]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (sg != null) {
                for (int i = 0; i < number; ++i) {
                    spawns.add(sg);
                }
                return spawns;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public static TimedSpawn parseSpawn(String[] args) {
        List<SpawnInstance> spawn;
        ArrayList<String> spawnArgs = new ArrayList<String>();
        Integer fs = 0;
        Integer rs = -1;
        Integer ds = -1;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.contains("=")) {
                String[] as = arg.split("=");
                Integer time = null;
                try {
                    time = Integer.valueOf(as[1]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (as[0].equalsIgnoreCase("fs")) {
                    fs = time;
                    continue;
                }
                if (as[0].equalsIgnoreCase("rs") || as[0].equalsIgnoreCase("rt")) {
                    rs = time;
                    continue;
                }
                if (!as[0].equalsIgnoreCase("ds")) continue;
                ds = time;
                continue;
            }
            spawnArgs.add(arg);
        }
        int number = -1;
        if (spawnArgs.size() > 1) {
            try {
                number = Integer.parseInt((String)spawnArgs.get(spawnArgs.size() - 1));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (number == -1) {
            spawnArgs.add("1");
        }
        if ((spawn = SpawnSerializer.parseSpawnable(spawnArgs)) == null) {
            return null;
        }
        SpawnInstance si = spawn.get(0);
        if (si == null) {
            return null;
        }
        return new TimedSpawn(fs.intValue(), rs.intValue(), ds.intValue(), si);
    }

    public static TimedSpawn createTimedSpawn(SpawnInstance si, SpawnOptions so) {
        long fs = ((Integer)(so.options.containsKey((Object)SpawnOptions.SpawnOption.FIRST_SPAWN) ? so.options.get((Object)SpawnOptions.SpawnOption.FIRST_SPAWN) : Integer.valueOf(0))).intValue();
        long rs = ((Integer)(so.options.containsKey((Object)SpawnOptions.SpawnOption.RESPAWN) ? so.options.get((Object)SpawnOptions.SpawnOption.RESPAWN) : Integer.valueOf(30))).intValue();
        if (fs < 0L) {
            fs = 0L;
        }
        if (rs <= 0L) {
            rs = -1L;
        }
        long ds = ((Integer)(so.options.containsKey((Object)SpawnOptions.SpawnOption.DESPAWN) ? so.options.get((Object)SpawnOptions.SpawnOption.DESPAWN) : Integer.valueOf(-1))).intValue();
        return new TimedSpawn(fs, rs, ds, si);
    }
}

