/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.serializers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mc.alk.arena.controllers.ArenaAlterController;
import mc.alk.arena.controllers.containers.LobbyContainer;
import mc.alk.arena.controllers.containers.RoomContainer;
import mc.alk.arena.objects.ContainerState;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.serializers.BaseConfig;
import mc.alk.arena.util.Log;
import org.bukkit.configuration.ConfigurationSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateFlagSerializer
extends BaseConfig {
    public List<String> loadEnabled() {
        ConfigurationSection cs = this.config.getConfigurationSection("enabled");
        ArrayList<String> disabled = new ArrayList<String>();
        if (cs != null) {
            for (String name : cs.getKeys(false)) {
                if (cs.getBoolean(name)) continue;
                disabled.add(name);
            }
        }
        return disabled;
    }

    public void loadLobbyStates(Collection<LobbyContainer> lobbies) {
        ConfigurationSection cs = this.config.getConfigurationSection("closedLobbies");
        if (lobbies != null) {
            for (RoomContainer roomContainer : lobbies) {
                String name = roomContainer.getParams().getType().getName();
                if (name == null) continue;
                try {
                    String s = cs.getString(name, null);
                    if (s == null) continue;
                    ContainerState.AreaContainerState pst = ContainerState.AreaContainerState.valueOf(s);
                    roomContainer.setContainerState(ContainerState.toState(pst));
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            }
        }
    }

    public void loadContainerStates(Map<String, Arena> arenas) {
        ConfigurationSection cs = this.config.getConfigurationSection("closedContainers");
        if (cs == null) {
            return;
        }
        for (Arena a : arenas.values()) {
            ConfigurationSection cs2 = cs.getConfigurationSection(a.getName());
            if (cs2 == null) continue;
            try {
                ContainerState.AreaContainerState pst;
                String s = cs2.getString("arena", null);
                if (s != null) {
                    pst = ContainerState.AreaContainerState.valueOf(s);
                    a.setContainerState(ContainerState.toState(pst));
                }
                if ((s = cs2.getString("waitroom", null)) == null) continue;
                pst = ContainerState.AreaContainerState.valueOf(s);
                a.setContainerState(ArenaAlterController.ChangeType.WAITROOM, ContainerState.toState(pst));
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
    }

    public void save(Collection<String> disabled, Collection<LobbyContainer> collection, Map<String, Arena> arenaContainer) {
        ConfigurationSection cs = this.config.createSection("enabled");
        if (disabled != null) {
            for (String string : disabled) {
                cs.set(string, (Object)false);
            }
        }
        cs = this.config.createSection("closedLobbies");
        if (collection != null) {
            for (RoomContainer roomContainer : collection) {
                if (roomContainer.isOpen() || roomContainer.getParams().getType() == null) continue;
                cs.set(roomContainer.getParams().getType().getName(), (Object)roomContainer.getContainerState().getState().name());
            }
        }
        cs = this.config.createSection("closedContainers");
        if (arenaContainer != null) {
            for (Arena arena : arenaContainer.values()) {
                ConfigurationSection cs2 = cs.createSection(arena.getName());
                if (!arena.isOpen()) {
                    cs2.set("arena", (Object)arena.getContainerState().getState().name());
                }
                if (arena.getWaitroom() == null || arena.getWaitroom().isOpen()) continue;
                cs2.set("waitroom", (Object)arena.getWaitroom().getContainerState().getState().name());
            }
        }
        this.save();
    }
}

