/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.PlayerController;
import mc.alk.arena.controllers.plugins.TrackerController;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.WinLossDraw;
import mc.alk.arena.objects.stats.ArenaStat;
import mc.alk.arena.objects.stats.TrackerArenaStat;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.Log;
import mc.alk.tracker.Tracker;
import mc.alk.tracker.TrackerInterface;
import mc.alk.tracker.objects.Stat;
import mc.alk.tracker.objects.StatType;
import mc.alk.tracker.objects.WLT;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTInterface {
    public static Tracker battleTracker = null;
    public static TrackerInterface aBTI = null;
    private static HashMap<String, TrackerInterface> btis = new HashMap();
    private static HashMap<String, TrackerInterface> currentInterfaces = new HashMap();
    final TrackerInterface ti;
    boolean valid = false;

    public BTInterface(MatchParams mp) {
        this.ti = BTInterface.getInterface(mp);
        this.valid = battleTracker != null && this.ti != null;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Stat getRecord(TrackerInterface bti, ArenaTeam t) {
        try {
            return bti.getRecord(t.getBukkitPlayers());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return null;
        }
    }

    public Stat loadRecord(TrackerInterface bti, ArenaTeam t) {
        try {
            return bti.loadRecord(t.getBukkitPlayers());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return null;
        }
    }

    public static TrackerInterface getInterface(MatchParams mp) {
        if (mp == null) {
            return null;
        }
        String db = mp.getDBTableName();
        return db == null ? null : btis.get(db);
    }

    public static boolean hasInterface(MatchParams mp) {
        if (mp == null) {
            return false;
        }
        String db = mp.getDBTableName();
        return db != null && btis.containsKey(db);
    }

    public static void addRecord(TrackerInterface bti, Set<ArenaTeam> victors, Set<ArenaTeam> losers, Set<ArenaTeam> drawers, WinLossDraw wld, boolean teamRating) {
        if (victors != null) {
            HashSet<ArenaPlayer> winningPlayers = new HashSet<ArenaPlayer>();
            for (ArenaTeam w : victors) {
                winningPlayers.addAll(w.getPlayers());
            }
            WLT wlt = BTInterface.getWLT(wld);
            BTInterface.addRecord(bti, winningPlayers, losers, wlt, teamRating);
        }
    }

    public static WLT getWLT(WinLossDraw wld) {
        switch (wld) {
            case WIN: {
                return WLT.WIN;
            }
            case LOSS: {
                return WLT.LOSS;
            }
            case DRAW: {
                return WLT.TIE;
            }
        }
        return WLT.WIN;
    }

    public static void addRecord(TrackerInterface bti, Set<ArenaPlayer> players, Collection<ArenaTeam> losers, WLT win, boolean teamRating) {
        if (bti == null) {
            return;
        }
        try {
            Set<Player> winningPlayers = PlayerController.toPlayerSet(players);
            if (losers.size() == 1) {
                HashSet<Player> losingPlayers = new HashSet<Player>();
                for (ArenaTeam t : losers) {
                    losingPlayers.addAll(t.getBukkitPlayers());
                }
                if (Defaults.DEBUG_TRACKING) {
                    Log.info("BA Debug: addRecord ");
                }
                for (Player p : winningPlayers) {
                    if (!Defaults.DEBUG_TRACKING) continue;
                    Log.info("BA Debug: winner = " + p.getName());
                }
                for (Player p : losingPlayers) {
                    if (!Defaults.DEBUG_TRACKING) continue;
                    Log.info("BA Debug: loser = " + p.getName());
                }
                bti.addTeamRecord(winningPlayers, losingPlayers, WLT.WIN);
            } else {
                ArrayList<Set<Player>> plosers = new ArrayList<Set<Player>>();
                for (ArenaTeam t : losers) {
                    plosers.add(t.getBukkitPlayers());
                }
                bti.addRecordGroup(winningPlayers, plosers, WLT.WIN);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public static boolean addBTI(MatchParams pi) {
        if (battleTracker == null) {
            return false;
        }
        String dbName = pi.getDBTableName();
        TrackerInterface bti = btis.get(dbName);
        if (bti == null) {
            bti = currentInterfaces.get(dbName);
            if (bti == null) {
                battleTracker = (Tracker)Bukkit.getPluginManager().getPlugin("BattleTracker");
                if (battleTracker == null) {
                    return false;
                }
                bti = Tracker.getInterface((String)dbName);
                currentInterfaces.put(dbName, bti);
                if (aBTI == null) {
                    aBTI = bti;
                }
            }
            btis.put(dbName, bti);
        }
        return true;
    }

    public static void resumeTracking(ArenaPlayer p) {
        if (aBTI != null) {
            aBTI.resumeTracking(p.getName());
        }
    }

    public static void stopTracking(ArenaPlayer p) {
        if (aBTI != null) {
            aBTI.stopTracking(p.getName());
        }
    }

    public static void resumeTrackingMessages(ArenaPlayer p) {
        if (aBTI != null) {
            aBTI.resumeMessages(p.getName());
        }
    }

    public static void stopTrackingMessages(ArenaPlayer p) {
        if (aBTI != null) {
            aBTI.stopMessages(p.getName());
        }
    }

    public static void resumeTracking(Set<Player> players) {
        if (aBTI != null) {
            aBTI.resumeTracking(players);
        }
    }

    public static void stopTracking(Set<Player> players) {
        if (aBTI != null) {
            aBTI.stopTracking(players);
        }
    }

    public Integer getElo(ArenaTeam t) {
        if (!this.isValid()) {
            return 1250;
        }
        Stat s = this.getRecord(this.ti, t);
        return (int)(s == null ? 1250.0 : (double)s.getRating());
    }

    public Stat loadRecord(ArenaTeam team) {
        if (!this.isValid()) {
            return null;
        }
        return this.loadRecord(this.ti, team);
    }

    public Stat loadRecord(OfflinePlayer player) {
        if (!this.isValid()) {
            return null;
        }
        try {
            return this.ti.loadRecord(player);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return null;
        }
    }

    public static ArenaStat loadRecord(String dbName, ArenaPlayer ap) {
        TrackerInterface ti = btis.get(dbName);
        if (ti == null) {
            return TrackerController.BLANK_STAT;
        }
        Stat st = null;
        try {
            st = ti.loadPlayerRecord(ap.getName());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        return st == null ? TrackerController.BLANK_STAT : new TrackerArenaStat(dbName, st);
    }

    public static ArenaStat loadRecord(String dbName, ArenaTeam t) {
        TrackerInterface ti = btis.get(dbName);
        if (ti == null) {
            return TrackerController.BLANK_STAT;
        }
        Stat st = null;
        try {
            st = ti.loadRecord(t.getBukkitPlayers());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        return st == null ? TrackerController.BLANK_STAT : new TrackerArenaStat(dbName, st);
    }

    public String getRankMessage(OfflinePlayer player) {
        Stat stat = this.loadRecord(player);
        if (stat == null) {
            return "&eCouldn't find stats for player " + player.getName();
        }
        Integer rank = this.ti.getRank(player.getName());
        if (rank == null) {
            rank = -1;
        }
        return "&eRank:&6" + rank + "&e (&4" + stat.getWins() + "&e:&8" + stat.getLosses() + "&e)&6[" + stat.getRating() + "]&e" + ". Highest &6[" + stat.getMaxRating() + "]&e Longest Streak &b" + stat.getMaxStreak();
    }

    public boolean setRating(OfflinePlayer player, Integer elo) {
        return this.ti.setRating(player, elo.intValue());
    }

    public void resetStats() {
        this.ti.resetStats();
    }

    public void printTopX(CommandSender sender, int x, int minTeamSize, String headerMsg, String bodyMsg) {
        this.ti.printTopX(sender, StatType.RANKING, x, minTeamSize, headerMsg, bodyMsg);
    }

    public static void setTrackerPlugin(Plugin plugin) {
        battleTracker = (Tracker)plugin;
    }

    public static void addRecord(MatchParams mp, ArenaPlayer victor, ArenaPlayer loser, WinLossDraw wld) {
        TrackerInterface bti = BTInterface.getInterface(mp);
        if (bti != null) {
            switch (wld) {
                case DRAW: {
                    break;
                }
                case LOSS: {
                    break;
                }
                case UNKNOWN: {
                    break;
                }
                case WIN: {
                    break;
                }
            }
            bti.addPlayerRecord(victor.getName(), loser.getName(), BTInterface.getWLT(wld));
        }
    }

    public static void addRecord(MatchParams mp, Set<ArenaTeam> victors, Set<ArenaTeam> losers, Set<ArenaTeam> drawers, WinLossDraw wld, boolean teamRating) {
        TrackerInterface bti = BTInterface.getInterface(mp);
        if (bti != null) {
            try {
                BTInterface.addRecord(bti, victors, losers, drawers, wld, teamRating);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
    }
}

