/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import mc.alk.arena.controllers.Scheduler;
import mc.alk.arena.util.TimeUtil;
import org.bukkit.plugin.Plugin;

public class Countdown
implements Runnable {
    static int count = 0;
    int id = count++;
    final Long startTime;
    final Long expectedEndTime;
    final long interval;
    final CountdownCallback callback;
    final Plugin plugin;
    Integer timerId;
    boolean cancelOnExpire = true;
    boolean stop = false;
    long seconds;

    public Countdown(Plugin plugin, int seconds, int intervalSeconds, CountdownCallback callback) {
        this(plugin, (long)seconds, (long)intervalSeconds, callback);
    }

    public Countdown(Plugin plugin, long seconds, long intervalSeconds, CountdownCallback callback) {
        if (seconds > Integer.MAX_VALUE) {
            seconds = Integer.MAX_VALUE;
        }
        this.interval = intervalSeconds <= 0L ? seconds : intervalSeconds;
        this.callback = callback;
        this.plugin = plugin;
        long rem = seconds % this.interval;
        long time = (rem != 0L ? rem : this.interval) * 20L;
        this.seconds = seconds - (rem != 0L ? rem : this.interval);
        if (this.seconds < 0L) {
            this.seconds = 0L;
            time = 0L;
        }
        this.startTime = System.currentTimeMillis();
        this.expectedEndTime = this.startTime + seconds * 1000L;
        this.timerId = Scheduler.scheduleSynchronousTask(plugin, this, (int)time);
    }

    public void setCancelOnExpire(boolean cancel) {
        this.cancelOnExpire = cancel;
    }

    public void run() {
        if (this.stop) {
            return;
        }
        boolean continueOn = this.callback.intervalTick((int)this.seconds);
        this.timerId = null;
        if (!continueOn) {
            return;
        }
        TimeUtil.testClock();
        if (!(this.stop || this.seconds <= 0L && this.cancelOnExpire)) {
            this.timerId = Scheduler.scheduleSynchronousTask(this.plugin, this, this.interval * 20L);
        }
        this.seconds -= this.interval;
    }

    public void stop() {
        this.stop = true;
        if (this.timerId != null) {
            Scheduler.cancelTask(this.timerId);
            this.timerId = null;
        }
    }

    public String toString() {
        return "[Countdown id=" + this.getID() + " " + this.seconds + ":" + this.interval + " timerid=" + this.timerId + "]";
    }

    public Long getTimeRemaining() {
        return this.expectedEndTime - System.currentTimeMillis();
    }

    public int getID() {
        return this.id;
    }

    public static interface CountdownCallback {
        public boolean intervalTick(int var1);
    }
}

