/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.util;

import mc.alk.arena.controllers.PlayerController;
import mc.alk.arena.objects.ArenaPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public class DmgDeathUtil {
    public static ArenaPlayer getPlayerCause(PlayerDeathEvent event) {
        return DmgDeathUtil.getPlayerCause(event.getEntity().getLastDamageCause());
    }

    public static ArenaPlayer getPlayerCause(EntityDamageEvent lastDamageCause) {
        if (lastDamageCause == null) {
            return null;
        }
        if (!(lastDamageCause instanceof EntityDamageByEntityEvent)) {
            return null;
        }
        EntityDamageByEntityEvent edbee = (EntityDamageByEntityEvent)lastDamageCause;
        Entity entityLastDamage = edbee.getDamager();
        return entityLastDamage != null ? DmgDeathUtil.getPlayerCause(entityLastDamage) : null;
    }

    public static ArenaPlayer getPlayerCause(Entity lastDamageCause) {
        if (lastDamageCause == null) {
            return null;
        }
        if (lastDamageCause instanceof Projectile) {
            Projectile proj = (Projectile)lastDamageCause;
            if (proj.getShooter() instanceof Player) {
                return PlayerController.toArenaPlayer((Player)proj.getShooter());
            }
            return null;
        }
        if (!(lastDamageCause instanceof Player)) {
            return null;
        }
        return PlayerController.toArenaPlayer((Player)lastDamageCause);
    }
}

